#!/bin/ksh
#This script is used to list unused images in the source code
#set -x

echo Number of arguments [[ $# -eq 0 ]]
#No arguments
if [[ $# -eq 0 ]];then
	
	DIR=./
	SOURCE=../
	echo NO arguments, assuming this dir 
else
	DIR=$1
	SOURCE=$2
fi

echo Scanning for all [.gif, .jpg] images found in DIR: $DIR if they are used in SOURCE DIR: $SOURCE


TEMPDIR=/tmp/dfind.$$

mkdir $TEMPDIR
(cd $DIR; find . -name "*.gif" -o -name "*.jpg" | sed -e "s|^\./||g" | sed -e "s|\.|\\\.|g") > $TEMPDIR/dlist.lst

find $SOURCE -name "*.java" | xargs cat > $TEMPDIR/allsource.txt

UNUSED_LIST=unused.txt
echo "#Unused images listning" > $UNUSED_LIST

HTML_FILE=unusedimages.html
echo "<html>" > $HTML_FILE
echo "<head>" >> $HTML_FILE

echo "<table>" >> $HTML_FILE
for a in $(cat $TEMPDIR/dlist.lst); do
    if ! egrep '[/"]'$a'"' $TEMPDIR/allsource.txt >/dev/null; then
	echo "<tr><td>$(eval echo $a)</td><td><img border='0' src='./$(eval echo $a)'></td></tr>" >> $HTML_FILE
	echo $(eval echo $a) >> $UNUSED_LIST
	echo "Not used: $(eval echo $a)"
    fi
done
echo "</table>" >> $HTML_FILE
echo "</head>" >> $HTML_FILE
echo "</html>" >> $HTML_FILE
echo 
echo Result is listed in file $UNUSED_LIST, and can be viewed in html file : $HTML_FILE 
rm -rf $TEMPDIR
# Fini

