/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable.array;

import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginProfileUtil;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.ArrayModel;
import ericsson.vareditor.variable.Variable;
import ericsson.vareditor.variable.array.ObjectArrayDescription;
import ericsson.vareditor.variable.array.table.TableSorter;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ObjectArrayModel
extends DefaultTableModel {
    private static final String KEY_ATTRIBUTE = "key";
    private static final String VALUE_ATTRIBUTE = "value";
    private String myDialogTitle = "Object array";
    private String myTag = "ObjectArray";
    private int myMaxNumberOfRows = -1;
    protected ObjectArrayDescription myDescription = null;
    private DefaultValueResolver myDefaultValueResolver;
    private int[] myUniqueColumn = new int[0];

    public ObjectArrayModel(String label, String tag, List<Object[]> data, ObjectArrayDescription desc) {
        this(label, tag, data, desc, (DefaultValueResolver)new DataTypeDefaultResolver());
    }

    public ObjectArrayModel(String label, String tag, List<Object[]> data, ObjectArrayDescription desc, DefaultValueResolver resolver) {
        this(label, tag, desc, resolver);
        if (data == null) {
            throw new IllegalArgumentException("Data parameter cannot be null.");
        }
        for (int i = 0; i < data.size(); ++i) {
            Object[] row = data.get(i);
            if (row.length == desc.getNumberOfColumns()) continue;
            throw new IllegalArgumentException("Row " + i + " does not have the correct number of columns, expected " + desc.getNumberOfColumns() + " but was " + row.length + ".");
        }
        this.setInitialDataInInternalVector(data);
    }

    public ObjectArrayModel(String label, String tag, Element iterator, ObjectArrayDescription desc) {
        this(label, tag, iterator, desc, (DefaultValueResolver)new DataTypeDefaultResolver());
    }

    public ObjectArrayModel(String label, String tag, Element iterator, ObjectArrayDescription desc, DefaultValueResolver resolver) {
        this(label, tag, desc, resolver);
        List<Object[]> dataList = this.extractListFromElement(iterator);
        this.setInitialDataInInternalVector(dataList);
    }

    protected ObjectArrayModel(String label, String tag, ObjectArrayDescription desc, DefaultValueResolver resolver) {
        super(0, desc.getNumberOfColumns());
        Vector<String> columnNames = new Vector<String>();
        columnNames.addAll(desc.getColumnNames());
        super.setColumnIdentifiers(columnNames);
        this.myDialogTitle = label;
        this.myTag = tag;
        this.myDescription = desc;
        this.myDefaultValueResolver = resolver;
    }

    public ObjectArrayDescription getDataDescription() {
        return this.myDescription;
    }

    public void initData(Element configElement) {
        this.getDataVector().clear();
        List<Object[]> data = this.extractListFromElement(configElement);
        this.setInitialDataInInternalVector(data);
    }

    private void setInitialDataInInternalVector(List<Object[]> data) {
        for (Object[] row : data) {
            this.addRow(row);
        }
    }

    public String getUniqueColumnName() {
        if (this.myUniqueColumn.length > 0) {
            StringBuffer labels = new StringBuffer();
            for (int col : this.myUniqueColumn) {
                labels.append(this.myDescription.getLabel(col));
                labels.append(", ");
            }
            return labels.substring(0, labels.length() - 2);
        }
        return "";
    }

    public void setUniqueColumns(int[] cols) {
        this.myUniqueColumn = Arrays.copyOf(cols, cols.length);
    }

    public int[] getUniqueColumns() {
        return Arrays.copyOf(this.myUniqueColumn, this.myUniqueColumn.length);
    }

    public boolean checkIfColumnUnique(Object[] value) {
        if (this.myUniqueColumn.length > 0) {
            Object[] dataVectors;
            for (Object row : dataVectors = this.getDataVector().toArray()) {
                Vector rowVector = (Vector)row;
                boolean allMatch = true;
                for (int col : this.myUniqueColumn) {
                    if (rowVector.get(col).equals(value[col])) continue;
                    allMatch = false;
                    break;
                }
                if (!allMatch) continue;
                return false;
            }
        }
        return true;
    }

    public Object[] getRow(int row) {
        Vector rowVector = this.getDataVector().get(row);
        return rowVector.toArray();
    }

    public Collection<String> getUsedTdfs(ClassRepository classRepository) {
        Object[] dataVectors;
        HashSet<String> usedTdfs = new HashSet<String>();
        for (Object row : dataVectors = this.getDataVector().toArray()) {
            Vector rowVector = (Vector)row;
            for (Object columnValue : rowVector) {
                if (!Objects.nonNull(columnValue) || !FieldOrientedPluginProfileUtil.fieldIsTDF(columnValue.toString(), classRepository)) continue;
                usedTdfs.add(columnValue.toString());
            }
        }
        return usedTdfs;
    }

    protected List<Object[]> extractListFromElement(Element iterator) {
        ArrayList<Object[]> datalist = new ArrayList<Object[]>();
        NodeList elements = iterator.getElementsByTagName(this.myTag);
        for (int rowIndex = 0; rowIndex < elements.getLength(); ++rowIndex) {
            Element element = (Element)elements.item(rowIndex);
            Object[] valueArray = new Object[this.myDescription.getNumberOfColumns()];
            for (int columnIndex = 0; columnIndex < this.myDescription.getNumberOfColumns(); ++columnIndex) {
                ValueResolver resolver = this.myDescription.getValueResolver(columnIndex);
                Object value = null;
                if (this.myDescription.getColumnCollectionType(columnIndex) == FieldHierarchyNode.ComplexType.NONE) {
                    String attrName = this.myDescription.getAttribute(columnIndex);
                    String valueString = element.hasAttribute(attrName) ? element.getAttribute(attrName) : null;
                    value = this.parseValue(valueString, resolver, columnIndex, rowIndex);
                } else {
                    value = this.parseCollection(element, resolver, columnIndex, rowIndex);
                }
                valueArray[columnIndex] = this.myDescription.convertValueFromXml(columnIndex, value);
            }
            datalist.add(valueArray);
        }
        return datalist;
    }

    protected Object parseCollection(Element element, ValueResolver resolver, int columnIndex, int rowIndex) {
        List<Element> childElements = XMLUtil.getElementNodesNamed(this.myDescription.getAttribute(columnIndex), element.getChildNodes());
        Object value = null;
        switch (this.myDescription.getColumnCollectionType(columnIndex)) {
            case ARRAY: {
                value = this.parseArray(childElements, resolver, columnIndex, rowIndex);
                break;
            }
            case MAP: {
                value = this.parseMap(childElements, resolver, columnIndex, rowIndex);
                break;
            }
            case SET: {
                value = this.parseSet(childElements, resolver, columnIndex, rowIndex);
                break;
            }
        }
        return value;
    }

    private Object parseArray(List<Element> childElements, ValueResolver resolver, int columnIndex, int rowIndex) {
        ArrayModel model = new ArrayModel(this.createEmptyArrayValue(resolver));
        for (int i = 0; i < childElements.size(); ++i) {
            Element childElement = childElements.get(i);
            if (!childElement.hasAttribute(KEY_ATTRIBUTE) || !childElement.hasAttribute(VALUE_ATTRIBUTE)) continue;
            Integer index = null;
            try {
                index = Integer.parseInt(childElement.getAttribute(KEY_ATTRIBUTE));
            }
            catch (NumberFormatException e) {
                continue;
            }
            model.addRow(new Object[]{index, this.parseValue(childElement.getAttribute(VALUE_ATTRIBUTE), resolver, columnIndex, rowIndex)});
        }
        return model;
    }

    private Object[] createEmptyArrayValue(ValueResolver resolver) {
        Object[] array = new Object[]{new Integer[0], this.createEmptyArrayBasedOnResolver(resolver)};
        return array;
    }

    private Object parseMap(List<Element> childElements, ValueResolver resolver, int columnIndex, int rowIndex) {
        ArrayModel model = new ArrayModel(this.createEmptyMapValue(resolver));
        for (int i = 0; i < childElements.size(); ++i) {
            Element childElement = childElements.get(i);
            if (!childElement.hasAttribute(KEY_ATTRIBUTE) || !childElement.hasAttribute(VALUE_ATTRIBUTE)) continue;
            model.addRow(new Object[]{childElement.getAttribute(KEY_ATTRIBUTE), this.parseValue(childElement.getAttribute(VALUE_ATTRIBUTE), resolver, columnIndex, rowIndex)});
        }
        return model;
    }

    private Object[] createEmptyMapValue(ValueResolver resolver) {
        Object[] array = new Object[]{new String[0], this.createEmptyArrayBasedOnResolver(resolver)};
        return array;
    }

    private Object parseSet(List<Element> childElements, ValueResolver resolver, int columnIndex, int rowIndex) {
        ArrayModel model = new ArrayModel(this.createEmptyArrayBasedOnResolver(resolver));
        for (int i = 0; i < childElements.size(); ++i) {
            Element childElement = childElements.get(i);
            if (!childElement.hasAttribute(VALUE_ATTRIBUTE)) continue;
            model.addRow(new Object[]{this.parseValue(childElement.getAttribute(VALUE_ATTRIBUTE), resolver, columnIndex, rowIndex)});
        }
        return model;
    }

    private Object[] createEmptyArrayBasedOnResolver(ValueResolver resolver) {
        return (Object[])Array.newInstance(resolver.createDefaultInstance().getClass(), 0);
    }

    protected Object parseValue(String stringValue, ValueResolver resolver, int columnIndex, int rowIndex) {
        Object parsedValue = null;
        if (stringValue != null) {
            try {
                parsedValue = resolver.parseValueString(stringValue);
            }
            catch (Exception e) {
                parsedValue = null;
            }
        }
        if (parsedValue == null) {
            parsedValue = this.myDefaultValueResolver != null ? this.myDefaultValueResolver.getDefaultValue(this.myDescription.getLabel(columnIndex), resolver.getDataType(), rowIndex) : this.myDescription.getDefaultValue(columnIndex);
        }
        return parsedValue;
    }

    public void setMaxNumberOfRows(int max) {
        this.myMaxNumberOfRows = max;
    }

    public int getMaxNumberOfRows() {
        return this.myMaxNumberOfRows;
    }

    public void removeElementAt(int selectedRow) {
        this.removeRow(selectedRow);
    }

    public VarTableModel createVarTableModel(Object[] values) {
        ArrayList<Variable> varList = new ArrayList<Variable>();
        for (int ii = 0; ii < values.length; ++ii) {
            varList.add(this.myDescription.createVariable(ii, values[ii]));
        }
        VarTableModel model = new VarTableModel(varList);
        this.myDescription.setDataItemToList(model);
        return model;
    }

    public VarTableModel createVarTableModel() {
        Object[] values = new Object[this.myDescription.getNumberOfColumns()];
        for (int ii = 0; ii < values.length; ++ii) {
            values[ii] = this.myDescription.getDefaultValue(ii);
        }
        return this.createVarTableModel(values);
    }

    public String getDialogTitle() {
        return this.myDialogTitle;
    }

    @Override
    public int getColumnCount() {
        return this.myDescription.getNumberOfColumns();
    }

    @Override
    public String getColumnName(int columnIndex) {
        return this.myDescription.getLabel(columnIndex);
    }

    public int getColumnIndexByName(String columnName) {
        String[] array = this.myDescription.getColumnNames().toArray(new String[0]);
        int index = -1;
        for (int i = 0; i < array.length; ++i) {
            if (!array[i].equals(columnName)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        return false;
    }

    public boolean isEmpty() {
        return this.getRowCount() <= 0;
    }

    public Object[] getValueArray(int row) {
        return this.getRow(row);
    }

    @Override
    public void insertRow(int row, Object[] rowData) {
        Vector<Vector> data = this.getDataVector();
        if (data.isEmpty()) {
            this.addRow(rowData);
        } else {
            super.insertRow(row, rowData);
        }
    }

    public String getXml() {
        Object[] data;
        StringBuilder builder = new StringBuilder("");
        for (Object row : data = this.getDataVector().toArray()) {
            Vector vectorRow = (Vector)row;
            if (vectorRow == null) continue;
            builder.append("<");
            builder.append(this.myTag);
            builder.append(" ");
            for (int column = 0; column < this.myDescription.getNumberOfColumns(); ++column) {
                if (this.myDescription.getColumnCollectionType(column) != FieldHierarchyNode.ComplexType.NONE) continue;
                builder.append(this.myDescription.getAttribute(column));
                builder.append("=\"");
                String attributeValue = this.myDescription.toXmlAttributeValue(column, vectorRow.get(column));
                builder.append(XMLUtil.escape(attributeValue));
                builder.append("\" ");
            }
            if (this.descriptionContainsCollection()) {
                builder.append(">\n");
                this.printCollectionData(vectorRow, builder);
                builder.append("</").append(this.myTag).append(">\n");
                continue;
            }
            builder.append("/>\n");
        }
        return builder.toString();
    }

    protected void printCollectionData(Vector<?> vectorRow, StringBuilder builder) {
        block4: for (int column = 0; column < this.myDescription.getNumberOfColumns(); ++column) {
            FieldHierarchyNode.ComplexType type = this.myDescription.getColumnCollectionType(column);
            switch (type) {
                case ARRAY: 
                case MAP: {
                    int row;
                    ArrayModel model = (ArrayModel)vectorRow.get(column);
                    for (row = 0; row < model.getRowCount(); ++row) {
                        this.printCollectionEntity(this.myDescription.getAttribute(column), String.valueOf(model.getValueAt(row, 0)), this.myDescription.toXmlAttributeValue(column, model.getValueAt(row, 1)), builder);
                    }
                    continue block4;
                }
                case SET: {
                    int row;
                    ArrayModel model = (ArrayModel)vectorRow.get(column);
                    for (row = 0; row < model.getRowCount(); ++row) {
                        this.printCollectionEntity(this.myDescription.getAttribute(column), null, this.myDescription.toXmlAttributeValue(column, model.getValueAt(row, 1)), builder);
                    }
                    continue block4;
                }
            }
        }
    }

    private void printCollectionEntity(String tag, String keyString, String objectString, StringBuilder builder) {
        builder.append("<").append(tag).append(" ");
        if (keyString != null) {
            builder.append(XMLUtil.wrapValueOrEmptyStringInAttribute(KEY_ATTRIBUTE, keyString)).append(" ");
        }
        builder.append(XMLUtil.wrapValueOrEmptyStringInAttribute(VALUE_ATTRIBUTE, objectString)).append(" />\n");
    }

    private boolean descriptionContainsCollection() {
        boolean result = false;
        for (int i = 0; i < this.myDescription.getNumberOfColumns(); ++i) {
            if (this.myDescription.getColumnCollectionType(i) == FieldHierarchyNode.ComplexType.NONE) continue;
            result = true;
            break;
        }
        return result;
    }

    public void sortByColumn(int sortCol, boolean isAscent) {
        TableSorter sorter = new TableSorter(this);
        sorter.sortTable(sortCol, isAscent);
        this.fireTableDataChanged();
    }

    public void moveUp(int row) {
        this.moveRow(row, row, row - 1);
    }

    public TableCellRenderer getTableCellRenderer(int col) {
        return this.myDescription.getTableCellRenderer(col);
    }

    public Object[] getColumnArray(int column) {
        Object[] array = this.myDescription.createDefaultArrayForColumn(column, this.getRowCount());
        for (int row = 0; row < this.getRowCount(); ++row) {
            array[row] = this.getValueAt(row, column);
        }
        return array;
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        Object[] objectArray = (Object[])aValue;
        for (int i = 0; i < objectArray.length; ++i) {
            super.setValueAt(objectArray[i], rowIndex, i);
        }
        this.fireTableDataChanged();
    }

    @Override
    public void addColumn(Object columnName, Object[] columnData) {
        throw new UnsupportedOperationException("Not allowed to add column in " + this.getClass());
    }

    public void addColumn(Object columnName, Vector columnData) {
        throw new UnsupportedOperationException("Not allowed to add column in " + this.getClass());
    }

    @Override
    public void addColumn(Object columnName) {
        throw new UnsupportedOperationException("Not allowed to add column in " + this.getClass());
    }

    @Override
    public void setColumnCount(int columnCount) {
        throw new UnsupportedOperationException("Not allowed to set column count in " + this.getClass());
    }

    @Override
    public void setColumnIdentifiers(Object[] newIdentifiers) {
        throw new UnsupportedOperationException("Not allowed to set column identifiers in " + this.getClass());
    }

    public void setColumnIdentifiers(Vector columnIdentifiers) {
        throw new UnsupportedOperationException("Not allowed to set column identifiers in " + this.getClass());
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (Object row : this.getDataVector().toArray()) {
            if (row == null) continue;
            Vector vectorRow = (Vector)row;
            for (int column = 0; column < this.myDescription.getNumberOfColumns(); ++column) {
                builder.append(this.myDescription.getAttribute(column));
                builder.append("=\"");
                builder.append(this.myDescription.toXmlAttributeValue(column, vectorRow.get(column)));
                builder.append("\" ");
            }
        }
        return builder.toString();
    }

    static class DataTypeDefaultResolver
    implements DefaultValueResolver {
        DataTypeDefaultResolver() {
        }

        @Override
        public Object getDefaultValue(String field, DataType dataType, int index) {
            return dataType.createDefaultInstance();
        }
    }

    public static interface DefaultValueResolver {
        public Object getDefaultValue(String var1, DataType var2, int var3);
    }
}

