/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.vareditor.variable.AbstractDateStringVariable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateStringVariable
extends AbstractDateStringVariable {
    protected String myCurrentDatePattern;
    protected String DEFAUL_DATE_PATTERN = "yyyyMMdd";
    private final int MAXIMUM_YEAR_VALUE = 2038;
    private final int MINIMUM_YEAR_VALUE = 1970;
    protected String[] ALLOWED_FULL_DATE_FORMATS = new String[]{"dd-MMM-yyyy", "MM/dd/yyyy", "MM-dd-yyyy", "yyyyMMdd", "yyyy/MM/dd", "yyyy-MM-dd"};
    protected SimpleDateFormat dateFormat = new SimpleDateFormat();

    public DateStringVariable(String label, String value, String pattern) {
        super(label, value);
        this.myCurrentDatePattern = pattern;
    }

    public DateStringVariable(String label, String value, String pattern, String[] myNewDefaultPattern) {
        super(label, value);
        this.myCurrentDatePattern = pattern;
        this.ALLOWED_FULL_DATE_FORMATS = myNewDefaultPattern;
    }

    @Override
    public String getTypename() {
        return "Date";
    }

    public Class<Date> getValueClass() {
        return Date.class;
    }

    @Override
    public int getFormat() {
        return 9;
    }

    @Override
    protected void setVarValue(Object v) {
        this.setVarValue(v.toString());
    }

    @Override
    protected void setVarValue(String v) {
        this.setEditorValue(this.myValue.toString());
    }

    @Override
    public boolean isValueValid() {
        boolean isValid = false;
        this.dateFormat.setLenient(false);
        for (int i = 0; i < this.ALLOWED_FULL_DATE_FORMATS.length; ++i) {
            this.dateFormat.applyPattern(this.ALLOWED_FULL_DATE_FORMATS[i]);
            try {
                Date myDate = this.dateFormat.parse(this.myValue.toString());
                if (this.checkMinMaxYear(myDate)) {
                    isValid = true;
                    this.myCurrentDatePattern = this.ALLOWED_FULL_DATE_FORMATS[i];
                    break;
                }
                isValid = false;
                break;
            }
            catch (ParseException e) {
                isValid = false;
                continue;
            }
        }
        return isValid;
    }

    private boolean checkMinMaxYear(Date myDate) {
        Calendar cal = Calendar.getInstance();
        Calendar calMin = Calendar.getInstance();
        Calendar calMax = Calendar.getInstance();
        calMax.set(1, this.MAXIMUM_YEAR_VALUE);
        calMin.set(1, this.MINIMUM_YEAR_VALUE);
        cal.setTime(myDate);
        System.out.println("-Start");
        System.out.println("the year :" + cal.get(1));
        System.out.println("result : " + (cal.after(calMin) && cal.before(calMax)));
        System.out.println("-end");
        return cal.after(calMin) && cal.before(calMax);
    }

    @Override
    public String getValueString() {
        String myDateAsDefaultStringValue;
        this.dateFormat.applyPattern(this.myCurrentDatePattern);
        try {
            Date tmpDate = this.dateFormat.parse(this.myValue.toString());
            this.dateFormat.applyPattern(this.DEFAUL_DATE_PATTERN);
            myDateAsDefaultStringValue = this.dateFormat.format(tmpDate);
        }
        catch (ParseException e) {
            myDateAsDefaultStringValue = this.myValue.toString();
        }
        return myDateAsDefaultStringValue;
    }

    public void setCurrentPattern(String myPattern) {
        this.myCurrentDatePattern = myPattern;
    }

    public void setDefaultPattern(String myPattern) {
        this.DEFAUL_DATE_PATTERN = myPattern;
    }

    public void setAllowedPatterns(String[] myAllowedFormats) {
        this.ALLOWED_FULL_DATE_FORMATS = myAllowedFormats;
    }
}

