/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import com.ericsson.ere.datatype.EREDate;
import com.ericsson.ere.datatype.EREDateFactory;
import com.ericsson.ere.datatype.EREDateUtil;
import com.ericsson.ere.datatype.ERETime;
import com.ericsson.ere.datatype.ERETimeFactory;
import com.ericsson.ere.datatype.ERETimeUtil;
import com.ericsson.ere.gui.util.DatePanel;
import com.ericsson.ere.swing.EDT;
import ericsson.ere.datatype.Time;
import ericsson.ere.management.DateUtil;
import ericsson.vareditor.variable.PanelVariable;
import ericsson.vareditor.variable.PanelVariableEditor;
import java.io.PrintWriter;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;

public class DateAndTimeVariable
extends PanelVariable {
    private static final String[] DATE_TIME_FORMATS = DatePanel.createFormatString();
    private Content myContent = Content.DATE_TIME;
    private String myBOTText = "";
    private String myEOTText = "";

    public DateAndTimeVariable(String label) {
        super(label);
        this.myValue = new Time().getCalendar();
    }

    public DateAndTimeVariable(String label, Content newContent) {
        super(label);
        this.myContent = newContent;
        this.myValue = new Time().getCalendar();
    }

    public DateAndTimeVariable(String label, Content newContent, String newValue) {
        super(label);
        this.myContent = newContent;
        Calendar cal = null;
        try {
            cal = DateAndTimeVariable.quickParse(newValue);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        this.myValue = cal != null ? cal : new Time().getCalendar();
    }

    private static Calendar quickParse(String str) throws ParseException {
        Date date;
        Calendar cal = DateUtil.optimizedStringToCalendar(str);
        if (cal == null && (date = DateUtil.stringToDate(str, DATE_TIME_FORMATS)) != null) {
            cal = DateUtil.dateToCalendar(date);
        }
        return cal;
    }

    public DateAndTimeVariable(String label, Content newContent, Calendar newValue) {
        super(label);
        this.myContent = newContent;
        this.myValue = newValue.clone();
    }

    @Deprecated
    public DateAndTimeVariable(DateAndTimeVariable v) {
        super(v);
        throw new IllegalArgumentException("Use clone() instead.");
    }

    @Override
    protected PanelVariableEditor createPanelVariableEditor() {
        DatePanel.Mode theMode;
        switch (this.myContent) {
            case DATE: {
                theMode = DatePanel.Mode.DATE_MODE;
                break;
            }
            case TIME: {
                theMode = DatePanel.Mode.TIME_MODE;
                break;
            }
            default: {
                theMode = DatePanel.Mode.DATETIME_MODE;
            }
        }
        if (this.myValue instanceof String) {
            this.myPanelVariableEditor = new DatePanel((String)this.myValue, theMode);
        } else if (this.myValue instanceof ERETime && this.myContent == Content.DATE_TIME) {
            this.myPanelVariableEditor = new DatePanel((ERETime)this.myValue);
        } else if (this.myValue instanceof EREDate && this.myContent == Content.DATE) {
            this.myPanelVariableEditor = new DatePanel((EREDate)this.myValue);
        } else if (this.myValue instanceof Calendar) {
            this.myPanelVariableEditor = new DatePanel((Calendar)this.myValue, theMode);
        }
        ((DatePanel)this.myPanelVariableEditor).setBeginningOfTimeText(this.myBOTText);
        ((DatePanel)this.myPanelVariableEditor).setEndOfTimeText(this.myEOTText);
        ((DatePanel)this.myPanelVariableEditor).setAllowEdit(this.myEditIsAllowed);
        return this.myPanelVariableEditor;
    }

    @Override
    protected void validate() {
        this.myIsValid = true;
        if (this.myPanelVariableEditor != null) {
            this.myIsValid = this.myPanelVariableEditor.isEditorValueValid();
        } else if (this.myValue instanceof String) {
            this.myIsValid = false;
        }
    }

    @Override
    public Object clone() {
        DateAndTimeVariable clone;
        if (this.myValue instanceof Calendar) {
            Calendar theCalendar = (Calendar)((Calendar)this.myValue).clone();
            clone = new DateAndTimeVariable(this.myLabel, this.myContent, theCalendar);
        } else if (this.myContent == Content.DATE && EREDateUtil.isBoundaryDate(this.myValue) || this.myContent == Content.DATE_TIME && ERETimeUtil.isBoundaryDate(this.myValue)) {
            clone = new DateAndTimeVariable(this.myLabel, this.myContent);
            clone.setValue(this.myValue);
            clone.setBeginningOfTimeText(this.myBOTText);
            clone.setEndOfTimeText(this.myEOTText);
        } else {
            throw new IllegalArgumentException("Value of original variable is not a Calendar.");
        }
        return clone;
    }

    @Override
    public Object getValueObject() {
        Object ret = null;
        if (this.myPanelVariableEditor != null) {
            this.myValue = this.myPanelVariableEditor.getEditorValue();
        } else if (!this.myIsValid) {
            switch (this.myContent) {
                case DATE_TIME: {
                    ret = ERETimeFactory.now();
                    break;
                }
                case TIME: {
                    ret = Calendar.getInstance().getTime();
                    break;
                }
                default: {
                    ret = EREDateFactory.today();
                }
            }
        }
        if (ret == null) {
            this.resetUnusedCalendarFields();
            switch (this.myContent) {
                case DATE_TIME: {
                    ret = this.myValue instanceof Calendar ? ERETimeFactory.createFromCalendar((Calendar)this.myValue) : this.myValue;
                    break;
                }
                case TIME: {
                    ret = ((Calendar)this.myValue).getTime().clone();
                    break;
                }
                case DATE: {
                    ret = this.myValue instanceof Calendar ? EREDateFactory.createFromCalendar((Calendar)this.myValue) : this.myValue;
                    break;
                }
                default: {
                    ret = EREDateFactory.createFromCalendar((Calendar)this.myValue);
                }
            }
        }
        return ret;
    }

    @Override
    public String getValueString() {
        if (this.myPanelVariableEditor != null) {
            this.myValue = this.myPanelVariableEditor.getEditorValue();
            this.myIsValid = this.myPanelVariableEditor.isEditorValueValid();
        }
        this.resetUnusedCalendarFields();
        if (this.myValue instanceof String) {
            return (String)this.myValue;
        }
        String valueString = this.myContent == Content.DATE && this.myValue instanceof EREDate ? (EREDateUtil.isBoundaryDate(this.myValue) ? this.myValue.toString() : DateUtil.formatISODate((EREDate)this.myValue)) : (this.myContent == Content.DATE_TIME && this.myValue instanceof ERETime ? (ERETimeUtil.isBoundaryDate(this.myValue) ? this.myValue.toString() : DateUtil.formatISODate((ERETime)this.myValue)) : DateUtil.formatISODateTime((Calendar)this.myValue, false));
        return valueString;
    }

    @Override
    protected void setVarValue(Object v) {
        if (v instanceof Calendar) {
            this.myValue = ((Calendar)v).clone();
        } else if (v instanceof EREDate) {
            this.myValue = EREDateUtil.isBoundaryDate(v) ? v : ((EREDate)v).asCalendar();
        } else if (v instanceof Date) {
            this.myValue = DateUtil.dateToCalendar((Date)v);
        } else if (v instanceof Time) {
            this.myValue = ((Time)v).getCalendar();
        } else if (v instanceof String) {
            this.setVarValue((String)v);
        } else {
            throw new IllegalArgumentException("Unhandled object in DateAndTimeVariable");
        }
        this.setCurrentValueOnDatePanel();
        this.validate();
    }

    @Override
    protected void setVarValue(String v) {
        try {
            if (Content.DATE == this.myContent || Content.DATE_TIME == this.myContent) {
                if (EREDateUtil.isBoundaryDateDefaultLabel(v)) {
                    this.myValue = EREDate.BEGINNING_OF_TIME.toString().equals(v) ? EREDate.BEGINNING_OF_TIME : EREDate.END_OF_TIME;
                } else if (Content.DATE == this.myContent) {
                    try {
                        this.myValue = DateUtil.dateToCalendar(DateUtil.stringToDate(v, DateUtil.DATE_TEXT_FORMAT));
                    }
                    catch (ParseException pE) {
                        this.myValue = EREDateFactory.parseDateString(v);
                    }
                } else {
                    this.myValue = DateUtil.stringToCalendar(v);
                }
            } else {
                this.myValue = DateUtil.dateToCalendar(DateUtil.stringToDate(v, DateUtil.TIMEOFDAY_TEXT_FORMAT));
            }
        }
        catch (Exception e) {
            this.myValue = v;
        }
        if (this.myPanelVariableEditor != null) {
            this.setCurrentValueOnDatePanel();
        }
        this.validate();
    }

    private void setCurrentValueOnDatePanel() {
        if (this.myPanelVariableEditor == null) {
            return;
        }
        DatePanel datePanel = (DatePanel)this.myPanelVariableEditor;
        if (this.myContent == Content.DATE_TIME && this.myValue instanceof ERETime) {
            datePanel.setValue((ERETime)this.myValue);
        } else if (this.myContent == Content.DATE && this.myValue instanceof EREDate) {
            datePanel.setValue((EREDate)this.myValue);
        } else if (this.myValue instanceof Calendar) {
            datePanel.setValue((Calendar)this.myValue);
        } else {
            datePanel.setValue((String)this.myValue);
        }
        datePanel.updateEditorBackground();
    }

    public boolean isDateContent() {
        return this.myContent == Content.DATE;
    }

    public boolean isTimeContent() {
        return this.myContent == Content.TIME;
    }

    public boolean isDateTimeContent() {
        return this.myContent == Content.DATE_TIME;
    }

    public void resetUnusedCalendarFields() {
        if (this.myValue != null && this.myValue instanceof Calendar) {
            Calendar myCal = (Calendar)this.myValue;
            if (this.myContent == Content.DATE) {
                myCal.set(11, 0);
                myCal.set(12, 0);
                myCal.set(13, 0);
                myCal.set(14, 0);
            } else if (this.myContent == Content.TIME) {
                myCal.set(2000, 1, 1);
                myCal.set(14, 0);
            } else {
                myCal.set(14, 0);
            }
            this.myValue = myCal;
        }
    }

    @Override
    public Class<?> getValueClass() {
        if (this.myContent == Content.DATE_TIME) {
            return ERETime.class;
        }
        return Date.class;
    }

    @Override
    public String getTypename() {
        if (this.myContent == Content.DATE_TIME) {
            return "Time";
        }
        return "Date";
    }

    @Override
    public void writeXMLVarSpecific(PrintWriter out) {
    }

    @Override
    public int getFormat() {
        if (this.myContent == Content.DATE) {
            return 9;
        }
        if (this.myContent == Content.TIME) {
            return 1000;
        }
        return 2060;
    }

    @Override
    public String toString() {
        String stringValue;
        if (this.myPanelVariableEditor != null) {
            this.myValue = this.myPanelVariableEditor.getEditorValue();
        }
        if (this.myValue instanceof String) {
            return (String)this.myValue;
        }
        this.resetUnusedCalendarFields();
        switch (this.myContent) {
            case TIME: {
                stringValue = DateUtil.format(((Calendar)this.myValue).getTime(), DateUtil.TIMEOFDAY_TEXT_FORMAT[0]);
                break;
            }
            case DATE: {
                stringValue = EREDateUtil.isBoundaryDate(this.myValue) ? this.myValue.toString() : DateUtil.format(((Calendar)this.myValue).getTime(), DateUtil.DATE_TEXT_FORMAT[0]);
                break;
            }
            case DATE_TIME: {
                stringValue = EREDateUtil.isBoundaryDate(this.myValue) ? this.myValue.toString() : DateUtil.format(((Calendar)this.myValue).getTime(), DateUtil.DATE_TEXT_FORMAT[2]);
                break;
            }
            default: {
                stringValue = DateUtil.format(((Calendar)this.myValue).getTime());
            }
        }
        return stringValue;
    }

    public void setBeginningOfTimeText(final String text) {
        this.myBOTText = text;
        if (this.myPanelVariableEditor != null) {
            EDT.runAndWait(new Runnable(){

                @Override
                public void run() {
                    ((DatePanel)DateAndTimeVariable.this.myPanelVariableEditor).setBeginningOfTimeText(text);
                }
            });
        }
    }

    public void setEndOfTimeText(final String text) {
        this.myEOTText = text;
        if (this.myPanelVariableEditor != null) {
            EDT.runAndWait(new Runnable(){

                @Override
                public void run() {
                    ((DatePanel)DateAndTimeVariable.this.myPanelVariableEditor).setEndOfTimeText(text);
                }
            });
        }
    }

    public void disableDateConstantSupport() {
        this.myBOTText = "";
        this.myEOTText = "";
    }

    @Override
    public void dataChanged() {
        if (this.myPanelVariableEditor != null) {
            this.myIsValid = this.myPanelVariableEditor.isEditorValueValid();
            this.myValue = this.myPanelVariableEditor.getEditorValue();
            this.myUnvalidated = false;
        } else {
            this.myUnvalidated = true;
        }
        this.myIsEdited = true;
        this.fireValueChanged();
    }

    public static enum Content {
        TIME,
        DATE,
        DATE_TIME;

    }
}

