/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.variable;

import ericsson.ere.datatype.BcdString;
import ericsson.vareditor.documents.HexStringDocument;
import ericsson.vareditor.variable.StringVariable;
import java.io.PrintWriter;

public class BcdStringVariable
extends StringVariable {
    public BcdStringVariable(String label, BcdString value) {
        super(label);
        this.myValue = String.valueOf(value);
    }

    public BcdStringVariable(String label, String value) {
        super(label, value);
    }

    public BcdStringVariable(BcdStringVariable v) {
        super(v);
    }

    @Override
    public Object clone() {
        return new BcdStringVariable(this);
    }

    @Override
    protected Object parseValueToObject(String value) {
        if (this.isValueValid()) {
            return new BcdString(value);
        }
        return null;
    }

    @Override
    public String getTypename() {
        return "BcdString";
    }

    public Class<BcdString> getValueClass() {
        return BcdString.class;
    }

    @Override
    public int getFormat() {
        return 2030;
    }

    @Override
    protected void createModel() {
        if (this.myModel == null) {
            this.myModel = new HexStringDocument(BcdString.class);
        }
    }

    @Override
    protected void setVarValue(Object v) {
        this.myValue = v.toString();
        this.setEditorValue(this.myValue);
    }

    @Override
    protected void setVarValue(String v) {
        this.myValue = v;
        this.setEditorValue(this.myValue);
    }

    @Override
    public void writeXMLVarSpecific(PrintWriter out) {
    }

    @Override
    public String toString() {
        Object valueObject = this.getValueObject();
        return valueObject != null ? valueObject.toString().toUpperCase() : "";
    }
}

