/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.documents;

import com.ericsson.charging.common.RMAStatusInterface;
import com.ericsson.charging.common.StatusInterface;
import com.ericsson.charging.common.documents.FieldValidation;
import ericsson.ere.datatype.OctetString;
import java.util.regex.Pattern;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class PlainHexAsciiDocument
extends PlainDocument
implements FieldValidation {
    private boolean myIsHexMode = true;
    private StatusInterface myStatusHandler = new RMAStatusInterface();
    private boolean myIsEnabled = true;

    public boolean isHexMode() {
        return this.myIsHexMode;
    }

    public void setHexMode(boolean hex) {
        this.myIsHexMode = hex;
    }

    private boolean isHexDigit(char c) {
        return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
    }

    @Override
    public void insertString(int offs, String str, AttributeSet a) throws BadLocationException {
        if (!this.myIsEnabled) {
            super.insertString(offs, str, a);
            return;
        }
        this.myStatusHandler.printMessage("");
        if (this.myIsHexMode) {
            this.insertHexString(offs, str, a);
        } else {
            this.insertAsciiString(offs, str, a);
        }
    }

    private void insertAsciiString(int offs, String str, AttributeSet a) throws BadLocationException {
        String currentText = super.getText(0, this.getLength());
        String prefix = currentText.substring(0, offs);
        String suffix = currentText.substring(offs, currentText.length());
        String proposedResult = prefix + str + suffix;
        if (this.isValid(proposedResult)) {
            super.insertString(offs, str, a);
        } else {
            this.myStatusHandler.printMessage("The string '" + proposedResult + "' is not valid US ASCII.");
        }
    }

    private void insertHexString(int offs, String str, AttributeSet a) throws BadLocationException {
        String numbersOnlyString = "";
        int start = 0;
        int currLen = this.getLength();
        if (offs == 0 && currLen == 0) {
            if (str.startsWith("0x")) {
                numbersOnlyString = numbersOnlyString + "0x";
                start = 2;
            } else if (str.length() == 1 && str.charAt(0) == '0') {
                numbersOnlyString = numbersOnlyString + "0";
                start = 1;
            }
        }
        if (offs == 1 && currLen < 2 && str.length() != 0 && str.charAt(0) == 'x') {
            numbersOnlyString = numbersOnlyString + "x";
            start = 2;
        }
        char[] chars = str.toCharArray();
        for (int i = start; i < chars.length; ++i) {
            if (this.isHexDigit(chars[i])) {
                numbersOnlyString = numbersOnlyString + chars[i];
                continue;
            }
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Only hexadecimal digits (0-9, a-f) are allowed.");
        }
        String currentText = super.getText(0, this.getLength());
        String prefix = currentText.substring(0, offs);
        String suffix = currentText.substring(offs, currentText.length());
        String proposedResult = prefix + numbersOnlyString + suffix;
        try {
            OctetString.valueOf(proposedResult);
            super.insertString(offs, numbersOnlyString, a);
        }
        catch (Exception e) {
            this.myStatusHandler.beep();
            this.myStatusHandler.printMessage("Invalid OctetString value: " + proposedResult);
        }
    }

    @Override
    public boolean isValid(String value) {
        if (value == null) {
            return false;
        }
        if (this.myIsHexMode) {
            return Pattern.matches("^(0[xX])?\\p{XDigit}*", value);
        }
        return Pattern.matches("[ -~]*", value);
    }

    @Override
    public void setStatusHandler(StatusInterface statusHandler) {
        this.myStatusHandler = statusHandler;
    }

    @Override
    public void enableValidation(boolean enable) {
        this.myIsEnabled = enable;
    }
}

