/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.components;

import com.ericsson.ere.swing.ArrayBasedComboBoxModel;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.vareditor.documents.PlainHexAsciiDocument;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import javax.swing.JComboBox;
import javax.swing.JTextField;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class OctetStringPanel
extends AbstractPanelVariableEditor
implements DocumentListener {
    private static final String[] SELECTIONS = new String[]{"Hex", "Ascii"};
    private JTextField myTextField;
    private JComboBox myComboBox;
    private PlainHexAsciiDocument myModel;
    private boolean myIsSettingValue;

    public OctetStringPanel(OctetString value, boolean isHex) {
        this.init(value, isHex);
    }

    private void init(OctetString ovalue, boolean isHexMode) {
        this.myModel = new PlainHexAsciiDocument();
        this.myModel.setHexMode(isHexMode);
        String value = isHexMode ? ovalue.toString() : ovalue.toAscii();
        this.myTextField = new JTextField(this.myModel, value, 25);
        this.myTextField.setBackground(this.isValueValid() ? UIManager.getColor("TextField.background") : Color.RED);
        this.myComboBox = new JComboBox(new ArrayBasedComboBoxModel(SELECTIONS));
        if (!this.myModel.isHexMode()) {
            this.myComboBox.setSelectedIndex(1);
        }
        this.myComboBox.setPreferredSize(new Dimension(this.myComboBox.getPreferredSize().width + 8, this.myComboBox.getPreferredSize().height));
        this.setLayout(new BorderLayout());
        this.add((Component)this.myComboBox, "West");
        this.add((Component)this.myTextField, "Center");
        this.myModel.addDocumentListener(this);
        this.myComboBox.addActionListener(new ModeSelectionListener());
    }

    public void setHexMode(boolean hex) {
        int index = hex ? 0 : 1;
        this.myComboBox.setSelectedIndex(index);
    }

    public void setValue(OctetString value) {
        String text = this.myModel.isHexMode() ? value.toString() : value.toAscii();
        this.replaceText(text);
    }

    public void setReadOnly(boolean readOnly) {
        this.myTextField.setEnabled(!readOnly);
        this.myComboBox.setEnabled(!readOnly);
    }

    private boolean isValueValid() {
        return this.myModel.isValid(this.myTextField.getText());
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.updateValidStateAndFireChange();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.updateValidStateAndFireChange();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.updateValidStateAndFireChange();
    }

    private void updateValidStateAndFireChange() {
        this.myTextField.setBackground(this.isValueValid() ? UIManager.getColor("TextField.background") : Color.RED);
        this.fireDataChanged();
    }

    @Override
    protected void fireDataChanged() {
        if (!this.myIsSettingValue) {
            super.fireDataChanged();
        }
    }

    private void replaceText(String text) {
        try {
            this.myIsSettingValue = true;
            this.myTextField.setText(text);
        }
        finally {
            this.myIsSettingValue = false;
        }
    }

    @Override
    public boolean isEditorValueValid() {
        return this.isValueValid();
    }

    @Override
    public Object getEditorValue() {
        String text = this.myTextField.getText();
        if (this.myModel.isHexMode()) {
            return OctetString.valueOf(text);
        }
        return OctetString.fromAscii(text);
    }

    public boolean getMode() {
        assert (this.myModel != null);
        return this.myModel.isHexMode();
    }

    public void setFocusListenerForEditor(FocusListener fl) {
        this.myComboBox.addFocusListener(fl);
        this.myTextField.addFocusListener(fl);
    }

    private class ModeSelectionListener
    implements ActionListener {
        private ModeSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String newSelection = (String)OctetStringPanel.this.myComboBox.getSelectedItem();
            String text = OctetStringPanel.this.myTextField.getText();
            String newText = null;
            if (newSelection.equals("Hex") && !OctetStringPanel.this.myModel.isHexMode()) {
                OctetString oStr = OctetString.fromAscii(text);
                newText = oStr.toString();
                OctetStringPanel.this.myModel.setHexMode(true);
            } else if (newSelection.equals("Ascii") && OctetStringPanel.this.myModel.isHexMode()) {
                OctetString oStr = OctetString.valueOf(text);
                if (!OctetString.isDisplayableUSAscii(oStr)) {
                    OctetStringPanel.this.myComboBox.setSelectedItem("Hex");
                    DialogFactory.getInformationDialog(GuiServiceCenter.getInstance().getMainWindow(), "Ascii not Displayable", "Hex value '" + text + "' could not be displayed as Ascii.");
                } else {
                    newText = oStr.toAscii();
                    OctetStringPanel.this.myModel.setHexMode(false);
                }
            }
            if (newText != null && !newText.equals(text)) {
                OctetStringPanel.this.replaceText(newText);
                OctetStringPanel.this.fireDataChanged();
            }
        }
    }
}

