/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.components;

import com.ericsson.charging.common.dataitem.DataItemAdapter;
import com.ericsson.ere.swing.ArrayBasedComboBoxModel;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.components.RestrictedSelectableMultiplier;
import ericsson.vareditor.components.SelectableMultipler;
import ericsson.vareditor.documents.FloatsOnlyDocument;
import ericsson.vareditor.documents.NumbersOnlyDocument;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.DoubleVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.LongVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.PrintWriter;
import javax.swing.JComboBox;
import javax.swing.text.PlainDocument;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MultiplerSelectEditorPanel
extends AbstractPanelVariableEditor
implements FocusListener,
ItemListener {
    public static String TAG_UNIT_FACTOR = "Factor";
    protected Variable myEditorVariable;
    protected JComboBox myComboBox;
    protected Component myEditor;
    protected SelectableMultipler[] mySelections;
    protected int myDataType;
    protected boolean allowEmpty;
    private int myLastSelectedIndex;
    private String myLastValue;
    private SelectableMultipler mySelected;
    private Number myMax;
    private Number myMin;
    private boolean myWasValidAtLastFocusLost = true;

    public MultiplerSelectEditorPanel(SelectableMultipler[] selections, int dataType) {
        this(selections, "0", "", dataType);
    }

    public MultiplerSelectEditorPanel(SelectableMultipler[] selections, String value, String selected, int dataType) {
        this(selections, value, selected, dataType, false);
    }

    public MultiplerSelectEditorPanel(SelectableMultipler[] selections, String value, String selected, int dataType, boolean allowEmpty) {
        this(selections, value, selected, dataType, allowEmpty, null, null);
    }

    public MultiplerSelectEditorPanel(SelectableMultipler[] selections, String value, String selected, int dataType, boolean allowEmpty, Number min, Number max) {
        super(new BorderLayout());
        this.mySelections = selections;
        this.myDataType = dataType;
        this.myMin = min;
        this.myMax = max;
        this.allowEmpty = allowEmpty;
        this.init(value, selected);
    }

    protected void init(String value, String selected) {
        if (selected == null) {
            this.mySelected = this.mySelections[0];
        }
        if (this.myDataType == 8) {
            if (this.myMin == null) {
                this.myMin = 0;
            }
            if (this.myMax == null) {
                this.myMax = Double.MAX_VALUE;
            }
            this.myEditorVariable = new DoubleVariable("ITEM_VALUE", value, this.allowEmpty);
        } else if (this.myDataType == 5) {
            if (this.myMin == null) {
                this.myMin = 0;
            }
            if (this.myMax == null) {
                this.myMax = Integer.MAX_VALUE;
            }
            this.myEditorVariable = new IntegerVariable("ITEM_VALUE", value, this.allowEmpty);
        } else if (this.myDataType == 7) {
            if (this.myMin == null) {
                this.myMin = Long.MIN_VALUE;
            }
            if (this.myMax == null) {
                this.myMax = Long.MAX_VALUE;
            }
            this.myEditorVariable = new LongVariable("ITEM_VALUE", value, this.myMin.longValue(), this.myMax.longValue(), this.allowEmpty);
        }
        this.myEditorVariable.setFocusListenerForEditor(this);
        this.myEditorVariable.setDataItem(new DataItemAdapter(){

            @Override
            public void setDataItem(Object reference, Object object) {
                MultiplerSelectEditorPanel.this.reValidateInput();
            }
        });
        this.myLastValue = value;
        this.myComboBox = new JComboBox(new ArrayBasedComboBoxModel(this.mySelections));
        this.myComboBox.setPreferredSize(new Dimension(this.myComboBox.getPreferredSize().width + 8, this.myComboBox.getPreferredSize().height));
        this.setSelected(selected);
        this.myLastSelectedIndex = this.myComboBox.getSelectedIndex();
        this.myComboBox.addFocusListener(this);
        this.myComboBox.addItemListener(this);
        if ("".equals(this.mySelections[0].getLabel())) {
            this.myComboBox.setVisible(false);
        }
        this.add((Component)this.myComboBox, "East");
        this.myEditor = this.myEditorVariable.getEditor();
        this.add(this.myEditor, "Center");
        this.setDocumentMinMax();
    }

    private void setDocumentMinMax() {
        PlainDocument doc;
        SelectableMultipler selected = this.getSelected();
        Number min = this.myMin;
        Number max = this.myMax;
        if (selected instanceof RestrictedSelectableMultiplier) {
            RestrictedSelectableMultiplier selectedWithRange = (RestrictedSelectableMultiplier)selected;
            min = selectedWithRange.getMin();
            max = selectedWithRange.getMax();
        }
        if (this.myDataType == 8) {
            doc = (FloatsOnlyDocument)this.myEditorVariable.getModel();
            ((FloatsOnlyDocument)doc).setMinValue(min.doubleValue());
            ((FloatsOnlyDocument)doc).setMaxValue(max.doubleValue());
        } else if (this.myDataType == 5) {
            doc = (NumbersOnlyDocument)this.myEditorVariable.getModel();
            ((NumbersOnlyDocument)doc).setMinValue(min.longValue());
            ((NumbersOnlyDocument)doc).setMaxValue(max.longValue());
        } else if (this.myDataType == 7) {
            doc = (NumbersOnlyDocument)this.myEditorVariable.getModel();
            ((NumbersOnlyDocument)doc).setMinValue(min.longValue());
            ((NumbersOnlyDocument)doc).setMaxValue(max.longValue());
        }
    }

    public int getComboBoxIndex() {
        return this.myComboBox.getSelectedIndex();
    }

    public void setComboBoxIndex(int index) {
        if (this.myComboBox.getSelectedIndex() == index) {
            return;
        }
    }

    public void setReadOnly(boolean readOnly) {
        this.myEditor.setEnabled(!readOnly);
        this.myComboBox.setEnabled(!readOnly);
    }

    public Object getValueObject() {
        Object o = this.myEditorVariable.getValueObject();
        return o;
    }

    @Deprecated
    public String getValueString() {
        return "" + this.getValueObject();
    }

    public void setValue(String value) {
        this.myEditorVariable.setValue(value);
    }

    @Deprecated
    public void initFromXml(Node node, String value) {
        NodeList childNodes = node.getChildNodes();
        Element modeNode = XMLUtil.getNamedElement(TAG_UNIT_FACTOR, childNodes);
        this.setValue(value);
        String selected = XMLUtil.getFirstTextContent(modeNode);
        this.setSelected(selected);
    }

    public void writeXML(PrintWriter out) {
        String selected = (String)this.myComboBox.getSelectedItem();
        out.print("<" + TAG_UNIT_FACTOR + ">");
        out.print(selected);
        out.print("</" + TAG_UNIT_FACTOR + ">");
    }

    @Override
    public Component getEditorComponent(Variable parVariable) {
        return this;
    }

    @Deprecated
    public void setFocusListenerForEditor(FocusListener fl) {
        this.myComboBox.addFocusListener(fl);
        this.myEditor.addFocusListener(fl);
    }

    @Override
    public Object getEditorValue() {
        return this.getValueObject();
    }

    public void setEditorValue(Object value) {
        this.myEditorVariable.setValue(value);
    }

    @Override
    public boolean isEditorValueValid() {
        return this.myEditorVariable.isValueValid();
    }

    public SelectableMultipler getSelected() {
        SelectableMultipler selectedBox = (SelectableMultipler)this.myComboBox.getSelectedItem();
        if (selectedBox == null) {
            return this.mySelected;
        }
        return selectedBox;
    }

    public void setSelected(String selected) {
        SelectableMultipler sel = this.mySelections[0];
        for (int i = 0; i < this.mySelections.length; ++i) {
            if (this.mySelections[i].getLabel().equals(selected)) {
                sel = this.mySelections[i];
                break;
            }
            if (!this.mySelections[i].getMultiplier().toString().equals(selected)) continue;
            sel = this.mySelections[i];
            break;
        }
        this.myComboBox.setSelectedItem(sel);
        this.mySelected = sel;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.myComboBox.setEnabled(enabled);
        this.myEditor.setEnabled(enabled);
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.myLastValue = this.myEditorVariable.getValueString();
        this.myLastSelectedIndex = this.myComboBox.getSelectedIndex();
    }

    public boolean isModified() {
        if (this.myLastSelectedIndex != this.myComboBox.getSelectedIndex()) {
            return true;
        }
        return this.myLastValue == null || !this.myLastValue.equals(this.myEditorVariable.getValueString());
    }

    private void reValidateInput() {
        boolean isValid = this.isEditorValueValid();
        if (this.isModified() || isValid != this.myWasValidAtLastFocusLost) {
            this.fireDataChanged();
        }
        this.myLastValue = this.myEditorVariable.getValueString();
        this.myLastSelectedIndex = this.myComboBox.getSelectedIndex();
        this.myWasValidAtLastFocusLost = isValid;
    }

    @Override
    public void itemStateChanged(ItemEvent arg0) {
        if (this.myLastSelectedIndex != this.myComboBox.getSelectedIndex()) {
            this.setDocumentMinMax();
        }
        this.reValidateInput();
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

