/*
 * Decompiled with CFR 0.152.
 */
package ericsson.vareditor.components;

import ericsson.ere.gui.GuiServiceCenter;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.Document;

public class FileNamePanel
extends JPanel
implements FocusListener {
    JTextField fileNameField;
    JButton browseButton = new JButton("...");
    JFrame frame;
    FocusListener myFocusListener = null;

    public FileNamePanel(Document model, String fileName) {
        this.setLayout(new GridBagLayout());
        this.fileNameField = new JTextField(model, fileName, 0);
        this.fileNameField.setPreferredSize(new Dimension(100, 30));
        this.frame = GuiServiceCenter.getInstance().getMainWindow();
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridx = 0;
        cons.gridy = 0;
        cons.gridwidth = 6;
        cons.gridheight = 0;
        cons.weightx = 5.0;
        cons.weighty = 0.0;
        cons.fill = 1;
        cons.anchor = 10;
        this.add((Component)this.fileNameField, cons);
        cons.gridx = 6;
        cons.gridwidth = 0;
        cons.weightx = 0.0;
        cons.fill = 0;
        cons.anchor = 10;
        this.add((Component)this.browseButton, cons);
        this.addActionEvent();
        this.setPreferredSize(new Dimension(100, 30));
    }

    public void setFocusListener(FocusListener fl) {
        this.myFocusListener = fl;
        this.fileNameField.addFocusListener(this);
    }

    private void addActionEvent() {
        this.browseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                JFileChooser chooser = GuiServiceCenter.getInstance().getFileChooser();
                chooser.setFileFilter(chooser.getAcceptAllFileFilter());
                chooser.setSelectedFile(new File(FileNamePanel.this.fileNameField.getText().trim()));
                int returnVal = chooser.showDialog(FileNamePanel.this.frame, null);
                if (returnVal == 0) {
                    String selectedFile = chooser.getSelectedFile().getPath();
                    if (selectedFile.indexOf(46) == -1 && !new File(selectedFile).exists()) {
                        selectedFile = selectedFile + ".xml";
                    }
                    FileNamePanel.this.fileNameField.setText(selectedFile);
                }
            }
        });
    }

    public String getFileName() {
        return this.fileNameField.getText().trim();
    }

    public void setReadOnly(boolean readOnly) {
        this.fileNameField.setEnabled(!readOnly);
        this.browseButton.setEnabled(!readOnly);
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.myFocusListener != null) {
            focusEvent.setSource(this);
            this.myFocusListener.focusGained(focusEvent);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }
}

