/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.structure;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.structure.AbstractTariffStructureTreeDefinedProfile;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.BaseVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.List;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TariffStructureTreeDefinedFieldProfile
extends AbstractTariffStructureTreeDefinedProfile {
    public TariffStructureTreeDefinedFieldProfile() {
        super(true);
    }

    @Override
    public List<Variable> getVariables() {
        List<Variable> l = super.getVariables();
        BaseVariable var = new StringVariable("Service Id", "");
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Created", DateAndTimeVariable.Content.DATE_TIME);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Saved", DateAndTimeVariable.Content.DATE_TIME);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        List<Variable> l = super.getVariables(iterator);
        NamedNodeMap attributes = iterator.getAttributes();
        NodeList children = iterator.getChildNodes();
        String serviceId = "";
        String created = "";
        String saved = "";
        Node n = attributes.getNamedItem("ServiceId");
        if (n != null) {
            serviceId = n.getNodeValue();
        }
        for (int aa = 0; aa < children.getLength(); ++aa) {
            n = children.item(aa);
            if (n.getNodeType() != 1) continue;
            String k = n.getNodeName();
            if ("Created".equals(k)) {
                created = n.getAttributes().getNamedItem("Date").getNodeValue();
            }
            if (!"Saved".equals(k)) continue;
            saved = n.getAttributes().getNamedItem("Date").getNodeValue();
        }
        BaseVariable var = new StringVariable("Service Id", serviceId);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Created", DateAndTimeVariable.Content.DATE_TIME, created);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        var = new DateAndTimeVariable("Saved", DateAndTimeVariable.Content.DATE_TIME, saved);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        return l;
    }

    @Override
    public void printPreamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        for (int i = 0; i < indentLevel; ++i) {
            out.print(indentMarker);
        }
        String name = VarListUtil.getValueStringForName(variables, "Name");
        String id = VarListUtil.getValueStringForName(variables, "Id");
        String service = VarListUtil.getValueStringForName(variables, "Service");
        out.print("<TariffStructure");
        out.print(" Name=\"" + XMLUtil.escape(name) + "\"");
        out.print(" type=\"" + XMLUtil.escape("TariffStructure") + "\"");
        out.print(" id=\"" + XMLUtil.escape(id) + "\"");
        out.print(" ServiceId=\"" + XMLUtil.escape(service) + "\"");
        out.print(">");
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        int i;
        String comment;
        String created = VarListUtil.getTimeValueForName(variables, "Created").toString();
        String saved = VarListUtil.getTimeValueForName(variables, "Saved").toString();
        boolean commentIsUsed = RmaDefs.getInstance().useCommentCondition();
        out.println("");
        if (commentIsUsed && (comment = VarListUtil.getValueStringForName(variables, "Comment")).length() > 0) {
            for (int i2 = 0; i2 < indentLevel + 1; ++i2) {
                out.print(indentMarker);
            }
            out.print("<");
            out.print("Comment");
            out.print(">");
            out.print(XMLUtil.escape(comment));
            out.print("</");
            out.print("Comment");
            out.println(">");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.print("<Created Date=\"");
        out.print(created);
        out.println("\"/>");
        for (i = 0; i < indentLevel + 1; ++i) {
            out.print(indentMarker);
        }
        out.print("<Saved Date=\"");
        out.print(saved);
        out.println("\"/>");
    }

    @Override
    public String getDescription(List<Variable> variables) {
        if (variables == null) {
            return "";
        }
        String name = VarListUtil.getValueStringForName(variables, "Name");
        return name;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String service = VarListUtil.getValueStringForName(variables, "Service Id");
        String saved = VarListUtil.getTimeValueForName(variables, "Saved").toString();
        String info = "<b>" + this.getDescription(variables) + "</b>\nService: '" + service + "' - Saved: " + saved;
        return GuiUtil.multilineTooltipWrapper(info);
    }
}

