/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.structure;

import com.ericsson.ere.interfaces.DynamicClassProfile;
import com.ericsson.ere.selectiontree.AbstractClassProfile;
import com.ericsson.vareditor.document.LimitLeadingAndTrailingSpacesStringDocument;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.gui.ratingrules.nodes.TreeBuilderAssistant;
import ericsson.ere.gui.util.GuiUtil;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class AbstractTariffStructureProfile
extends AbstractClassProfile
implements ClassProfile,
DynamicClassProfile,
TreeBuilderAssistant {
    public static final String LBL_ID = "Id";
    public static final String LBL_SERVICE = "Service";
    public static final String LBL_NAME = "Name";
    public static final String LBL_COMMENT = "Comment";
    public static final String TAG_ID = "id";
    public static final String TAG_TYPE = "type";
    public static final String TAG_SERVICE = "ServiceId";
    public static final String TAG_NAME = "Name";
    public static final String TAG_COMMENT = "Comment";
    public static final String TAG_TARIFFSTRUCTURE = "TariffStructure";

    public AbstractTariffStructureProfile() {
        super(TAG_TARIFFSTRUCTURE, RmaDefs.getInstance().useCommentNode());
    }

    public List<Variable> getBaseVariables(List<Variable> oldVar, ClassRepository rep) {
        Variable nameVar = null;
        Variable idVar = null;
        Variable commentVar = null;
        if (oldVar != null) {
            for (int i = 0; i < oldVar.size(); ++i) {
                Variable v = oldVar.get(i);
                if ("Name".equals(v.getLabel()) || "Name".equals(v.getKey())) {
                    nameVar = v;
                    nameVar.setAllowEdit(false);
                }
                if (LBL_ID.equals(v.getLabel()) || LBL_ID.equals(v.getKey())) {
                    idVar = v;
                }
                if (!"Comment".equals(v.getLabel()) && !"Comment".equals(v.getKey())) continue;
                commentVar = v;
            }
        }
        if (nameVar == null) {
            nameVar = new StringVariable("Name", "A new structure");
            nameVar.setKey("Name");
        }
        if (idVar == null) {
            idVar = new StringVariable(LBL_ID, "root", new LimitLeadingAndTrailingSpacesStringDocument(true));
            ((Variable)idVar).setKey(LBL_ID);
        }
        if (commentVar == null && RmaDefs.getInstance().useCommentNode()) {
            commentVar = new MultilineStringVariable("Comment", "");
            ((Variable)commentVar).setKey("Comment");
        }
        ArrayList<Variable> l = new ArrayList<Variable>(4);
        l.add(nameVar);
        l.add(idVar);
        if (commentVar != null) {
            l.add(commentVar);
        }
        return l;
    }

    public List<Variable> getBaseVariables(Node iterator, ClassRepository rep) {
        String comment = "";
        String id = "root";
        String name = "";
        String type = TAG_TARIFFSTRUCTURE;
        NamedNodeMap attr = iterator.getAttributes();
        Node node = XMLUtil.getNamedElement("Comment", iterator.getChildNodes());
        if (node != null) {
            comment = XMLUtil.unEscape(XMLUtil.getFirstTextContent(node));
        }
        if (attr != null) {
            int len = attr.getLength();
            for (int i = 0; i < len; ++i) {
                node = attr.item(i);
                if (!LBL_ID.equalsIgnoreCase(node.getNodeName())) continue;
                id = node.getNodeValue();
            }
            node = attr.getNamedItem("Name");
            if (node != null) {
                name = node.getNodeValue();
            }
            if ((node = attr.getNamedItem(TAG_TYPE)) != null) {
                type = node.getNodeValue();
            }
        }
        if (type == null) {
            type = TAG_TARIFFSTRUCTURE;
        }
        ArrayList<Variable> l = new ArrayList<Variable>(4);
        StringVariable nameVariable = new StringVariable("Name", name);
        ((Variable)nameVariable).setKey("Name");
        ((Variable)nameVariable).setAllowEdit(false);
        StringVariable idVariable = new StringVariable(LBL_ID, id, new LimitLeadingAndTrailingSpacesStringDocument(true));
        ((Variable)idVariable).setKey(LBL_ID);
        l.add(nameVariable);
        l.add(idVariable);
        if (RmaDefs.getInstance().useCommentNode()) {
            MultilineStringVariable commentVariable = new MultilineStringVariable("Comment", comment);
            ((Variable)commentVariable).setKey("Comment");
            l.add(commentVariable);
        }
        return l;
    }

    @Override
    public List<Variable> getVariables() {
        return this.getVariables("");
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        String serviceId = ((Element)iterator).getAttribute(TAG_SERVICE);
        return this.getVariables(serviceId);
    }

    private List<Variable> getVariables(String serviceId) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        StringVariable var = new StringVariable(LBL_SERVICE, serviceId);
        ((Variable)var).setAllowEdit(false);
        l.add(var);
        return l;
    }

    @Override
    protected void printAdditionalPreamble(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        super.printAdditionalPreamble(out, indentLevel, indentMarker, variables);
        String name = VarListUtil.getValueStringForKey(variables, "Name");
        String service = VarListUtil.getValueStringForName(variables, LBL_SERVICE);
        out.print(XMLUtil.wrapValueOrEmptyStringInAttribute("Name", name));
        out.print(XMLUtil.wrapValueOrEmptyStringInAttribute(TAG_SERVICE, service));
        out.print(XMLUtil.wrapInAttribute(TAG_TYPE, TAG_TARIFFSTRUCTURE));
        String id = VarListUtil.getValueStringForKey(variables, LBL_ID);
        String string = id = id != null ? id.trim() : null;
        if (StringUtil.isEmptyString(id)) {
            out.print(XMLUtil.wrapValueOrEmptyStringInAttribute(TAG_ID, id));
        }
    }

    @Override
    protected void printName(PrintWriter out, List<Variable> variables) {
    }

    @Override
    public boolean getAllowsChildren() {
        return true;
    }

    @Override
    public String getAdditionalInfo(List<Variable> variables) {
        String service = VarListUtil.getValueStringForName(variables, LBL_SERVICE);
        String info = "<b>" + this.getDescription(variables) + "</b>\n" + LBL_SERVICE + ": " + service;
        return GuiUtil.multilineTooltipWrapper(info);
    }

    @Override
    public boolean parameterChanged(String reference, Variable value, List<Variable> vars) {
        return false;
    }

    @Override
    public boolean allowsAddCondition(TariffDAGNode treeNode) {
        return false;
    }

    @Override
    public boolean allowsAddLink(TariffDAGNode treeNode) {
        return true;
    }

    @Override
    public boolean allowsAddModifier(TariffDAGNode treeNode) {
        return false;
    }

    @Override
    public boolean allowsAddNode(TariffDAGNode treeNode) {
        return true;
    }
}

