/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.interfaces;

import ericsson.ere.interfaces.DAGNode;
import ericsson.ere.interfaces.TariffNodeLink;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.swing.tree.TreePath;

public class DAGUtil {
    public static void getChildSet(DAGNode curr, Set<DAGNode> result) {
        result.add(curr);
        for (int i = 0; i < curr.getChildCount(); ++i) {
            DAGNode child = curr.getChildAt(i);
            if (child.getParent() != curr) continue;
            DAGUtil.getChildSet(child, result);
        }
    }

    public static void getLinksToTargets(DAGNode curr, Map<DAGNode, DAGNode> result) {
        DAGNode[] ref = curr.getReferers();
        if (ref != null) {
            for (int r = 0; r < ref.length; ++r) {
                result.put(ref[r], curr);
            }
        }
        int len = curr.getChildCount();
        for (int i = 0; i < len; ++i) {
            DAGNode child = curr.getChildAt(i);
            if (child.getParent() != curr) continue;
            DAGUtil.getLinksToTargets(child, result);
        }
    }

    public static DAGNode[] getPathToNode(DAGNode from, DAGNode to) {
        return DAGUtil.getPathToNode(from, to, 0);
    }

    public static boolean pathExists(DAGNode from, DAGNode to) {
        if (from == to) {
            return true;
        }
        int len = from.getChildCount();
        for (int i = 0; i < len; ++i) {
            DAGNode child = from.getChildAt(i);
            if (!DAGUtil.pathExists(child, to)) continue;
            return true;
        }
        return false;
    }

    private static DAGNode[] getPathToNode(DAGNode from, DAGNode to, int depth) {
        if (from == to) {
            DAGNode[] path = new DAGNode[depth + 1];
            path[depth] = from;
            return path;
        }
        int len = from.getChildCount();
        for (int i = 0; i < len; ++i) {
            DAGNode child = from.getChildAt(i);
            DAGNode[] path = DAGUtil.getPathToNode(child, to, depth + 1);
            if (path == null) continue;
            path[depth] = from;
            return path;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getPathsToRoot(DAGNode curr, DAGNode root, List<DAGNode> pathSoFar, List<List<DAGNode>> resultPaths) throws IllegalArgumentException {
        if (curr == null) {
            throw new IllegalArgumentException("Path not part of root subtree " + root);
        }
        try {
            pathSoFar.add(curr);
            if (curr == root) {
                ArrayList<DAGNode> list = new ArrayList<DAGNode>(pathSoFar.size());
                for (DAGNode node : pathSoFar) {
                    list.add(0, node);
                }
                resultPaths.add(list);
            } else {
                DAGUtil.getPathsToRoot(curr.getParent(), root, pathSoFar, resultPaths);
                DAGNode[] referers = curr.getReferers();
                if (referers != null) {
                    for (int i = 0; i < referers.length; ++i) {
                        DAGUtil.getPathsToRoot(referers[i], root, pathSoFar, resultPaths);
                    }
                }
            }
        }
        finally {
            pathSoFar.remove(pathSoFar.size() - 1);
        }
    }

    public static TreePath getPathToRoot(DAGNode node) {
        Stack<DAGNode> parentStack = new Stack<DAGNode>();
        parentStack.push(node);
        while (node.getParent() != null) {
            parentStack.push(node.getParent());
            node = node.getParent();
        }
        TreePath pathToRoot = null;
        while (!parentStack.isEmpty()) {
            if (pathToRoot == null) {
                pathToRoot = new TreePath(parentStack.pop());
                continue;
            }
            pathToRoot = pathToRoot.pathByAddingChild(parentStack.pop());
        }
        return pathToRoot;
    }

    public static String getTreePathToString(TreePath path) {
        Object[] pathArray = path.getPath();
        String pathString = "";
        for (int i = 1; i < pathArray.length; ++i) {
            pathString = pathString + "/";
            pathString = pathString + ((TariffStructureNode)pathArray[i]).getNodeId();
        }
        return pathString;
    }

    public static TreePath getStringToTreePath(String pathString, TariffStructureNode root) {
        TreePath resultPath = new TreePath(root);
        String[] path = pathString.split("/");
        DAGNode currentNode = root;
        block0: for (int i = 1; i < path.length; ++i) {
            for (int j = 0; j < currentNode.getChildCount(); ++j) {
                DAGNode child = currentNode.getChildAt(j);
                if (!((TariffStructureNode)child).getNodeId().equals(path[i])) continue;
                resultPath = resultPath.pathByAddingChild(child);
                currentNode = child;
                continue block0;
            }
        }
        if (resultPath.getPath().length != path.length) {
            return null;
        }
        return resultPath;
    }

    public static Pattern createPatternForStringPath(String path, boolean caseSensitive) {
        String[] parts = path.substring(1).split("/");
        StringBuilder pat = new StringBuilder();
        for (String part : parts) {
            String needle;
            pat.append("/");
            boolean startsWithWC = part.startsWith("*");
            boolean endsWithWC = part.endsWith("*") && !part.endsWith("\\*");
            boolean isSingleWC = part.equals("*");
            boolean isDoubleWC = part.equals("**");
            part = part.replace("\\*", "*");
            if ("".equals(part)) continue;
            if (isSingleWC) {
                pat.append("[^/]+");
                continue;
            }
            if (isDoubleWC) {
                pat.append(".+?");
                continue;
            }
            if (startsWithWC && endsWithWC) {
                needle = part.substring(1, part.length() - 1);
                pat.append("[^/]*").append(Pattern.quote(needle)).append("[^/]*");
                continue;
            }
            if (startsWithWC) {
                needle = part.substring(1);
                pat.append("[^/]*").append(Pattern.quote(needle));
                continue;
            }
            if (endsWithWC) {
                needle = part.substring(0, part.length() - 1);
                pat.append(Pattern.quote(needle)).append("[^/]*");
                continue;
            }
            pat.append(Pattern.quote(part));
        }
        return Pattern.compile(pat.toString(), caseSensitive ? 0 : 2);
    }

    public static TreePath getStringToUniqueTreePath(String pathString, TariffStructureNode root) {
        TreePath resultPath = new TreePath(root);
        String[] path = pathString.split("/");
        TariffStructureNode currentNode = root;
        for (int i = 1; i < path.length; ++i) {
            DAGNode foundChild = null;
            for (int j = 0; j < currentNode.getChildCount(); ++j) {
                DAGNode child = currentNode.getChildAt(j);
                if (!((TariffStructureNode)child).getNodeId().equals(path[i].trim())) continue;
                if (foundChild == null) {
                    resultPath = resultPath.pathByAddingChild(child);
                    foundChild = child;
                    continue;
                }
                return null;
            }
            if (foundChild == null) {
                return null;
            }
            currentNode = foundChild;
        }
        if (resultPath.getPath().length != path.length) {
            return null;
        }
        return resultPath;
    }

    public static DAGNode[] getCanonicalPath(DAGNode curr) {
        List<DAGNode> l = DAGUtil.getParentPath(curr, new ArrayList<DAGNode>());
        return l.toArray(new DAGNode[l.size()]);
    }

    private static List<DAGNode> getParentPath(DAGNode curr, List<DAGNode> pathSoFar) {
        if (curr == null) {
            return pathSoFar;
        }
        pathSoFar.add(0, curr);
        return DAGUtil.getParentPath(curr.getParent(), pathSoFar);
    }

    public static int gaugeDepth(DAGNode node) {
        int max = 0;
        int len = node.getChildCount();
        for (int i = 0; i < len; ++i) {
            max = Math.max(max, DAGUtil.gaugeDepth(node.getChildAt(i)));
        }
        return max + 1;
    }

    public static DAGNode[] findCycle(DAGNode node) {
        return DAGUtil.findCycle(node, new ArrayList<DAGNode>(50));
    }

    private static DAGNode[] findCycle(DAGNode node, List<DAGNode> pathSoFar) {
        int i;
        boolean cycleFound = false;
        int len = pathSoFar.size();
        for (i = 0; i < len; ++i) {
            if (node != pathSoFar.get(i)) continue;
            cycleFound = true;
        }
        pathSoFar.add(node);
        if (cycleFound) {
            return pathSoFar.toArray(new DAGNode[pathSoFar.size()]);
        }
        len = node.getChildCount();
        for (i = 0; i < len; ++i) {
            DAGNode[] res = DAGUtil.findCycle(node.getChildAt(i), pathSoFar);
            if (res == null) continue;
            return res;
        }
        DAGNode removed = pathSoFar.remove(pathSoFar.size() - 1);
        if (removed != node) {
            String msg = "DAGUtil.findCycle: Code fault, expected node " + node + " but got last element " + removed;
            throw new IllegalArgumentException(msg);
        }
        return null;
    }

    public static void visitPreorder(TariffStructureNode root, TariffStructureVisitor v) throws Exception {
        if (Thread.interrupted()) {
            throw new InterruptedException("Interrupted while visiting.");
        }
        root.startVisit(v);
        int len = root.getChildCount();
        for (int i = 0; i < len; ++i) {
            TariffStructureNode n = (TariffStructureNode)root.getChildAt(i);
            DAGUtil.visitPreorder(n, v);
        }
        root.endVisit(v);
    }

    public static void visitPreorderWithCondition(TariffStructureNode root, TariffStructureVisitor visitor, VisitorCondition cond) throws Exception {
        if (cond.shouldVisit(root)) {
            root.startVisit(visitor);
            int len = root.getChildCount();
            for (int i = 0; i < len; ++i) {
                TariffStructureNode node = (TariffStructureNode)root.getChildAt(i);
                DAGUtil.visitPreorderWithCondition(node, visitor, cond);
            }
            root.endVisit(visitor);
        }
    }

    public static int indexOf(DAGNode node, List<?> list) {
        int len = list.size();
        for (int i = 0; i < len; ++i) {
            if (node != list.get(i)) continue;
            return i;
        }
        return -1;
    }

    public static String getNodeId(TariffStructureNode n) {
        if (n.isLink()) {
            return ((TariffNodeLink)((Object)n)).getLinkPath().replace('/', '\\');
        }
        return n.getNodeId();
    }

    public static interface VisitorCondition {
        public boolean shouldVisit(TariffStructureNode var1);
    }
}

