/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.settingsmap.propertyio;

import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.BoolVariable;
import ericsson.vareditor.variable.DateAndTimeVariable;
import ericsson.vareditor.variable.DateVariable;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.FileVariable;
import ericsson.vareditor.variable.IntegerVariable;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import java.util.List;

public class VarTableInput {
    public static SettingsMap readFromVarTableModel(VarTableModel source) {
        SettingsMap result = new SettingsMap();
        List<Variable> variables = source.getData();
        for (Variable variable : variables) {
            if (variable instanceof IntegerVariable) {
                result.setParameter(variable.getKey(), variable.getValueString(), 0, !variable.isAllowEdit());
                continue;
            }
            if (variable instanceof BoolVariable) {
                result.setParameter(variable.getKey(), variable.getValueString(), 3, !variable.isAllowEdit());
                continue;
            }
            if (variable instanceof FileVariable) {
                result.setParameter(variable.getKey(), variable.getValueString(), 2, !variable.isAllowEdit());
                continue;
            }
            if (variable instanceof DateVariable || variable instanceof DateAndTimeVariable && ((DateAndTimeVariable)variable).isDateContent()) {
                result.setParameter(variable.getKey(), variable.getValueString(), 4, !variable.isAllowEdit());
                continue;
            }
            if (variable instanceof StringVariable) {
                result.setParameter(variable.getKey(), variable.getValueString(), 1, !variable.isAllowEdit());
                continue;
            }
            if (variable instanceof DropDownVariable) {
                result.setParameter(variable.getKey(), (String)((DropDownVariable)variable).getSelectedItem(), 1, !variable.isAllowEdit());
                continue;
            }
            result.setParameter(variable.getKey(), variable.getValueString(), 1, !variable.isAllowEdit());
        }
        return result;
    }
}

