/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.settingsmap;

import ericsson.ere.integration.settingsmap.Parameter;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.Set;

public class SettingsMap
implements Cloneable {
    private HashMap<String, Parameter> myParametersMap = new LinkedHashMap<String, Parameter>();
    private Properties myProperties = new Properties();

    public Parameter getParameter(String key) {
        return this.myParametersMap.get(key);
    }

    public String getProperty(String key) {
        return this.myProperties.getProperty(key);
    }

    public String getParameterAsString(String key) {
        Parameter tProperty = this.myParametersMap.get(key);
        if (tProperty != null && tProperty.getValue() != null) {
            return tProperty.getValue().toString();
        }
        return "";
    }

    public void setParameter(String key, String value, int type, boolean locked) {
        Parameter existingProperty = this.getParameter(key);
        if (existingProperty == null || !existingProperty.isLocked()) {
            Parameter newProperty = new Parameter(value, type, locked);
            this.myParametersMap.put(key, newProperty);
        }
    }

    public void setParameter(String key, String value) {
        this.setParameter(key, value, 1, false);
    }

    public void setParameter(String key, Parameter newProperty) {
        Parameter existingProperty = this.getParameter(key);
        if (existingProperty == null || !existingProperty.isLocked()) {
            this.myParametersMap.put(key, newProperty);
        }
    }

    public boolean parameterExists(String key) {
        return this.myParametersMap.containsKey(key);
    }

    public Set<String> getParametersKeySet() {
        return Collections.unmodifiableSet(this.myParametersMap.keySet());
    }

    public Set<Object> getPropertiesKeySet() {
        return Collections.unmodifiableSet(this.myProperties.keySet());
    }

    @Deprecated
    public void update(SettingsMap newParameterMap) {
        this.updateParametersFrom(newParameterMap);
    }

    public void updateParametersFrom(SettingsMap newParameterMap) {
        for (String key : this.myParametersMap.keySet()) {
            Parameter ownParameter = this.getParameter(key);
            Parameter newParameter = newParameterMap.getParameter(key);
            if (newParameter == null) continue;
            ownParameter.setValue(newParameter.getValue());
        }
    }

    public void mergeParametersFrom(SettingsMap mergeMap) {
        for (String key : mergeMap.getParametersKeySet()) {
            this.myParametersMap.put(key, mergeMap.getParameter(key));
        }
    }

    @Deprecated
    public void mergeMap(SettingsMap mergeMap) {
        this.mergeParametersFrom(mergeMap);
    }

    public Object clone() {
        SettingsMap clonedMap = new SettingsMap();
        for (String paramKey : this.getParametersKeySet()) {
            Parameter sourceParam = this.myParametersMap.get(paramKey);
            Parameter clonedParam = (Parameter)sourceParam.clone();
            clonedMap.setParameter(paramKey, clonedParam);
        }
        for (Object propertyKey : this.getPropertiesKeySet()) {
            String prop = this.myProperties.getProperty(propertyKey.toString());
            clonedMap.setProperty(propertyKey.toString(), prop);
        }
        return clonedMap;
    }

    public void clear() {
        this.myParametersMap.clear();
    }

    public void setProperty(String key, String value) {
        if (this.getProperty(key) == null) {
            this.myProperties.setProperty(key, value);
        }
    }

    public void removeParameter(String parameterName) {
        Parameter tParam = this.getParameter(parameterName);
        if (tParam != null && !tParam.isLocked()) {
            this.myParametersMap.remove(parameterName);
        }
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SettingsMap other = (SettingsMap)obj;
        if (this.myParametersMap == null ? other.myParametersMap != null : !this.myParametersMap.equals(other.myParametersMap)) {
            return false;
        }
        return !(this.myProperties == null ? other.myProperties != null : !this.myProperties.equals(other.myProperties));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.myParametersMap == null ? 0 : this.myParametersMap.hashCode());
        result = 31 * result + (this.myProperties == null ? 0 : this.myProperties.hashCode());
        return result;
    }
}

