/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.receiver.transport;

import com.ericsson.ere.util.PasswordHelper;
import ericsson.ere.integration.config.ArgumentHandler;
import ericsson.ere.integration.config.Configurable;
import ericsson.ere.integration.config.ConfigurationException;
import ericsson.ere.integration.log.EreIntegrationLogInterface;
import ericsson.ere.integration.log.Loggable;
import ericsson.ere.integration.receiver.requesthandler.RequestHandlerInterface;
import ericsson.ere.integration.receiver.transport.SocketTransportInterface;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.Socket;
import org.w3c.dom.Element;

public class TrafficTransport
implements SocketTransportInterface,
Loggable,
Configurable {
    Socket mySocket;
    RequestHandlerInterface myRequestHandler;
    EreIntegrationLogInterface myLog;
    int myMaxDataSize;

    public TrafficTransport() {
        this.myMaxDataSize = 0x100000;
    }

    public TrafficTransport(Socket socket) {
        block2: {
            this.myMaxDataSize = 0x100000;
            this.mySocket = socket;
            try {
                this.mySocket.setTcpNoDelay(true);
            }
            catch (Exception e) {
                if (!this.hasLoggerAtLevel(1)) break block2;
                this.myLog.print(1, "Error disabling TcpNoDelay\n" + e.getMessage());
            }
        }
    }

    @Override
    public void setLogg(EreIntegrationLogInterface logImpl) {
        this.myLog = logImpl;
    }

    @Override
    public SocketTransportInterface getSocketTransportObject(Socket socket) {
        TrafficTransport trafficTransport = new TrafficTransport(socket);
        trafficTransport.myLog = this.myLog;
        trafficTransport.myRequestHandler = this.myRequestHandler;
        trafficTransport.myMaxDataSize = this.myMaxDataSize;
        return trafficTransport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        boolean useErrorLog = this.hasLoggerAtLevel(1);
        String[] output = useErrorLog ? new String[2] : null;
        try (BufferedOutputStream out = new BufferedOutputStream(this.mySocket.getOutputStream());
             BufferedInputStream in = new BufferedInputStream(this.mySocket.getInputStream());){
            while (this.handleSingleRequest(in, out, output)) {
            }
        }
        catch (Exception e) {
            if (useErrorLog) {
                StringWriter stackTrace = new StringWriter();
                e.printStackTrace(new PrintWriter(stackTrace));
                String msg = "An exception occurred when parsing the request message: " + e.getMessage() + "\n";
                msg = msg + "Location: " + stackTrace.toString() + "\n";
                if (output[0] != null) {
                    msg = msg + "\nRequest received:\n" + PasswordHelper.replacePwdWithWildcardIfPresent(output[0]);
                }
                if (output[1] != null) {
                    msg = msg + "\nResponse produced:\n" + output[1];
                }
                this.myLog.print(1, msg);
            }
        }
        finally {
            block41: {
                if (!this.mySocket.isClosed()) {
                    try {
                        this.mySocket.close();
                    }
                    catch (IOException e) {
                        if (!useErrorLog) break block41;
                        this.myLog.print(1, "Error while closing the socket \n" + e.getMessage());
                    }
                }
            }
        }
    }

    private boolean handleSingleRequest(InputStream in, OutputStream out, String[] output) throws IOException {
        boolean success = false;
        String requestString = null;
        String responseString = null;
        int dataSize = this.readRequestLength(in);
        if (dataSize > 0) {
            if (dataSize > this.myMaxDataSize) {
                if (this.hasLoggerAtLevel(2)) {
                    this.myLog.print(2, "The request size (" + dataSize + " bytes) is too large. The maximum allowed size is " + this.myMaxDataSize + " bytes.");
                }
            } else {
                byte[] responseData;
                byte[] requestData = new byte[dataSize];
                int readLen = this.readDataFromStream(in, requestData);
                if (readLen < dataSize) {
                    String msg = String.format("Request length mismatch, expected %d bytes but got %d bytes.", dataSize, readLen);
                    throw new IOException(msg);
                }
                if (output != null) {
                    output[0] = requestString = new String(requestData);
                }
                try {
                    responseData = this.myRequestHandler.handleRequest(requestData);
                }
                catch (Exception e) {
                    responseData = this.createRequestHandlerErrorResponse(e);
                }
                if (output != null) {
                    output[1] = responseString = new String(responseData);
                }
                this.sendData(responseData, out);
                if (this.hasLoggerAtLevel(3)) {
                    if (requestString == null) {
                        requestString = new String(requestData);
                        responseString = new String(responseData);
                    }
                    this.myLog.print(3, "Request:\n" + PasswordHelper.replacePwdWithWildcardIfPresent(requestString) + "\n- Response :\n" + responseString);
                }
                success = true;
            }
        }
        return success;
    }

    private byte[] createRequestHandlerErrorResponse(Exception e) {
        if (this.hasLoggerAtLevel(3)) {
            this.myLog.print(3, "Not a valid request, error message is:\n" + e.getMessage());
        }
        String str = "<Response>\n<Error>" + e.getMessage() + "</Error>\n</Response>";
        byte[] responseData = str.getBytes();
        return responseData;
    }

    private int readRequestLength(InputStream in) throws IOException {
        byte[] sizeBytes = new byte[4];
        int readLen = this.readDataFromStream(in, sizeBytes);
        return readLen < 4 ? 0 : this.sizeToInt(sizeBytes);
    }

    private int readDataFromStream(InputStream in, byte[] data) throws IOException {
        int readBytes;
        int left = data.length;
        int offset = 0;
        while (left > 0 && (readBytes = in.read(data, offset, left)) >= 0) {
            left -= readBytes;
            offset += readBytes;
        }
        return offset;
    }

    public void sendString(String theString, OutputStream out) throws IOException {
        this.sendData(theString.getBytes(), out);
    }

    private void sendData(byte[] data, OutputStream out) throws IOException {
        byte[] dataSize = new byte[]{(byte)(data.length >> 24), (byte)(data.length >> 16), (byte)(data.length >> 8), (byte)(data.length >> 0)};
        out.write(dataSize);
        out.write(data);
        out.flush();
    }

    private static int getUnsignedByte(byte theByte) {
        int retValue = 0;
        retValue = theByte < 0 ? theByte + 256 : theByte;
        return retValue;
    }

    private int sizeToInt(byte[] size) {
        int retValue = TrafficTransport.getUnsignedByte(size[0]) * 256 * 256 * 256;
        retValue += TrafficTransport.getUnsignedByte(size[1]) * 256 * 256;
        retValue += TrafficTransport.getUnsignedByte(size[2]) * 256;
        if ((retValue += TrafficTransport.getUnsignedByte(size[3])) < 0) {
            return retValue + Integer.MAX_VALUE;
        }
        return retValue;
    }

    private boolean hasLoggerAtLevel(int level) {
        return this.myLog != null && this.myLog.isLevel(level);
    }

    @Override
    public void init(Element root) throws ConfigurationException {
        Object obj;
        ArgumentHandler handler = new ArgumentHandler(root);
        if (handler.isArgumentAnInt("MaxDataSize")) {
            this.setMaxDataSize(handler.getArgumentAsInt("MaxDataSize"));
        }
        if (!((obj = handler.getArgument("RequestHandler")) instanceof RequestHandlerInterface)) {
            throw new ConfigurationException("RequestHandler used by this Transport class (TrafficTransport) does NOT implement RequestHandlerInterface");
        }
        this.myRequestHandler = (RequestHandlerInterface)obj;
    }

    public void setMaxDataSize(int maxDataSize) {
        this.myMaxDataSize = maxDataSize;
    }
}

