/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.util;

import ericsson.ere.EreLibLoader;
import ericsson.ere.integration.util.FileHandling;
import ericsson.ere.management.DateUtil;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceProvider;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.io.File;
import java.io.FileNotFoundException;

public class WorkingDirHelper {
    public static final String SERVICE_TAG = "Service";
    public static final String PROPERTY_TAG = "Property";
    public static final String KEY_ATTR = "key";
    public static final String VALUE_ATTR = "value";

    private static String backSlashToSlash(String str) {
        return str.replace('\\', '/');
    }

    public static String createServiceXML(String tabs, Service service, boolean addDetails, boolean response) {
        String m_serviceId = service.getId();
        String m_definitionFileName = service.getDefinitionFileName();
        String m_conditionsFileName = service.getConditionsFileName();
        String config = "";
        if (addDetails) {
            try {
                if (new File(m_conditionsFileName).exists() && new File(m_conditionsFileName).isFile()) {
                    String def = FileHandling.fileToStringBuffer(WorkingDirHelper.checkFile(m_definitionFileName)).toString();
                    def = def.replaceFirst("</ServiceDefinition>", "");
                    config = def + "\n" + FileHandling.fileToStringBuffer(WorkingDirHelper.checkFile(m_conditionsFileName)).toString() + "\n</ServiceDefinition>";
                } else {
                    config = FileHandling.fileToStringBuffer(WorkingDirHelper.checkFile(m_definitionFileName)).toString();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("error : " + e.getMessage());
            }
        }
        m_definitionFileName = WorkingDirHelper.stripWorkingDir(m_definitionFileName);
        if (service.isConditionStoredSeparate()) {
            m_conditionsFileName = WorkingDirHelper.stripWorkingDir(m_conditionsFileName);
        } else if (response) {
            m_conditionsFileName = WorkingDirHelper.stripWorkingDir(WorkingDirHelper.replaceSubString(m_definitionFileName, "Definition", "Condition"));
        }
        return tabs + "<Service" + XMLUtil.wrapValueOrEmptyStringInAttribute("Name", m_serviceId) + XMLUtil.wrapValueOrEmptyStringInAttribute("DefinitionFile", m_definitionFileName) + XMLUtil.wrapValueOrEmptyStringInAttribute("ConditionLeafClassFile", m_conditionsFileName) + ">\n" + config + tabs + "</Service>\n";
    }

    private static String replaceSubString(String s, String oldToken, String newToken) {
        if (s == null || oldToken == null || newToken == null) {
            return s;
        }
        int tokenPos = s.indexOf(oldToken);
        if (tokenPos == -1) {
            return s;
        }
        String start = s.substring(0, tokenPos);
        String end = s.substring(tokenPos + oldToken.length());
        return WorkingDirHelper.replaceSubString(start + newToken + end, oldToken, newToken);
    }

    public static String createRatingPeriodXML(String tabs, RatingPeriod ratingPeriod, boolean addDetails) {
        String m_structureFile = WorkingDirHelper.stripWorkingDir(ratingPeriod.getFileName());
        String config = "";
        if (addDetails) {
            try {
                config = FileHandling.fileToStringBuffer(WorkingDirHelper.checkFile(m_structureFile)).toString() + "\n";
            }
            catch (Exception e) {
                e.printStackTrace();
                System.out.println("error : " + e.getMessage());
            }
        }
        return tabs + "<RatingPeriod" + XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPeriod.getName()) + WorkingDirHelper.createAttribute("StartDate", DateUtil.format(ratingPeriod.getStartTime())) + XMLUtil.wrapValueOrEmptyStringInAttribute("RatingStructureFile", m_structureFile) + ">\n" + config + tabs + "</RatingPeriod>\n";
    }

    public static String createPeriodPropertyResponseXML(String tabs, RatingPeriod period, String[] keys, String[] values) {
        String keyString = StringUtil.buildSemiColonSeparatedString(keys);
        String valueString = StringUtil.buildSemiColonSeparatedString(values);
        return tabs + "<" + PROPERTY_TAG + WorkingDirHelper.createAttribute(KEY_ATTR, keyString) + WorkingDirHelper.createAttribute(VALUE_ATTR, valueString) + " />" + WorkingDirHelper.createRatingPeriodXML(tabs, period, false);
    }

    public static String createServicePropertyResponseXML(String tabs, String serviceName, String[] keys, String[] values) {
        String keyString = StringUtil.buildSemiColonSeparatedString(keys);
        String valueString = StringUtil.buildSemiColonSeparatedString(values);
        return tabs + "<" + PROPERTY_TAG + WorkingDirHelper.createAttribute(KEY_ATTR, keyString) + WorkingDirHelper.createAttribute(VALUE_ATTR, valueString) + " /><Service" + WorkingDirHelper.createAttribute("Name", serviceName) + " />";
    }

    public static String createServiceProviderXML(String tabs, ServiceProvider serviceProvider, boolean addDetails) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(tabs + "<ServiceProvider " + XMLUtil.wrapValueOrEmptyStringInAttribute("Name", serviceProvider.getName()) + ">\n");
        for (RatingPlan currentRatingPlan : serviceProvider.getAllRatingPlans()) {
            buffer.append(tabs + tabs + "<RatingPlan " + XMLUtil.wrapValueOrEmptyStringInAttribute("Name", currentRatingPlan.getIdentity()) + XMLUtil.wrapValueOrEmptyStringInAttribute(SERVICE_TAG, currentRatingPlan.getServiceName()) + ">\n");
            for (RatingPeriod currentRatingPeriod : currentRatingPlan.getAllRatingPeriods()) {
                buffer.append(WorkingDirHelper.createRatingPeriodXML(tabs + tabs + tabs, currentRatingPeriod, addDetails));
            }
            buffer.append(tabs + tabs + "</RatingPlan>\n");
        }
        buffer.append(tabs + "</ServiceProvider>\n");
        return buffer.toString();
    }

    public static String stripWorkingDir(String fn) {
        String retStr = "";
        File f = new File(fn);
        File workingDir = new File(WorkingDirHelper.getWorkingDirectoryString());
        retStr = f.isAbsolute() && fn.startsWith(workingDir.getAbsolutePath()) ? WorkingDirHelper.backSlashToSlash(fn.substring(workingDir.getAbsolutePath().length() + 1)) : WorkingDirHelper.backSlashToSlash(fn);
        return retStr;
    }

    public static String getWorkingDirectoryString() {
        String workingDirectory = System.getProperty(EreLibLoader.KEY_WORKINGDIRECTORY);
        if (workingDirectory.startsWith(".")) {
            return WorkingDirHelper.backSlashToSlash(System.getProperty("user.dir") + System.getProperty("file.separator") + workingDirectory);
        }
        return WorkingDirHelper.backSlashToSlash(workingDirectory);
    }

    private static String createAttribute(String name, String value) {
        return " " + name + "=\"" + value + "\" ";
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static String checkFile(String fn) throws Exception {
        String retStr = "";
        File f = new File(fn);
        File workingDir = new File(WorkingDirHelper.getWorkingDirectoryString());
        if (f.isAbsolute()) {
            if (!f.exists()) {
                throw new FileNotFoundException("File '" + fn + "' does not exist ");
            }
            if (!f.getPath().startsWith(workingDir.getPath())) throw new Exception("File '" + fn + "' must be in the working directory '" + WorkingDirHelper.getWorkingDirectoryString() + "'");
            return fn;
        }
        f = new File(WorkingDirHelper.getWorkingDirectoryString() + fn);
        if (!f.exists()) throw new FileNotFoundException("File '" + WorkingDirHelper.getWorkingDirectoryString() + fn + "' does not exist ");
        return WorkingDirHelper.getWorkingDirectoryString() + fn;
    }
}

