/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.serviceprovider.action;

import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.ServiceProvider;
import org.w3c.dom.Node;

public class ServiceProviderAction
extends AbstractAction {
    public static String TAG_SERVICEPROVIDER = "ServiceProvider";

    public static ServiceProvider createServiceProvider(Node serviceProviderNode, EreManager ereManager) throws Exception {
        String serviceProviderName = ServiceProviderAction.getServiceProviderName(serviceProviderNode);
        ServiceProvider serviceProvider = ereManager.getServiceProvider(serviceProviderName);
        if (serviceProvider != null) {
            throw new Exception("ServiceProvider '" + serviceProviderName + "' already exists in Rating Manager");
        }
        serviceProvider = new ServiceProvider(serviceProviderName);
        return serviceProvider;
    }

    public ServiceProvider getServiceProvider(Node serviceProviderNode) throws Exception {
        return ServiceProviderAction.getServiceProvider(serviceProviderNode, this.getEreManager());
    }

    public static ServiceProvider getServiceProvider(Node serviceProviderNode, EreManager ereManager) throws Exception {
        String serviceProviderName = ServiceProviderAction.getServiceProviderName(serviceProviderNode);
        ServiceProvider serviceProvider = ereManager.getServiceProvider(serviceProviderName);
        if (serviceProvider == null) {
            throw new Exception("ServiceProvider '" + serviceProviderName + "' does NOT exist in Rating Manager");
        }
        return serviceProvider;
    }

    public static String getServiceProviderName(Node serviceNode) throws Exception {
        return ServiceProviderAction.getAttribute("Name", serviceNode);
    }

    public String setServiceProvider(Node serviceProviderNode) throws Exception {
        String serviceProviderName = ServiceProviderAction.getServiceProviderName(serviceProviderNode);
        ServiceProvider serviceProvider = this.getEreManager().getServiceProvider(serviceProviderName);
        if (serviceProvider == null) {
            throw new Exception("ServiceProvider '" + serviceProviderName + "' does NOT exist in Rating Manager");
        }
        this.changeName(serviceProvider, serviceProviderNode);
        return "";
    }

    private void changeName(ServiceProvider serviceProvider, Node serviceProviderNode) throws Exception {
        String newName = ServiceProviderAction.getServiceProviderNewName(serviceProviderNode);
        if (newName.equals(serviceProvider.getName())) {
            return;
        }
        if (this.getEreManager().getServiceProvider(newName) != null) {
            throw new Exception("Already exist a Service provider with'" + newName + "'");
        }
        this.getEreManager().removeServiceProvider(serviceProvider.getName());
        serviceProvider.changeServiceProviderName(newName, this.getEreManager());
        this.getEreManager().addServiceProvider(serviceProvider);
    }

    private static String getServiceProviderNewName(Node serviceProviderNode) throws Exception {
        return ServiceProviderAction.getAttribute("NewName", serviceProviderNode);
    }

    public void deleteServiceProvider(Node serviceProviderNode) throws Exception {
        ServiceProvider serviceProvider = this.getServiceProvider(serviceProviderNode);
        this.getEreManager().removeServiceProvider(serviceProvider.getName());
    }
}

