/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.service.action;

import com.ericsson.ere.dataset.jump.EreJumperSuppport;
import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.integration.management.FileVersionHandler;
import ericsson.ere.integration.management.util.WorkingDirHelper;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceProvider;
import ericsson.ere.management.ServiceUpgradeException;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.XMLUtil;
import java.io.FileNotFoundException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ServiceAction
extends AbstractAction {
    public static String TAG_SERVICE = "Service";
    public static String TAG_SERVICEDEFINITION = "ServiceDefinition";

    protected Service createService(Node node) throws Exception {
        String serviceName = ServiceAction.getServiceName(node);
        if (this.getEreManager().containsServiceCaseInsensitive(serviceName)) {
            throw new Exception("Service '" + serviceName + "' or service with name that is interpreted as '" + serviceName + "' already exists in Rating Manager");
        }
        String definitionFileName = WorkingDirHelper.getWorkingDirectoryString() + "/Service/" + ServiceAction.fixDirName(serviceName) + "/" + ServiceAction.getAttribute("DefinitionFile", node);
        String conditionFileName = ServiceAction.getAttribute("ConditionLeafClassFile", node) != null ? WorkingDirHelper.getWorkingDirectoryString() + "/Service/" + ServiceAction.fixDirName(serviceName) + "/" + ServiceAction.getAttribute("ConditionLeafClassFile", node) : null;
        Service service = new Service(serviceName);
        service.setDefinitionFileName(definitionFileName);
        service.setConditionsFileName(conditionFileName);
        ServiceAction.setDefinitionFile(definitionFileName, node, service);
        if (service.isConditionStoredSeparate()) {
            ServiceAction.setConditionsFile(conditionFileName, node, service);
        }
        service.setJumperSupport(new EreJumperSuppport(this.myEreManager));
        return service;
    }

    protected void deleteService(Node node) throws Exception {
        String serviceName = ServiceAction.getServiceName(node);
        this.getEreManager().getPropertyContainer().forgetService(serviceName);
        if (!this.getEreManager().containsService(serviceName)) {
            throw new Exception("Service '" + serviceName + "' does not exist in Rating Manager");
        }
        Service service = this.getEreManager().getService(serviceName);
        for (ServiceProvider currentServiceProvider : this.getEreManager().getAllServiceProviders()) {
            for (RatingPlan currentRatingPlan : currentServiceProvider.getRatingPlans()) {
                if (currentRatingPlan.getService() != service) continue;
                throw new Exception("Service is used by at least one RatingPlan '" + currentRatingPlan.getName().split("%")[0] + "'");
            }
        }
        this.getEreManager().removeService(service);
    }

    protected String setService(Node node) throws Exception {
        String serviceName = ServiceAction.getServiceName(node);
        this.getEreManager().getPropertyContainer().forgetService(serviceName);
        String newName = null;
        try {
            newName = ServiceAction.getServiceNewName(node);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._setService(node, serviceName, newName, null);
    }

    protected String setService(Node node, String currentName, String newName, String definitionFileName) throws Exception {
        if (node == null) {
            throw new IllegalArgumentException("Provided service xml must be non-null when setting service.");
        }
        if (currentName == null) {
            throw new IllegalArgumentException("Service name must be defined.");
        }
        return this._setService(node, currentName, newName, definitionFileName);
    }

    private String _setService(Node node, String currentServiceName, String newServiceName, String definitionFileName) throws Exception {
        boolean isForced = Boolean.valueOf(((Element)node).getAttribute("isForced"));
        if (!this.getEreManager().containsService(currentServiceName)) {
            throw new Exception("Service " + currentServiceName + " does not exist in Rating Manager");
        }
        Service service = this.getEreManager().getService(currentServiceName);
        boolean serviceUsed = this.isServiceUsed(service, isForced);
        if (newServiceName != null) {
            if (serviceUsed) {
                throw new ServiceUpgradeException("NOT possible to change the name as the Service is used by at least one RatingPlan");
            }
            service.changeServiceName(newServiceName, this.getEreManager());
        }
        Element conditionNode = XMLUtil.getNamedElement("Settings", ((Element)node).getElementsByTagName("Settings"));
        Node definitionRoot = this.getDefinitionElement((Element)node);
        if (definitionRoot != null && conditionNode != null) {
            definitionRoot.appendChild(conditionNode);
            service.upgrade((Element)definitionRoot, isForced || !serviceUsed);
            String defFileName = definitionFileName;
            if (definitionFileName == null) {
                defFileName = ServiceAction.getDefinitionFileName(node, service);
            }
            ServiceAction._setDefinitionFile(defFileName, definitionRoot, service);
            service.setConditionsFileName(null);
        }
        service.setJumperSupport(new EreJumperSuppport(this.myEreManager));
        return "Service '" + currentServiceName + "' upgraded.\nCommand : " + node.toString();
    }

    private boolean isServiceUsed(Service service, boolean isForced) {
        boolean serviceUsed = false;
        if (!isForced) {
            for (ServiceProvider currentServiceProvider : this.getEreManager().getAllServiceProviders()) {
                for (RatingPlan currentRatingPlan : currentServiceProvider.getRatingPlans()) {
                    if (currentRatingPlan.getService() != service) continue;
                    serviceUsed = true;
                    break;
                }
                if (!serviceUsed) continue;
                break;
            }
        }
        return serviceUsed;
    }

    private Node getDefinitionElement(Element node) {
        Element definitionRoot = XMLUtil.getNamedElement("ServiceDefinition", node.getElementsByTagName("ServiceDefinition"));
        if (definitionRoot == null) {
            definitionRoot = node.getTagName().equals("ServiceDefinition") ? node : null;
        }
        return definitionRoot;
    }

    protected Service getService(Node node) throws Exception {
        String serviceName = ServiceAction.getServiceName(node);
        if (!this.getEreManager().containsService(serviceName)) {
            throw new Exception("Service " + serviceName + " does not exist in Rating Manager");
        }
        Service service = this.getEreManager().getService(serviceName);
        return service;
    }

    protected static String getDefinitionFile(Node node) throws Exception {
        String fileName = ServiceAction.getAttribute("DefinitionFile", node);
        return WorkingDirHelper.checkFile(fileName);
    }

    protected static String getConditionsFile(Node node) throws Exception {
        String fileName = ServiceAction.getAttribute("ConditionLeafClassFile", node);
        return WorkingDirHelper.checkFile(fileName);
    }

    protected static String getServiceName(Node serviceNode) throws Exception {
        return ServiceAction.getAttribute("Name", serviceNode);
    }

    protected static void setDefinitionFile(Node node, Service service) throws Exception {
        String definitionFileName = ServiceAction.getDefinitionFileName(node, service);
        ServiceAction.setDefinitionFile(definitionFileName, node, service);
    }

    private static String getDefinitionFileName(Node node, Service service) throws Exception {
        String definitionFileName = "";
        try {
            definitionFileName = ServiceAction.getAttribute("DefinitionFile", node);
            definitionFileName = StringUtil.convertFilePathString(definitionFileName);
            definitionFileName = WorkingDirHelper.checkFile(definitionFileName);
            service.setDefinitionFileName(definitionFileName);
        }
        catch (FileNotFoundException e) {
            definitionFileName = WorkingDirHelper.getWorkingDirectoryString() + definitionFileName;
        }
        return definitionFileName;
    }

    protected static void setDefinitionFile(String definitionFileName, Node node, Service service) throws Exception {
        Element definitionNodeFile = XMLUtil.getNamedElement("DefinitionFile", node.getChildNodes());
        Element conditionNode = XMLUtil.getNamedElement("Settings", ((Element)node).getElementsByTagName("Settings"));
        Element definitionRoot = XMLUtil.getNamedElement("ServiceDefinition", ((Element)node).getElementsByTagName("ServiceDefinition"));
        definitionRoot.appendChild(conditionNode);
        if (definitionNodeFile == null) {
            return;
        }
        String fileName = FileVersionHandler.createNewVersionedFile(4, definitionFileName, definitionNodeFile);
        service.setDefinitionFileName(fileName);
    }

    private static void _setDefinitionFile(String definitionFileName, Node definitionRootNode, Service service) throws Exception {
        if (definitionRootNode == null) {
            return;
        }
        Element conditionNode = XMLUtil.getNamedElement("Settings", ((Element)definitionRootNode).getElementsByTagName("Settings"));
        if (XMLUtil.getFirstElementNamed("Settings", (Element)definitionRootNode) == null) {
            definitionRootNode.appendChild(conditionNode);
        }
        String newDefinitionFileName = FileVersionHandler.createNewVersionedFileIncludingAllConfig(4, definitionFileName, definitionRootNode);
        service.setDefinitionFileName(newDefinitionFileName);
    }

    protected static void setConditionsFile(Node node, Service service) throws Exception {
        String conditionFileName = "";
        try {
            conditionFileName = ServiceAction.getAttribute("ConditionLeafClassFile", node);
            conditionFileName = WorkingDirHelper.checkFile(conditionFileName);
            service.setConditionsFileName(conditionFileName);
        }
        catch (FileNotFoundException e) {
            conditionFileName = WorkingDirHelper.getWorkingDirectoryString() + conditionFileName;
        }
        ServiceAction.setConditionsFile(conditionFileName, node, service);
    }

    protected static void setConditionsFile(String conditionFileName, Node node, Service service) throws Exception {
        Element conditionNode = XMLUtil.getNamedElement("ConditionFile", node.getChildNodes());
        if (conditionNode == null) {
            return;
        }
        conditionFileName = FileVersionHandler.createNewVersionedFile(4, conditionFileName, conditionNode);
        service.setConditionsFileName(conditionFileName);
    }

    protected static String getServiceNewName(Node serviceNode) throws Exception {
        return ServiceAction.getAttribute("NewName", serviceNode);
    }

    protected void changeName(Service service, Node serviceNode) throws Exception {
        String newName;
        try {
            newName = ServiceAction.getServiceNewName(serviceNode);
        }
        catch (Exception e) {
            return;
        }
        service.changeServiceName(newName, this.getEreManager());
    }

    private static String fixDirName(String str) {
        return str.replace(' ', '_').replace('/', '-').replace('\\', '-');
    }
}

