/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.ratingplan.action;

import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.management.EreManager;
import ericsson.ere.management.RatingPlan;
import ericsson.ere.management.Service;
import ericsson.ere.management.ServiceProvider;
import org.w3c.dom.Node;

public class RatingPlanAction
extends AbstractAction {
    public static String TAG_RATINGPLAN = "RatingPlan";
    private static String ATTR_NAME = "Name";
    private static String ATTR_NEW_NAME = "NewName";
    private static String ATTR_SERVICE = "Service";

    public static RatingPlan createRatingPlan(ServiceProvider serviceProvider, Node ratingPlanNode, EreManager ereManager) throws Exception {
        String ratingPlanName = RatingPlanAction.getRatingPlanName(ratingPlanNode);
        RatingPlan ratingPlan = serviceProvider.getRatingPlan(ratingPlanName);
        if (ratingPlan != null) {
            throw new Exception("Rating plan '" + ratingPlanName + "' already exist for the Service '" + serviceProvider.getName() + "'");
        }
        String serviceName = RatingPlanAction.getServiceName(ratingPlanNode);
        Service service = ereManager.getService(serviceName);
        if (service == null) {
            throw new Exception("Service '" + serviceName + "' does NOT exist ");
        }
        ratingPlan = new RatingPlan(serviceProvider, ratingPlanName + "%" + serviceProvider.getName(), ratingPlanName, serviceName);
        ratingPlan.setService(service);
        return ratingPlan;
    }

    public static String getRatingPlanName(Node serviceNode) throws Exception {
        return RatingPlanAction.getAttribute(ATTR_NAME, serviceNode);
    }

    public static String getServiceName(Node serviceNode) throws Exception {
        return RatingPlanAction.getAttribute(ATTR_SERVICE, serviceNode);
    }

    public static RatingPlan getRatingPlan(ServiceProvider serviceProvider, Node ratingPlanNode) throws Exception {
        String ratingPlanName = RatingPlanAction.getRatingPlanName(ratingPlanNode);
        RatingPlan ratingPlan = serviceProvider.getRatingPlan(ratingPlanName);
        if (ratingPlan == null) {
            throw new Exception("Rating plan '" + ratingPlanName + "' does NOT  exist for the " + serviceProvider.getName());
        }
        return ratingPlan;
    }

    public static void deleteRatingPlan(ServiceProvider serviceProvider, Node ratingPlanNode) throws Exception {
        String ratingPlanName = RatingPlanAction.getRatingPlanName(ratingPlanNode);
        RatingPlan ratingPlan = serviceProvider.getRatingPlan(ratingPlanName);
        if (ratingPlan == null) {
            throw new Exception("Rating plan '" + ratingPlanName + "' does NOT  exist for the " + serviceProvider.getName());
        }
        serviceProvider.removeRatingPlan(ratingPlan.getIdentity());
    }

    public String setRatingPlan(ServiceProvider serviceProvider, Node ratingPlanNode) throws Exception {
        String ratingPlanName = RatingPlanAction.getRatingPlanName(ratingPlanNode);
        RatingPlan ratingPlan = serviceProvider.getRatingPlan(ratingPlanName);
        if (ratingPlan == null) {
            throw new Exception("Rating plan '" + ratingPlanName + "' does NOT  exist for the " + serviceProvider.getName());
        }
        RatingPlanAction.changeName(ratingPlan, ratingPlanNode);
        return "RatingPlan '" + ratingPlanName + "' updated \nCommand : " + ratingPlanNode.toString();
    }

    public static void changeName(RatingPlan ratingPlan, Node ratingPlanNode) throws Exception {
        try {
            String newName = RatingPlanAction.getRatingPlanNewName(ratingPlanNode);
            ratingPlan.changeRatingPlanName(newName);
        }
        catch (Exception e) {
            return;
        }
    }

    public static String getRatingPlanNewName(Node ratingPlanNode) throws Exception {
        return RatingPlanAction.getAttribute(ATTR_NEW_NAME, ratingPlanNode);
    }
}

