/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.management.audit.action;

import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.integration.management.AbstractAction;
import ericsson.ere.util.PackageUtil;
import java.util.Iterator;
import java.util.List;
import org.w3c.dom.Node;

public class AuditAction
extends AbstractAction {
    private static final String TAG_PROPERTIES = "Properties";
    private static final String TAG_PROPERTY = "Property";
    private static final String TAG_PLUGINS = "Plugins";
    private static final String TAG_EXTENDS = "Extends";
    private static final String TAG_CLASS = "Class";
    private static final String ATTR_NAME = "name";

    public String getServerInfo(Node fileNode) throws Exception {
        StringBuffer buffer = new StringBuffer("<ServerInfo>");
        buffer.append(EreClassLoader.getProperties().toString());
        buffer.append(this.getEreManager().getProperties());
        buffer.append(this.getSystemPropertiesXML());
        buffer.append(this.getPlugins());
        buffer.append("\n</ServerInfo>");
        return buffer.toString();
    }

    private StringBuffer getSystemPropertiesXML() {
        StringBuffer xml = new StringBuffer();
        Iterator<Object> propIt = System.getProperties().keySet().iterator();
        xml.append("\n\t<Properties>");
        while (propIt.hasNext()) {
            String currentKey = propIt.next().toString();
            xml.append("\n\t\t<Property name='" + currentKey + "' value='" + System.getProperty(currentKey) + "'/>");
        }
        xml.append("\n\t</Properties>");
        return xml;
    }

    private StringBuffer getPlugins() {
        StringBuffer xml = new StringBuffer();
        xml.append("\n\t<Plugins>");
        PackageUtil.reset();
        xml.append(this.getXMLForClassesExtending("ericsson.ere.structure.AbstractTariffStructureProfile"));
        xml.append(this.getXMLForClassesExtending("ericsson.ere.condition.AbstractCondition"));
        xml.append(this.getXMLForClassesExtending("ericsson.ere.condition.AbstractConditionProfile"));
        xml.append(this.getXMLForClassesExtending("ericsson.ere.leaf.AbstractModifier"));
        xml.append(this.getXMLForClassesExtending("ericsson.ere.leaf.AbstractModifierProfile"));
        PackageUtil.reset();
        xml.append("\n\t</Plugins>");
        return xml;
    }

    private StringBuffer getXMLForClassesExtending(String classExtended) {
        StringBuffer xml = new StringBuffer();
        xml.append("\n\t\t<Extends name='" + classExtended + "'>");
        List<String> extendedList = PackageUtil.getClassesExtending(classExtended);
        for (int ii = 0; ii < extendedList.size(); ++ii) {
            xml.append("\n\t\t\t<Class name='" + extendedList.get(ii) + "'/>");
        }
        xml.append("\n\t\t</Extends>");
        return xml;
    }
}

