/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.integration.defs;

import com.ericsson.ere.proxy.RatingManagerProxy;
import com.ericsson.ere.proxy.RatingPeriodProxy;
import com.ericsson.ere.proxy.RatingPlanProxy;
import com.ericsson.ere.proxy.ServiceListProxy;
import com.ericsson.ere.proxy.ServiceProviderProxy;
import com.ericsson.ere.proxy.ServiceProxy;
import com.ericsson.ere.util.TypedKey;
import ericsson.ere.datatype.DataType;
import ericsson.ere.datatype.Time;
import ericsson.ere.integration.defs.EreXmlCommand;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.management.RatingPeriod;
import ericsson.ere.util.StringUtil;
import ericsson.ere.xml.DomWriter;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.VarListUtil;
import org.w3c.dom.Element;

public class EreXmlCommandHelper
extends EreXmlCommand {
    public static String getValueFromModel(VarTableModel model, String label) {
        return VarListUtil.getValueStringForName(model.getData(), label);
    }

    public static Time getTimeValueFromModel(VarTableModel model, String label) {
        return (Time)VarListUtil.getTimeValueForName(model.getData(), label);
    }

    private static String createRatingPeriodXML(RatingPeriodProxy ratingPeriodProxy) {
        return "<ServiceProvider" + XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPeriodProxy.getServiceProviderName()) + "><" + "RatingPlan" + XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPeriodProxy.getRatingPlanName()) + "><" + "RatingPeriod" + XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPeriodProxy.getName()) + XMLUtil.wrapValueOrEmptyStringInAttribute("StartDate", ratingPeriodProxy.getRatingPeriodStartTime()) + "/></" + "RatingPlan" + "></" + "ServiceProvider" + ">";
    }

    private static String createRatingPeriodXML(RatingPeriod ratingPeriod) {
        return "<ServiceProvider" + EreXmlCommandHelper.createAttribute("Name", ratingPeriod.getServiceProviderName()) + "><" + "RatingPlan" + EreXmlCommandHelper.createAttribute("Name", ratingPeriod.getRatingPlanId()) + "><" + "RatingPeriod" + EreXmlCommandHelper.createAttribute("Name", ratingPeriod.getName()) + "/></" + "RatingPlan" + "></" + "ServiceProvider" + ">";
    }

    public static String createRatingPeriodGetRequest(RatingPeriodProxy ratingPeriodProxy, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingPeriod", "Get", sessionId) + "\n" + EreXmlCommandHelper.createRatingPeriodXML(ratingPeriodProxy) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    @Deprecated
    public static String createRatingPeriodGetRequest(RatingPeriod ratingPeriod, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingPeriod", "Get", sessionId) + "\n" + EreXmlCommandHelper.createRatingPeriodXML(ratingPeriod) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    public static String createServiceGetRequest(String serviceName, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("Service", "Get", sessionId) + "\n" + EreXmlCommandHelper.createTagWithAttributes("Service", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", serviceName)) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    public static String createServiceProviderCreateRequest(SettingsMap model, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("ServiceProvider", "Create", sessionId) + "\n" + EreXmlCommandHelper.createTagWithAttributes("ServiceProvider", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", model.getParameterAsString("Name"))) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    public static String createServiceProviderDeleteRequest(ServiceProviderProxy serviceProviderProxy, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("ServiceProvider", "Delete", sessionId) + "\n" + EreXmlCommandHelper.createTagWithAttributes("ServiceProvider", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", serviceProviderProxy.getName())) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createServiceProviderNewNameTag(ServiceProviderProxy serviceProviderProxy, SettingsMap newValues) {
        return EreXmlCommandHelper.createTagWithAttributes("ServiceProvider", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", serviceProviderProxy.getName()), XMLUtil.wrapValueOrEmptyStringInAttribute("NewName", newValues.getParameter("Name").getValue()));
    }

    public static String createServiceProviderSetRequest(ServiceProviderProxy serviceProviderProxy, SettingsMap newValues, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("ServiceProvider", "Set", sessionId) + "\n" + EreXmlCommandHelper.createServiceProviderNewNameTag(serviceProviderProxy, newValues) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createRatingPlanTag(ServiceProviderProxy serviceProviderProxy, SettingsMap newValues) {
        return EreXmlCommandHelper.createStartTagWithAttributes("ServiceProvider", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", serviceProviderProxy.getName())) + "\n" + EreXmlCommandHelper.createTagWithAttributes("RatingPlan", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", newValues.getParameterAsString("Name")), XMLUtil.wrapValueOrEmptyStringInAttribute("Service", newValues.getParameterAsString("Service"))) + "\n" + EreXmlCommandHelper.createEndTag("ServiceProvider");
    }

    private static String createRatingPlanTag(RatingPlanProxy ratingPlanProxy) {
        return EreXmlCommandHelper.createStartTagWithAttributes("ServiceProvider", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPlanProxy.getServiceProviderProxy().getName())) + "\n" + EreXmlCommandHelper.createTagWithAttributes("RatingPlan", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPlanProxy.getName()), XMLUtil.wrapValueOrEmptyStringInAttribute("Service", ratingPlanProxy.getServiceName())) + "\n" + EreXmlCommandHelper.createEndTag("ServiceProvider");
    }

    public static String createRatingPlanDeleteRequest(RatingPlanProxy ratingPlanProxy, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingPlan", "Delete", sessionId) + "\n" + EreXmlCommandHelper.createRatingPlanTag(ratingPlanProxy) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    public static String createRatingPlanCreateRequest(ServiceProviderProxy serviceProviderProxy, SettingsMap model, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingPlan", "Create", sessionId) + "\n" + EreXmlCommandHelper.createRatingPlanTag(serviceProviderProxy, model) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createRatingPlanNewNameTag(RatingPlanProxy ratingPlanProxy, SettingsMap newValues) {
        return EreXmlCommandHelper.createStartTagWithAttributes("ServiceProvider", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPlanProxy.getServiceProviderProxy().getName())) + "\n" + EreXmlCommandHelper.createTagWithAttributes("RatingPlan", XMLUtil.wrapValueOrEmptyStringInAttribute("NewName", newValues.getParameter("Name").getValue()), XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPlanProxy.getName()), XMLUtil.wrapValueOrEmptyStringInAttribute("Service", newValues.getParameter("Service").getValue())) + "\n" + EreXmlCommandHelper.createEndTag("ServiceProvider");
    }

    public static String createRatingPlanSetRequest(RatingPlanProxy ratingPlanProxy, SettingsMap newValues, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingPlan", "Set", sessionId) + "\n" + EreXmlCommandHelper.createRatingPlanNewNameTag(ratingPlanProxy, newValues) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createRatingPeriodTag(RatingPlanProxy ratingPlanProxy, SettingsMap newValues, Element newStructureXml) {
        String strXml = DomWriter.elementToString(newStructureXml);
        return EreXmlCommandHelper.createStartTagWithAttributes("ServiceProvider", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPlanProxy.getServiceProviderProxy().getName())) + "\n" + EreXmlCommandHelper.createStartTagWithAttributes("RatingPlan", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPlanProxy.getName()), XMLUtil.wrapValueOrEmptyStringInAttribute("Service", ratingPlanProxy.getServiceName())) + "\n" + EreXmlCommandHelper.createStartTagWithAttributes("RatingPeriod", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", newValues.getParameterAsString("Name")), XMLUtil.wrapValueOrEmptyStringInAttribute("StartDate", newValues.getParameterAsString("Start date")), XMLUtil.wrapValueOrEmptyStringInAttribute("RatingStructureFile", newValues.getParameterAsString("Selection Tree file"))) + "\n" + EreXmlCommandHelper.createStartTag("RatingRuleTree") + "\n" + strXml + "\n" + EreXmlCommandHelper.createEndTag("RatingRuleTree") + "\n" + EreXmlCommandHelper.createEndTag("RatingPeriod") + "\n" + EreXmlCommandHelper.createEndTag("RatingPlan") + "\n" + EreXmlCommandHelper.createEndTag("ServiceProvider");
    }

    public static String createRatingPeriodCreateRequest(RatingPlanProxy ratingPlanProxy, SettingsMap model, Element structureXml, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingPeriod", "Create", sessionId) + "\n" + EreXmlCommandHelper.createRatingPeriodTag(ratingPlanProxy, model, structureXml) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createRatingPeriodNewNameTag(RatingPeriodProxy ratingPeriodProxy, SettingsMap newValues) {
        return EreXmlCommandHelper.createStartTagWithAttributes("ServiceProvider", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPeriodProxy.getServiceProviderName())) + "\n" + EreXmlCommandHelper.createStartTagWithAttributes("RatingPlan", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPeriodProxy.getRatingPlanName()), XMLUtil.wrapValueOrEmptyStringInAttribute("Service", ratingPeriodProxy.getServiceName())) + "\n" + EreXmlCommandHelper.createStartTagWithAttributes("RatingPeriod", XMLUtil.wrapValueOrEmptyStringInAttribute("NewName", newValues.getParameterAsString("Name")), XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPeriodProxy.getName()), XMLUtil.wrapValueOrEmptyStringInAttribute("StartDate", ratingPeriodProxy.getRatingPeriodStartTime()), XMLUtil.wrapValueOrEmptyStringInAttribute("NewStartDate", newValues.getParameter("Start date").getValue()), XMLUtil.wrapValueOrEmptyStringInAttribute("RatingStructureFile", newValues.getParameterAsString("Selection Tree file"))) + "\n" + EreXmlCommandHelper.createEndTag("RatingPeriod") + "\n" + EreXmlCommandHelper.createEndTag("RatingPlan") + "\n" + EreXmlCommandHelper.createEndTag("ServiceProvider");
    }

    public static String createRatingPeriodSetRequest(RatingPeriodProxy ratingPeriodProxy, SettingsMap newValues, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingPeriod", "Set", sessionId) + "\n" + EreXmlCommandHelper.createRatingPeriodNewNameTag(ratingPeriodProxy, newValues) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createRatingPeriodDetailTag(String serviceProviderName, String ratingPlanName, String startTime, String ratingPeriodName, String ratingStructureXml) {
        int tariffIndex = ratingStructureXml.indexOf("<TariffStructure");
        int periodIndex = ratingStructureXml.indexOf("</RatingPeriod>");
        String modifiedRatingStructureXml = ratingStructureXml.toString();
        if (periodIndex != -1) {
            modifiedRatingStructureXml = ratingStructureXml.substring(tariffIndex, periodIndex);
        }
        return EreXmlCommandHelper.createStartTagWithAttributes("ServiceProvider", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", serviceProviderName)) + "\n" + EreXmlCommandHelper.createStartTagWithAttributes("RatingPlan", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPlanName)) + "\n" + EreXmlCommandHelper.createStartTagWithAttributes("RatingPeriod", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", ratingPeriodName) + "\n" + XMLUtil.wrapValueOrEmptyStringInAttribute("StartDate", startTime)) + "\n" + EreXmlCommandHelper.createStartTag("RatingRuleTree") + "\n" + modifiedRatingStructureXml + "\n" + EreXmlCommandHelper.createEndTag("RatingRuleTree") + "\n" + EreXmlCommandHelper.createEndTag("RatingPeriod") + "\n" + EreXmlCommandHelper.createEndTag("RatingPlan") + "\n" + EreXmlCommandHelper.createEndTag("ServiceProvider");
    }

    public static String createRatingPeriodSetRequest(String serviceProviderName, String ratingPlanName, String startTime, String ratingPeriodName, String ratingStructureXml, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingPeriod", "Set", sessionId) + "\n" + EreXmlCommandHelper.createRatingPeriodDetailTag(serviceProviderName, ratingPlanName, ratingPeriodName, startTime, ratingStructureXml) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createRatingPeriodTag(RatingPeriodProxy ratingPeriodProxy) {
        return EreXmlCommandHelper._createRatingPeriodTag(ratingPeriodProxy.getServiceName(), ratingPeriodProxy.getServiceProviderName(), ratingPeriodProxy.getRatingPlanName(), ratingPeriodProxy.getName(), ratingPeriodProxy.getRatingPeriodStartTime(), ratingPeriodProxy.getRatingStructureFileRef());
    }

    private static String _createRatingPeriodTag(String serviceName, String providerName, String planName, String periodName, String startTimeAsISO, String fileRefString) {
        return EreXmlCommandHelper.createStartTagWithAttributes("ServiceProvider", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", providerName)) + "\n" + EreXmlCommandHelper.createStartTagWithAttributes("RatingPlan", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", planName), XMLUtil.wrapValueOrEmptyStringInAttribute("Service", serviceName)) + "\n" + EreXmlCommandHelper.createTagWithAttributes("RatingPeriod", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", periodName), XMLUtil.wrapValueOrEmptyStringInAttribute("StartDate", startTimeAsISO), XMLUtil.wrapInAttribute("RatingStructureFile", fileRefString)) + "\n" + EreXmlCommandHelper.createEndTag("RatingPlan") + "\n" + EreXmlCommandHelper.createEndTag("ServiceProvider");
    }

    public static String createRatingPeriodDeleteRequest(RatingPeriodProxy ratingPeriodProxy, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingPeriod", "Delete", sessionId) + "\n" + EreXmlCommandHelper.createRatingPeriodTag(ratingPeriodProxy) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createServiceTag(ServiceListProxy serviceListProxy, SettingsMap newValues, Element definitionXml, Element conditionXml) {
        String strDefXml = DomWriter.elementToString(definitionXml);
        String strCondXml = DomWriter.elementToString(conditionXml);
        return EreXmlCommandHelper.createStartTagWithAttributes("Service", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", newValues.getParameterAsString("Name")), XMLUtil.wrapValueOrEmptyStringInAttribute("DefinitionFile", newValues.getParameterAsString("Service definition file")), XMLUtil.wrapValueOrEmptyStringInAttribute("ConditionLeafClassFile", newValues.getParameterAsString("Service condition file"))) + "\n" + EreXmlCommandHelper.createStartTag("DefinitionFile") + "\n" + strDefXml + "\n" + EreXmlCommandHelper.createEndTag("DefinitionFile") + "\n" + EreXmlCommandHelper.createStartTag("ConditionFile") + "\n" + strCondXml + "\n" + EreXmlCommandHelper.createEndTag("ConditionFile") + "\n" + EreXmlCommandHelper.createEndTag("Service");
    }

    public static String createServiceCreateRequest(ServiceListProxy serviceListProxyNode, SettingsMap newValues, Element newDefinitionXml, Element newConditionXml, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("Service", "Create", sessionId) + "\n" + EreXmlCommandHelper.createServiceTag(serviceListProxyNode, newValues, newDefinitionXml, newConditionXml) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createServiceTag(ServiceProxy serviceProxy) {
        return EreXmlCommandHelper.createTagWithAttributes("Service", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", serviceProxy.getName()), XMLUtil.wrapValueOrEmptyStringInAttribute("DefinitionFile", serviceProxy.getServiceDefinitionFileName()), XMLUtil.wrapValueOrEmptyStringInAttribute("ConditionLeafClassFile", serviceProxy.getServiceConditionFileName()));
    }

    public static String createServiceDeleteRequest(ServiceProxy serviceProxy, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("Service", "Delete", sessionId) + "\n" + EreXmlCommandHelper.createServiceTag(serviceProxy) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createRatingServiceNewNameTag(ServiceProxy serviceProxy, SettingsMap newValues) {
        return EreXmlCommandHelper.createTagWithAttributes("Service", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", serviceProxy.getName()), XMLUtil.wrapValueOrEmptyStringInAttribute("NewName", newValues.getParameter("Name").getValue()), XMLUtil.wrapValueOrEmptyStringInAttribute("DefinitionFile", newValues.getParameter("Service definition file").getValue()), XMLUtil.wrapValueOrEmptyStringInAttribute("ConditionLeafClassFile", newValues.getParameter("Service condition file").getValue()));
    }

    private static String createRatingServiceNameTag(String serviceName, String definitionRef, String conditionRef, String definitionStruct, String conditionStruct, Boolean forced) {
        StringBuffer retResult = new StringBuffer();
        retResult.append(EreXmlCommandHelper.createStartTagWithAttributes("Service", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", serviceName), XMLUtil.wrapValueOrEmptyStringInAttribute("DefinitionFile", definitionRef), XMLUtil.wrapValueOrEmptyStringInAttribute("ConditionLeafClassFile", conditionRef), forced != null ? XMLUtil.wrapValueOrEmptyStringInAttribute("isForced", "" + forced) : null));
        if (definitionStruct != null) {
            retResult.append("\n" + EreXmlCommandHelper.createStartTag("DefinitionFile") + "\n" + definitionStruct + "\n" + EreXmlCommandHelper.createEndTag("DefinitionFile"));
        }
        if (conditionStruct != null) {
            retResult.append("\n" + EreXmlCommandHelper.createStartTag("ConditionFile") + "\n" + conditionStruct + "\n" + EreXmlCommandHelper.createEndTag("ConditionFile"));
        }
        retResult.append("\n" + EreXmlCommandHelper.createEndTag("Service"));
        return retResult.toString();
    }

    public static String createServiceSetRequest(ServiceProxy serviceProperty, SettingsMap newValues, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("Service", "Set", sessionId) + "\n" + EreXmlCommandHelper.createRatingServiceNewNameTag(serviceProperty, newValues) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    public static String createServiceSetRequest(String serviceName, String definitionRef, String conditionRef, String definitionStruct, String conditionStruct, String sessionId, boolean forced) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("Service", "Set", sessionId) + "\n" + EreXmlCommandHelper.createRatingServiceNameTag(serviceName, definitionRef, conditionRef, definitionStruct, conditionStruct, forced) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    public static String createIsAliveRequest() {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("Echo", "Get", "0") + "\n" + EreXmlCommandHelper.createTag("Echo") + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createRatingManagerNewNameTag(RatingManagerProxy managerProxy, SettingsMap newValues) {
        return EreXmlCommandHelper.createTagWithAttributes("RatingManager", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", managerProxy.getRatingManagerName()), XMLUtil.wrapValueOrEmptyStringInAttribute("NewName", newValues.getParameter("Name").getValue()));
    }

    public static String createRatingManagerSetRequest(RatingManagerProxy managerProxy, SettingsMap newValues, String sessionId) {
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingManager", "Set", sessionId) + "\n" + EreXmlCommandHelper.createRatingManagerNewNameTag(managerProxy, newValues) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    public static String createRatingPeriodSetPropertyRequest(String serviceName, String providerName, String planName, String periodName, String startTimeAsISOString, TypedKey[] keys, String[] values, String sessionId) {
        EreXmlCommandHelper.verifyRatingPeriodProperties(serviceName, providerName, planName, periodName, startTimeAsISOString);
        if (keys.length < 1) {
            throw new IllegalArgumentException("Must provide at least one key for property to set");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Must provide a key/value for each property to set");
        }
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingPeriod", "SetProperty", sessionId) + "\n" + EreXmlCommandHelper._createRatingPeriodTag(serviceName, providerName, planName, periodName, startTimeAsISOString, "") + "\n" + EreXmlCommandHelper.createPropertyTag(keys) + "\n" + EreXmlCommandHelper.createNewValuesTag(values) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    public static String createServiceSetPropertyRequest(String serviceName, TypedKey[] keys, String[] values, String sessionId) {
        EreXmlCommandHelper.checkValue("service name", serviceName);
        if (keys.length < 1) {
            throw new IllegalArgumentException("Must provide at least one key for property to set");
        }
        if (keys.length != values.length) {
            throw new IllegalArgumentException("Must provide a key/value for each property to set");
        }
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("Service", "SetProperty", sessionId) + "\n" + EreXmlCommandHelper.createTagWithAttributes("Service", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", serviceName)) + "\n" + EreXmlCommandHelper.createPropertyTag(keys) + "\n" + EreXmlCommandHelper.createNewValuesTag(values) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    public static String createRatingPeriodGetPropertyRequest(String serviceName, String providerName, String planName, String periodName, String startTimeAsISOString, TypedKey[] keys, String sessionId) {
        EreXmlCommandHelper.verifyRatingPeriodProperties(serviceName, providerName, planName, periodName, startTimeAsISOString);
        if (keys.length < 1) {
            throw new IllegalArgumentException("Must provide at least one key for property to fetch");
        }
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("RatingPeriod", "GetProperty", sessionId) + "\n" + EreXmlCommandHelper._createRatingPeriodTag(serviceName, providerName, planName, periodName, startTimeAsISOString, "") + "\n" + EreXmlCommandHelper.createPropertyTag(keys) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    public static String createServiceGetPropertyRequest(String serviceName, TypedKey[] keys, String sessionId) {
        EreXmlCommandHelper.checkValue("service name", serviceName);
        if (keys.length < 1) {
            throw new IllegalArgumentException("Must provide at least one key for property to fetch");
        }
        return EreXmlCommandHelper.createProcessInstructionTag() + "\n" + EreXmlCommandHelper.createRequestStartTag("Service", "GetProperty", sessionId) + "\n" + EreXmlCommandHelper.createTagWithAttributes("Service", XMLUtil.wrapValueOrEmptyStringInAttribute("Name", serviceName)) + "\n" + EreXmlCommandHelper.createPropertyTag(keys) + "\n" + EreXmlCommandHelper.createRequestEndTag();
    }

    private static String createPropertyTag(TypedKey[] keys) {
        String keyString = StringUtil.buildSemiColonSeparatedString(keys);
        return "<Property " + XMLUtil.wrapInAttribute("key", keyString) + " />";
    }

    private static String createNewValuesTag(String[] values) {
        String value = StringUtil.buildSemiColonSeparatedString(values);
        return "<NewValues " + XMLUtil.wrapInAttribute("value", value) + " />";
    }

    private static void verifyRatingPeriodProperties(String serviceName, String providerName, String planName, String periodName, String startTimeAsISOString) {
        EreXmlCommandHelper.checkValue("service name", serviceName);
        EreXmlCommandHelper.checkValue("service provider name", providerName);
        EreXmlCommandHelper.checkValue("rating plan name", planName);
        EreXmlCommandHelper.checkValue("rating period name", periodName);
        EreXmlCommandHelper.checkValue("start time", startTimeAsISOString);
        if (DataType.DATE.parseValue(startTimeAsISOString) == null) {
            throw new IllegalArgumentException("Faulty format for iso string");
        }
    }

    private static void checkValue(String key, String value) {
        if (value == null || value.length() == 0) {
            throw new IllegalArgumentException("No value defined for mandatory " + key + ".");
        }
    }
}

