/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import com.ericsson.charging.common.documents.NumberSeriesDocument;
import com.ericsson.ere.annotations.jcip.Immutable;
import com.ericsson.ere.datatype.ValueResolver;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.selectiontree.HierarchicalFieldFilter;
import com.ericsson.ere.selectiontree.util.AvailableFieldListBuilder;
import com.ericsson.ere.selectiontree.util.FieldOrientedPluginUtil;
import com.ericsson.ere.selectiontree.util.MultipleValueFieldCompositeObject;
import com.ericsson.ere.selectiontree.util.ValueFieldCompositeObject;
import com.ericsson.ere.util.CollectionUtils;
import com.ericsson.ere.util.Location;
import ericsson.ere.datatype.DataType;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.FieldDefinition;
import ericsson.ere.defs.FieldDefinitionHelper;
import ericsson.ere.defs.FieldStructure;
import ericsson.ere.gui.util.VariableFactory;
import ericsson.ere.interfaces.FieldHierarchyNode;
import ericsson.vareditor.documents.AllIntegersDocument;
import ericsson.vareditor.documents.RegularExpressionMatcherDocument;
import ericsson.vareditor.variable.CompositeValueVariable;
import ericsson.vareditor.variable.InfoVariable;
import ericsson.vareditor.variable.ValueFieldVariable;
import ericsson.vareditor.variable.Variable;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;

@Immutable
public final class IndexVariableFactory
extends VariableFactory {
    private final ClassRepository myRepository;
    private final boolean myAllowMultipleInput;
    private final boolean myDateTimeInteroperability;
    private final boolean myHierarchicalFieldSupport;
    private final boolean myUseFilterableFieldVariable;
    private static final String NUMERIC_RANGE_REG_EXP = "((\\d+,?)|(\\d+-\\d+,?)|\\s)+";
    private static final char[] NUMERIC_RANGE_ALLOWED_CHARS = new char[]{' ', '-', ',', '\u0000'};
    private static final String ALPHANUMERIC_REG_EXP = "[a-zA-Z0-9_\\-]+";

    private IndexVariableFactory(ClassRepository repository, boolean allowMultipleInput, boolean dateTimeInterop, boolean hierarchical, boolean useFilterableFieldVariable) {
        this.myRepository = repository;
        this.myAllowMultipleInput = allowMultipleInput;
        this.myDateTimeInteroperability = dateTimeInterop;
        this.myHierarchicalFieldSupport = hierarchical;
        this.myUseFilterableFieldVariable = useFilterableFieldVariable;
    }

    public Variable createIndexVariableForField(String label, String key, FieldHierarchyNode field, ValueFieldCompositeObject initialValue) {
        this.checkForNullParameter(label);
        Variable indexVariable = null;
        if (field != null) {
            FieldDefinition actualField = (FieldDefinition)(field.isLeaf() ? field : null);
            if (!field.isLeaf() && field.getComplexType() != FieldHierarchyNode.ComplexType.NONE && field.getChildren().size() > 0) {
                actualField = (FieldDefinition)field.getChildren().get(0);
            }
            if (this.fieldRequiresIndexVariable(actualField)) {
                if (this.fieldHasKeyFields(actualField)) {
                    indexVariable = this.createVariableForFieldInMapGroup(label, key, actualField, initialValue);
                } else {
                    indexVariable = this.createVariableForNonMapGroupField(label, actualField, initialValue);
                    this.updateVariableWithKeyIfNotNull(key, indexVariable);
                }
            }
        }
        return indexVariable;
    }

    private boolean fieldRequiresIndexVariable(FieldDefinition field) {
        FieldStructure parent = field.getParent();
        boolean isIndexUser = field.getComplexType() == FieldHierarchyNode.ComplexType.ARRAY || field.getComplexType() == FieldHierarchyNode.ComplexType.MAP;
        boolean isParentIndexUser = parent != null && (parent.getComplexType() == FieldHierarchyNode.ComplexType.ARRAY || parent.getComplexType() == FieldHierarchyNode.ComplexType.MAP);
        boolean requires = isIndexUser || isParentIndexUser;
        return requires;
    }

    private void updateVariableWithKeyIfNotNull(String key, Variable variable) {
        if (variable != null && key != null) {
            variable.setKey(key);
        }
    }

    private void checkForNullParameter(Object parameter) {
        if (parameter == null) {
            throw new IllegalArgumentException("Parameter must not be null");
        }
    }

    private boolean fieldHasKeyFields(FieldHierarchyNode field) {
        boolean leafHasKeys = field.isLeaf() && ((FieldDefinition)field).getKeyFields().length != 0;
        boolean hierarchicalFieldHasKeys = !field.isLeaf() && ((FieldStructure)field).getKeyFields().size() > 0;
        FieldStructure parent = field.getParent();
        boolean parentOfLeafHasKeys = parent != null && this.fieldHasKeyFields(parent);
        return leafHasKeys || hierarchicalFieldHasKeys || parentOfLeafHasKeys;
    }

    private boolean fieldHasComplexKey(FieldDefinition field) {
        FieldStructure parent;
        boolean hasComplexKey = false;
        hasComplexKey = field.getComplexType() != FieldHierarchyNode.ComplexType.NONE ? field.getKeyFields().length > 1 : (parent = field.getParent()) != null && parent.getKeyFields().size() > 1;
        return hasComplexKey;
    }

    private Variable createVariableForNonMapGroupField(String label, FieldDefinition targetField, ValueFieldCompositeObject initialValue) {
        ValueFieldCompositeObject object = initialValue;
        if (object == null) {
            object = new ValueFieldCompositeObject(ValueFieldCompositeObject.Mode.Value, "0");
        }
        VariableFactory.IndexType indexType = IndexVariableFactory.extractIndexTypeFromField(targetField, this.myAllowMultipleInput);
        String[] availableFields = this.extractFieldNameListForIndexType(indexType, targetField, this.myRepository);
        Document doc = IndexVariableFactory.createInputDocumentForField(targetField, indexType);
        return this.myUseFilterableFieldVariable ? new ValueFieldVariable(label, object, this.createFieldDefinitionMap(availableFields), doc, null) : new ValueFieldVariable(label, object, availableFields, doc);
    }

    private Map<String, FieldDefinition> createFieldDefinitionMap(String[] availableFields) {
        return FieldDefinitionHelper.createNameToFieldMap(this.myRepository, Arrays.asList(availableFields));
    }

    private Variable createVariableForFieldInMapGroup(String label, String key, FieldDefinition field, ValueFieldCompositeObject initialValue) {
        Variable indexVariable = null;
        if (this.fieldHasComplexKey(field)) {
            indexVariable = this.createVariableForMapGroupFieldWithComplexKey(label, key, field, initialValue);
            this.updateVariableWithKeyIfNotNull(key, indexVariable);
        } else {
            indexVariable = this.createVariableForMapGroupFieldWithSingleKey(label, field, initialValue);
            this.updateVariableWithKeyIfNotNull(label, indexVariable);
        }
        return indexVariable;
    }

    private Variable createVariableForMapGroupFieldWithSingleKey(String label, FieldDefinition targetField, ValueFieldCompositeObject initialValue) {
        ValueFieldVariable valueFieldVar;
        List<FieldDefinition> keyFields = FieldOrientedPluginUtil.extractKeyFields(targetField, this.myRepository);
        FieldDefinition keyField = keyFields.get(0);
        ValueResolver resolver = this.createValueResolverForField(keyField, this.myRepository);
        ValueFieldCompositeObject valueObject = this.createMapGroupSingleKeyValueObject(keyField, resolver, initialValue);
        CustomValueType valueType = new CustomValueType(targetField, keyField, valueObject, resolver, this.myRepository);
        if (this.myUseFilterableFieldVariable) {
            AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myRepository).withFilter(new CompatibleFieldFilter(keyField.getTypedDataType()));
            if (this.myHierarchicalFieldSupport) {
                builder.withHierarchicalFields();
            }
            valueFieldVar = ValueFieldVariable.createForMultipleTypes(keyField.getCanonicalName(), valueObject, new ValueFieldVariable.ValueType[]{valueType}, builder);
        } else {
            String[] availableFields = this.extractFieldNameListForDataType(keyField.getTypedDataType());
            valueFieldVar = ValueFieldVariable.createForMultipleTypes(keyField.getCanonicalName(), valueObject, availableFields, new ValueFieldVariable.ValueType[]{valueType});
        }
        return valueFieldVar;
    }

    private Variable createVariableForMapGroupFieldWithComplexKey(String label, String key, FieldDefinition field, ValueFieldCompositeObject initialValue) {
        List<FieldDefinition> keyFields = FieldOrientedPluginUtil.extractKeyFields(field, this.myRepository);
        CompositeValueVariable.CompositeValueVariableBuilder builder = CompositeValueVariable.buildVariable().withLabel(label).withKey(key).withKeyFields(keyFields).withIndexVariableFactory(this);
        if (initialValue != null) {
            if (initialValue instanceof MultipleValueFieldCompositeObject) {
                builder.withInitialValue((List)initialValue.getValueAsObject());
            } else {
                throw new IllegalArgumentException("Field with complex key requires a complex value");
            }
        }
        return builder.andClassRepository(this.myRepository);
    }

    String[] extractFieldNameListForIndexType(VariableFactory.IndexType indexType, FieldDefinition targetField, ClassRepository repository) {
        String[] keyFields;
        switch (indexType) {
            case Numeric_Range: 
            case Pos_Integer_Numeric: {
                keyFields = this.extractFieldNameListForDataType(DataType.INTEGER);
                break;
            }
            case Alphanumeric: {
                keyFields = this.extractFieldNameListForDataType(null);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled field restriction!");
            }
        }
        return IndexVariableFactory.sortAndFilterFieldList(keyFields, repository);
    }

    String[] extractFieldNameListForDataType(DataType keyFieldDataType) {
        AvailableFieldListBuilder builder = AvailableFieldListBuilder.createAvailableFieldListBuilder(this.myRepository).withFilter(new CompatibleFieldFilter(keyFieldDataType));
        if (this.myHierarchicalFieldSupport) {
            builder.withHierarchicalFields();
        }
        String[] keyFields = builder.buildFieldNameList().toArray(new String[0]);
        return keyFields;
    }

    private static String[] sortAndFilterFieldList(String[] keyFields, ClassRepository repository) {
        List<String> sortedList = Arrays.asList(keyFields);
        Collections.sort(sortedList);
        Collection<String> filteredList = CollectionUtils.filter(sortedList, new VariableFactory.ExcludeNonmappableFieldPredicate(repository));
        return filteredList.toArray(new String[filteredList.size()]);
    }

    private ValueFieldCompositeObject createMapGroupSingleKeyValueObject(FieldDefinition keyField, ValueResolver resolver, ValueFieldCompositeObject initialValue) {
        ValueFieldCompositeObject valueObject = initialValue;
        DataType keyFieldDataType = keyField.getTypedDataType();
        if (valueObject == null) {
            valueObject = FieldOrientedPluginUtil.createDefaultValueForField(keyField);
        } else if (valueObject.getMode() == ValueFieldCompositeObject.Mode.Value && valueObject.getValueDataType() != keyFieldDataType && !keyField.hasValueClassFactory()) {
            if (valueObject.getValueDataType() == null && keyFieldDataType.parseValue(valueObject.getFieldOrValueAsString()) != null) {
                valueObject = ValueFieldCompositeObject.createForValue(valueObject.getFieldOrValueAsString(), keyFieldDataType);
            } else {
                String defaultString = resolver.makeValueString(resolver.createDefaultInstance());
                valueObject = ValueFieldCompositeObject.createForValue(defaultString, keyFieldDataType);
            }
        }
        return valueObject;
    }

    private ValueResolver createValueResolverForField(FieldDefinition field, ClassRepository repository) {
        return DataType.createTypeIndependentContextBasedValueResolver().withFieldDefinition(field).withClassRepository(repository).finish();
    }

    private static Document createInputDocumentForField(FieldDefinition field, VariableFactory.IndexType indexType) {
        PlainDocument document;
        switch (indexType) {
            case Numeric_Range: {
                document = new NumberSeriesDocument(NUMERIC_RANGE_REG_EXP, NUMERIC_RANGE_ALLOWED_CHARS);
                break;
            }
            case Pos_Integer_Numeric: {
                document = new AllIntegersDocument(new BigInteger("0"), new BigInteger(Integer.toString(Integer.MAX_VALUE)), false);
                break;
            }
            case Alphanumeric: {
                document = new RegularExpressionMatcherDocument(ALPHANUMERIC_REG_EXP, false);
                break;
            }
            default: {
                throw new AssertionError((Object)"Unhandled field restriction!");
            }
        }
        return document;
    }

    private static VariableFactory.IndexType extractIndexTypeFromField(FieldDefinition field, boolean allowMultipleInput) {
        VariableFactory.IndexType indexType = null;
        FieldStructure struct = field.getParent();
        if (struct != null && struct.getComplexType() == FieldHierarchyNode.ComplexType.ARRAY) {
            indexType = VariableFactory.IndexType.Pos_Integer_Numeric;
        } else if (field.isArray()) {
            indexType = allowMultipleInput ? VariableFactory.IndexType.Numeric_Range : VariableFactory.IndexType.Pos_Integer_Numeric;
        } else if (field.isMap()) {
            indexType = VariableFactory.IndexType.Alphanumeric;
        }
        return indexType;
    }

    public static IndexVariableFactoryBuilder buildFactory() {
        return new IndexVariableFactoryBuilder();
    }

    public static class CustomValueType
    extends ValueFieldVariable.ValueType {
        private final FieldDefinition myField;
        private final ValueFieldCompositeObject myValueObject;
        private final FieldDefinition myKeyField;
        private final ValueResolver myResolver;
        private final ClassRepository myClassRepository;

        private CustomValueType(FieldDefinition field, FieldDefinition keyField, ValueFieldCompositeObject valueObject, ValueResolver resolver, ClassRepository classRepository) {
            super(null, keyField.getTypedDataType());
            this.myField = field;
            this.myKeyField = keyField;
            this.myValueObject = valueObject;
            this.myResolver = resolver;
            this.myClassRepository = classRepository;
        }

        @Override
        public boolean hasValueClassFactory() {
            return this.myKeyField.hasValueClassFactory();
        }

        @Override
        public Variable createVariable(String label, String value) {
            String useValue = this.myValueObject.getMode() == ValueFieldCompositeObject.Mode.Field ? FieldOrientedPluginUtil.createDefaultValueFieldCompositeObjectForFieldKey(this.myField, this.myClassRepository).getFieldOrValueAsString() : (value != null ? value : this.myResolver.makeValueString(this.myResolver.createDefaultInstance()));
            Variable var = null;
            try {
                var = VariableFactory.createInputVariable(label, null, this.myKeyField, this.myClassRepository, useValue, Location.SELECTION_TREE);
            }
            catch (Exception e) {
                var = new InfoVariable("Error", "Failed to create variable.");
                ExceptionUtil.handleException(e, "ratingperiod", 1, "Failed to create variable", false);
            }
            return var;
        }
    }

    public static class IndexVariableFactoryBuilder {
        private ClassRepository myOwnRepository = null;
        private boolean myOwnAllowMultiInput = false;
        private boolean myOwnInterop = false;
        private boolean myHierarchicalSupport = false;
        private boolean myUseFilterableFieldVariable = false;

        public IndexVariableFactoryBuilder withMultipleInputAllowed(boolean allowMultiInput) {
            this.myOwnAllowMultiInput = allowMultiInput;
            return this;
        }

        public IndexVariableFactoryBuilder withHierarchicalFieldSupport(boolean support) {
            this.myHierarchicalSupport = support;
            return this;
        }

        public IndexVariableFactoryBuilder withDateTimeInteroperability(boolean interop) {
            this.myOwnInterop = interop;
            return this;
        }

        public IndexVariableFactory withRepository(ClassRepository repository) {
            return this.andRepository(repository);
        }

        public IndexVariableFactory andRepository(ClassRepository repository) {
            this.myOwnRepository = repository;
            return this.create();
        }

        public IndexVariableFactoryBuilder withFilterableFieldVariable(boolean useFilterableFieldVariable) {
            this.myUseFilterableFieldVariable = useFilterableFieldVariable;
            return this;
        }

        private IndexVariableFactory create() {
            if (this.myOwnRepository == null) {
                throw new IllegalStateException("Cannot create factory without a class repository");
            }
            return new IndexVariableFactory(this.myOwnRepository, this.myOwnAllowMultiInput, this.myOwnInterop, this.myHierarchicalSupport, this.myUseFilterableFieldVariable);
        }
    }

    private class CompatibleFieldFilter
    implements HierarchicalFieldFilter {
        private DataType myType;

        public CompatibleFieldFilter(DataType type) {
            this.myType = type;
        }

        @Override
        public boolean isAllowed(FieldHierarchyNode field) {
            boolean parentIsComplex;
            boolean allowed = true;
            FieldStructure parent = field.getParent();
            boolean fieldIsComplex = field.getComplexType() != FieldHierarchyNode.ComplexType.NONE;
            boolean bl = parentIsComplex = parent != null && parent.getComplexType() != FieldHierarchyNode.ComplexType.NONE;
            if (!field.isLeaf()) {
                allowed = false;
            } else if (fieldIsComplex || parentIsComplex) {
                allowed = false;
            } else {
                FieldDefinition def = (FieldDefinition)field;
                if (!def.isAutoConditionMapAllowed()) {
                    allowed = false;
                } else if (!this.typeIsCompatible(def.getTypedDataType())) {
                    allowed = false;
                }
            }
            return allowed;
        }

        private boolean typeIsCompatible(DataType otherType) {
            boolean compatible = false;
            if (this.myType == otherType || this.myType == null) {
                compatible = true;
            } else if (this.myType.isIntegerNumeric()) {
                compatible = otherType.isIntegerNumeric();
            } else if (IndexVariableFactory.this.myDateTimeInteroperability && (this.myType == DataType.DATE || this.myType == DataType.TIME)) {
                compatible = otherType == DataType.DATE || otherType == DataType.TIME;
            }
            return compatible;
        }
    }
}

