/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.util;

import ericsson.ere.gui.GuiServiceCenter;
import java.awt.Component;
import java.awt.EventQueue;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;

public class FrameOpener {
    private JInternalFrame myFrame;

    public FrameOpener(JInternalFrame frame) {
        this.myFrame = frame;
    }

    public void open() {
        if (EventQueue.isDispatchThread()) {
            this.openImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FrameOpener.this.openImpl();
                }
            });
        }
    }

    private void openImpl() {
        this.myFrame.setVisible(true);
        GuiServiceCenter.getInstance().getDesktopPane().add((Component)this.myFrame, "Center");
        GuiServiceCenter.setSelectedNoVeto(this.myFrame, true);
    }

    public void activate() {
        if (EventQueue.isDispatchThread()) {
            this.activateImpl();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FrameOpener.this.activateImpl();
                }
            });
        }
    }

    private void activateImpl() {
        if (this.myFrame.isIcon()) {
            GuiServiceCenter.setIconNoVeto(this.myFrame, false);
        }
        GuiServiceCenter.setSelectedNoVeto(this.myFrame, true);
    }
}

