/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import com.ericsson.ere.exception.ServiceException;
import com.ericsson.ere.gui.util.ExceptionUtil;
import com.ericsson.ere.interfaces.NamedClassProfile;
import com.ericsson.ere.interfaces.ProductTagClassProfile;
import com.ericsson.ere.selectiontree.mdu.filter.MultiDataUpdateFilterFactory;
import com.ericsson.ere.selectiontree.mdu.filter.SelectionTreeElementFilter;
import com.ericsson.ere.selectiontree.statements.AbstractNodeStatementProfile;
import com.ericsson.ere.selectiontree.util.PluginConfigurationHelper;
import com.ericsson.ere.util.HTMLUtil;
import ericsson.ere.defs.ClassRepository;
import ericsson.ere.defs.EreClassLoader;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.integration.settingsmap.Parameter;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.interfaces.ClassProfile;
import ericsson.ere.interfaces.ConditionProfile;
import ericsson.ere.interfaces.ModifierProfile;
import ericsson.ere.structure.AbstractTariffStructureProfile;
import ericsson.ere.xml.XMLUtil;
import ericsson.vareditor.documents.StringDocument;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.w3c.dom.Element;

public final class TSElementProductTagSupport {
    private static final String PRODUCT_TAG_LABEL = "Tag";
    private static final String ATTR_TAG = "productTag";
    private static final Map<Integer, Boolean> myHasConfigClassCache = new HashMap<Integer, Boolean>();
    private TSElement myElement;
    private ClassRepository myRepository;
    private boolean myIsEnabled;

    public TSElementProductTagSupport(TSElement element, ClassRepository classRep, TariffDAGModel model) {
        this.myElement = element;
        this.myRepository = classRep;
        this.myIsEnabled = this.isEnabled(element, model);
    }

    private boolean isEnabled(TSElement element, TariffDAGModel model) {
        SettingsMap settings = model.getSettings();
        boolean enabled = false;
        if (!element.isLink() && settings != null) {
            Parameter param = settings.getParameter("multi-data-update");
            enabled = param != null && Boolean.parseBoolean(param.getValue());
        }
        return enabled;
    }

    public boolean isEnabled() {
        return this.myIsEnabled;
    }

    public String extractProductTagFromXML() {
        String tag = null;
        Element exml = (Element)this.myElement.state().getXMLConfig();
        if (exml != null && exml.hasAttribute(ATTR_TAG)) {
            tag = exml.getAttribute(ATTR_TAG);
        }
        return tag;
    }

    public static void printProductTagAsXMLAttribute(PrintWriter out, List<Variable> vars) {
        Variable var = TSElementProductTagSupport.getProductTagVariable(vars);
        if (var != null) {
            String tag = var.getValueString().trim();
            out.print(XMLUtil.wrapInAttribute(ATTR_TAG, tag));
        }
    }

    public static boolean hasConfigurationClass(ClassRepository repository, ClassProfile profile) {
        String name = TSElementProductTagSupport.getProfileName(profile);
        boolean ret = false;
        if (name != null) {
            int nodeType = TSElementProductTagSupport.deduceNodeType(profile);
            if (nodeType < 0) {
                throw new IllegalArgumentException("Profile type not recognized: " + profile.getClass().getName());
            }
            int cacheHash = 31 * nodeType + name.hashCode();
            Boolean result = myHasConfigClassCache.get(cacheHash);
            if (result != null) {
                ret = result;
            } else {
                String trafficClassName;
                switch (nodeType) {
                    case 1: {
                        trafficClassName = repository.getNodeTypeClassName(name);
                        break;
                    }
                    case 3: {
                        trafficClassName = repository.getModifierClassName(name);
                        break;
                    }
                    case 2: {
                        trafficClassName = repository.getBaseConditionClass(name);
                        if (trafficClassName != null) break;
                        trafficClassName = repository.getConditionClassName(name);
                        break;
                    }
                    case 0: {
                        trafficClassName = repository.getTariffStructureClassName(name);
                        break;
                    }
                    default: {
                        throw new AssertionError((Object)("Unhandled node type: " + nodeType));
                    }
                }
                try {
                    Class<?> trafficClass = EreClassLoader.getClass(trafficClassName);
                    ret = PluginConfigurationHelper.hasValidConfigurationClass(trafficClass);
                }
                catch (ClassNotFoundException ex) {
                    ExceptionUtil.handleException(ex, "ratingRuleFrame", 1, "Failed to load plugin traffic class.", false);
                }
                myHasConfigClassCache.put(cacheHash, ret);
            }
        }
        return ret;
    }

    public boolean updateProductTagVariablePresence(List<Variable> variables) {
        Variable var;
        SelectionTreeElementFilter filter;
        ClassProfile profile = this.myElement.getClassProfile();
        if (!(profile instanceof ProductTagClassProfile)) {
            return false;
        }
        boolean isEnabledForElement = this.isEnabled();
        if (isEnabledForElement && (filter = this.createElementFilter()) != null) {
            isEnabledForElement = filter.test(this.myElement);
        }
        String currentTag = (var = TSElementProductTagSupport.getProductTagVariable(variables)) != null ? var.getValueString() : null;
        boolean tagIsSupported = ((ProductTagClassProfile)((Object)profile)).supportsProductTag(this.myRepository, variables);
        boolean didRemove = variables.remove(var);
        boolean didAdd = false;
        if (tagIsSupported) {
            String tag = "";
            boolean hasDefinedTag = false;
            if (this.myElement.state().isConfiguredByXML()) {
                String xtag = this.extractProductTagFromXML();
                hasDefinedTag = xtag != null;
                String string = tag = hasDefinedTag ? xtag : "";
            }
            if (hasDefinedTag || isEnabledForElement) {
                StringVariable tagVar = new StringVariable(PRODUCT_TAG_LABEL, tag, new StringDocument(100L));
                ((Variable)tagVar).setKey("__PROD_TAG");
                if (currentTag != null) {
                    ((Variable)tagVar).setValue(currentTag);
                }
                if (!VarListUtil.insertVariableAfterKey(variables, "Id", tagVar)) {
                    variables.add(0, tagVar);
                }
                didAdd = true;
                ((Variable)tagVar).setAllowEdit(isEnabledForElement);
            }
        }
        return didRemove || didAdd;
    }

    private SelectionTreeElementFilter createElementFilter() {
        MultiDataUpdateFilterFactory filterFactory;
        try {
            filterFactory = this.myRepository.getMDUFilterFactory();
        }
        catch (ServiceException ex) {
            filterFactory = null;
        }
        SelectionTreeElementFilter filter = null;
        if (filterFactory != null) {
            filter = filterFactory.createElementFilter();
        }
        return filter;
    }

    private static int deduceNodeType(ClassProfile profile) {
        int type = -1;
        if (profile instanceof ConditionProfile) {
            type = 2;
        } else if (profile instanceof ModifierProfile) {
            type = 3;
        } else if (profile instanceof AbstractNodeStatementProfile) {
            type = 1;
        } else if (profile instanceof AbstractTariffStructureProfile) {
            type = 0;
        }
        return type;
    }

    public static Variable getProductTagVariable(List<Variable> variables) {
        return VarListUtil.getVariableForKey(variables, "__PROD_TAG");
    }

    private static String getProfileName(ClassProfile profile) {
        String name = null;
        if (profile instanceof NamedClassProfile) {
            name = ((NamedClassProfile)((Object)profile)).getName();
        }
        return name;
    }

    public String insertProductTagInAdditionalInfo(String addInfo, String productTag) {
        int indexOfHtml = addInfo.indexOf("</html>");
        String tagText = "<p><i>Tag</i>: " + HTMLUtil.escape(productTag);
        String newInfo = indexOfHtml >= 0 ? addInfo.substring(0, indexOfHtml) + tagText + "</html>" : addInfo + tagText;
        return newInfo;
    }
}

