/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.ratingrules.nodes.TSElement;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.util.StringUtil;

public class ProductTagPredicate
implements NodePredicate {
    static final long serialVersionUID = 1L;
    private final String myMatch;
    private final OPERATOR myOperator;

    public ProductTagPredicate(String match, OPERATOR operation) {
        this.myMatch = match;
        this.myOperator = operation;
    }

    @Override
    public boolean test(TariffDAGNode node) {
        TSElement currentTSElement;
        String tag;
        if (node instanceof TSElement && (tag = (currentTSElement = (TSElement)node).getProductTag()) != null) {
            return this.evaluate(tag);
        }
        return false;
    }

    private boolean evaluate(String str) {
        boolean rc = false;
        if (!StringUtil.isEmptyString(this.myMatch)) {
            switch (this.myOperator) {
                case EQUALS: {
                    rc = str.equalsIgnoreCase(this.myMatch);
                    break;
                }
                case CONTAINS: {
                    int len = str.length();
                    for (int i = 0; i < len && !(rc = str.regionMatches(true, i, this.myMatch, 0, this.myMatch.length())); ++i) {
                    }
                    break;
                }
                case STARTS_WITH: {
                    rc = str.regionMatches(true, 0, this.myMatch, 0, this.myMatch.length());
                    break;
                }
                case ENDS_WITH: {
                    int startIndex = str.length() - this.myMatch.length();
                    rc = str.regionMatches(true, startIndex, this.myMatch, 0, this.myMatch.length());
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown operation in " + this.getClass().toString() + " :" + (Object)((Object)this.myOperator));
                }
            }
        }
        return rc;
    }

    public String getProductTag() {
        return this.myMatch;
    }

    public OPERATOR getOperator() {
        return this.myOperator;
    }

    public static enum OPERATOR {
        EQUALS(RmaDefs.getStringResource("ratingrules.find.ProductTag.operators.equals")),
        CONTAINS(RmaDefs.getStringResource("ratingrules.find.ProductTag.operators.contains")),
        STARTS_WITH(RmaDefs.getStringResource("ratingrules.find.ProductTag.operators.startsWith")),
        ENDS_WITH(RmaDefs.getStringResource("ratingrules.find.ProductTag.operators.endsWith"));

        private String myName;

        private OPERATOR(String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }
}

