/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.nodes;

import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGModel;
import ericsson.ere.interfaces.TariffNodeLink;
import ericsson.ere.interfaces.TariffStructureNode;
import ericsson.ere.interfaces.TariffStructureVisitor;
import java.util.ArrayList;
import java.util.List;

public class DefaultLinkIdUpdater
implements TariffStructureVisitor {
    private TariffDAGModel myModel = null;
    private List<TariffStructureNode> myContext = new ArrayList<TariffStructureNode>(200);

    public DefaultLinkIdUpdater(TariffDAGModel model) {
        this.myModel = model;
    }

    private void enterLink(TariffStructureNode n) throws Exception {
        int pos;
        String tgt;
        String slashReversed;
        String id = n.getNodeId();
        if (id.equals(slashReversed = (tgt = ((TariffNodeLink)((Object)n)).getLinkPath()).replace('/', '\\')) && (pos = id.lastIndexOf(47)) > 0 && pos < id.length() - 1) {
            String lastNode = id.substring(pos + 1);
            String newId = "-> " + lastNode;
            if (this.myContext.size() > 1) {
                TariffStructureNode parent = this.myContext.get(this.myContext.size() - 2);
                String candidateId = newId;
                boolean foundCandidate = true;
                int counter = 0;
                while (foundCandidate) {
                    foundCandidate = false;
                    int len = parent.getChildCount();
                    for (int i = 0; i < len; ++i) {
                        TariffStructureNode c = (TariffStructureNode)parent.getChildAt(i);
                        if (!candidateId.equals(c.getNodeId())) continue;
                        foundCandidate = true;
                    }
                    if (!foundCandidate) continue;
                    candidateId = newId + " (" + ++counter + ")";
                }
                newId = candidateId;
            }
            if (n instanceof TSLink) {
                ((TSLink)n).setNodeId(newId);
                this.myModel.nodeChanged(n);
            } else {
                System.err.println("DefaultLinkIdUpdater can only update TSLink objects!");
            }
        }
    }

    private void enterElement(TariffStructureNode n) throws Exception {
        this.myContext.add(n);
    }

    private void leaveElement(TariffStructureNode n) throws Exception {
        TariffStructureNode removed = this.myContext.remove(this.myContext.size() - 1);
        if (removed != n) {
            String msg = "DefaultLinkIdUpdater.leaveElement: Code fault, expected node " + n + " but got last element " + removed;
            throw new IllegalArgumentException(msg);
        }
    }

    @Override
    public void enterTariffStructure(TariffStructureNode n) throws Exception {
        this.enterElement(n);
        if (n.isLink()) {
            this.enterLink(n);
        }
    }

    @Override
    public void enterNode(TariffStructureNode n) throws Exception {
        this.enterElement(n);
        if (n.isLink()) {
            this.enterLink(n);
        }
    }

    @Override
    public void enterCondition(TariffStructureNode n) throws Exception {
        this.enterElement(n);
        if (n.isLink()) {
            this.enterLink(n);
        }
    }

    @Override
    public void enterModifier(TariffStructureNode n) throws Exception {
        this.enterElement(n);
        if (n.isLink()) {
            this.enterLink(n);
        }
    }

    @Override
    public void leaveTariffStructure(TariffStructureNode n) throws Exception {
        this.leaveElement(n);
    }

    @Override
    public void leaveNode(TariffStructureNode n) throws Exception {
        this.leaveElement(n);
    }

    @Override
    public void leaveCondition(TariffStructureNode n) throws Exception {
        this.leaveElement(n);
    }

    @Override
    public void leaveModifier(TariffStructureNode n) throws Exception {
        this.leaveElement(n);
    }
}

