/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.bookmarks;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.bookmarks.BookmarkItem;
import ericsson.ere.gui.util.DialogFactory;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class GoToBookmarkAction
extends AbstractAction {
    private JTable myTable = null;
    private JTree myTree = null;
    private boolean myShowMessage = true;

    public GoToBookmarkAction(JTable table, JTree tree) {
        super("Go to bookmark");
        this.myTable = table;
        this.myTree = tree;
        ImageIcon icon = RmaDefs.getImageIcon("bookmark_smaller.png");
        this.putValue("SmallIcon", icon);
        this.putValue("ShortDescription", "Go to selected bookmark");
    }

    public GoToBookmarkAction(JTable table, JTree tree, boolean showMessage) {
        this(table, tree);
        this.myShowMessage = showMessage;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int selectedRow = this.myTable.getSelectedRow();
        if (selectedRow != -1) {
            BookmarkItem item = (BookmarkItem)this.myTable.getValueAt(selectedRow, 0);
            boolean initOk = true;
            if (!item.isInitialized()) {
                initOk = item.initialize(this.myTree);
            } else {
                item.revalidatePathInTree(this.myTree);
            }
            if (initOk && item.isPathValidInTree(this.myTree)) {
                TreePath path = item.getPath();
                this.myTree.setSelectionPath(path);
                this.myTree.scrollPathToVisible(path);
                this.myTree.requestFocus();
            } else if (this.myShowMessage) {
                DialogFactory.getErrorDialog("Bookmark failed", "The bookmark could not be resolved as a unique path in the selection tree.");
            }
        }
    }
}

