/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules.bookmarks;

import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import ericsson.ere.interfaces.DAGUtil;
import ericsson.ere.interfaces.TariffStructureNode;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class BookmarkItem {
    private String myName = "";
    private TreePath myPath = null;
    private String myInitialPathString = null;
    private boolean myIsInitialized = false;
    private boolean myIsValid = false;
    private boolean myIsEdited = false;

    public BookmarkItem(String name, String initialPathString) {
        if (name == null || initialPathString == null) {
            throw new IllegalArgumentException("Argument(s) must not be null");
        }
        this.myName = name;
        this.myInitialPathString = initialPathString;
    }

    public BookmarkItem(String name, TreePath path) {
        if (name == null || path == null) {
            throw new IllegalArgumentException("Argument(s) must not be null");
        }
        this.myName = name;
        this.myPath = path;
        this.myIsInitialized = true;
        this.myIsValid = true;
    }

    public boolean initialize(JTree tree) {
        if (tree == null) {
            throw new IllegalArgumentException("Tree must not be null");
        }
        if (this.myPath != null) {
            throw new IllegalStateException("Bookmark is already initialized.");
        }
        TreeModel model = tree.getModel();
        TariffDAGNode root = (TariffDAGNode)model.getRoot();
        TreePath path = DAGUtil.getStringToUniqueTreePath(this.myInitialPathString, root);
        if (path != null) {
            this.myPath = path;
            this.myIsInitialized = true;
            this.myIsValid = true;
        }
        return this.myIsInitialized;
    }

    public boolean isInitialized() {
        return this.myIsInitialized;
    }

    public boolean isValid() {
        return this.myIsValid;
    }

    public String getName() {
        return this.myName;
    }

    public void setName(String name) {
        this.myName = name;
        this.myIsEdited = true;
    }

    public TreePath getPath() {
        return this.myPath;
    }

    public String getPathString() {
        if (this.myPath != null) {
            StringBuilder builder = new StringBuilder();
            Object[] pathArray = this.myPath.getPath();
            for (int i = 0; i < pathArray.length; ++i) {
                builder.append(((TariffStructureNode)pathArray[i]).getNodeId());
                builder.append("/");
            }
            builder.deleteCharAt(builder.length() - 1);
            return builder.toString();
        }
        if (this.myInitialPathString != null) {
            return this.myInitialPathString;
        }
        throw new IllegalStateException("Bookmark is not correctly initialized.");
    }

    public boolean isPathValidInTree(JTree tree) {
        TreePath path;
        String pathString = this.myInitialPathString;
        if (this.myIsInitialized) {
            pathString = this.getPathString();
        }
        if ((path = DAGUtil.getStringToUniqueTreePath(pathString, (TariffStructureNode)tree.getModel().getRoot())) != null && path.equals(this.myPath)) {
            this.myIsValid = true;
            return true;
        }
        this.myIsValid = false;
        return false;
    }

    public void revalidatePathInTree(JTree tree) {
        if (this.myPath != null) {
            String pathString = this.getPathString();
            TreePath path = DAGUtil.getStringToUniqueTreePath(pathString, (TariffStructureNode)tree.getModel().getRoot());
            if (path != null) {
                if (!this.myPath.equals(path)) {
                    this.myPath = path;
                    this.myIsEdited = true;
                }
                this.myIsValid = true;
            } else {
                this.myIsValid = false;
            }
        }
    }

    public String toString() {
        return this.myName;
    }

    public boolean isEdited() {
        return this.myIsEdited;
    }

    public void resetEdited() {
        this.myIsEdited = false;
    }
}

