/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import ericsson.ere.gui.ratingrules.FindPalette;
import ericsson.ere.gui.ratingrules.SelectorPanel;
import ericsson.ere.gui.ratingrules.nodes.HasProductTagPredicate;
import ericsson.ere.gui.ratingrules.nodes.NodeIdMatch;
import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.ratingrules.nodes.ParameterPredicate;
import ericsson.ere.gui.ratingrules.nodes.ProductTagPredicate;
import ericsson.ere.gui.ratingrules.nodes.RefCountPredicate;
import ericsson.ere.gui.ratingrules.nodes.STQPredicate;
import ericsson.ere.gui.ratingrules.nodes.STQReferenceCountPredicate;
import ericsson.ere.gui.ratingrules.nodes.TDFPredicate;
import javax.swing.JComponent;

public enum SelectorType {
    NAME_ID_TYPE(FindPalette.DEFAULT_SELECTORS[0]){

        @Override
        public NodePredicate createNewPredicate() {
            return new NodeIdMatch("", 0, false);
        }

        @Override
        public boolean represents(NodePredicate pred) {
            return pred instanceof NodeIdMatch;
        }

        @Override
        public SelectorPanel createPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            return new SelectorPanel.NameIdSelectorPanel(predicate, selectorPicker, removeButton);
        }
    }
    ,
    PARAMETER_TYPE(FindPalette.DEFAULT_SELECTORS[1]){

        @Override
        public NodePredicate createNewPredicate() {
            return new ParameterPredicate("", 0, "");
        }

        @Override
        public boolean represents(NodePredicate pred) {
            return pred instanceof ParameterPredicate;
        }

        @Override
        public SelectorPanel createPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            return new SelectorPanel.ParameterSelectorPanel(predicate, selectorPicker, removeButton);
        }
    }
    ,
    NUM_REF_TYPE(FindPalette.DEFAULT_SELECTORS[2]){

        @Override
        public NodePredicate createNewPredicate() {
            return new RefCountPredicate(-1, 0);
        }

        @Override
        public boolean represents(NodePredicate pred) {
            return pred instanceof RefCountPredicate;
        }

        @Override
        public SelectorPanel createPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            return new SelectorPanel.RefCountSelectorPanel(predicate, selectorPicker, removeButton);
        }
    }
    ,
    STQ(FindPalette.STQ_SELECTORS[0]){

        @Override
        public NodePredicate createNewPredicate() {
            return new STQPredicate("", 0);
        }

        @Override
        public boolean represents(NodePredicate pred) {
            return pred instanceof STQPredicate;
        }

        @Override
        public SelectorPanel createPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            return new SelectorPanel.STQSelectorPanel(predicate, selectorPicker, removeButton);
        }
    }
    ,
    HAS_STQ(FindPalette.STQ_SELECTORS[1]){

        @Override
        public NodePredicate createNewPredicate() {
            return new STQReferenceCountPredicate(1);
        }

        @Override
        public boolean represents(NodePredicate pred) {
            return pred instanceof STQReferenceCountPredicate && ((STQReferenceCountPredicate)pred).getLeastReferenceCount() == 1;
        }

        @Override
        public SelectorPanel createPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            return new SelectorPanel.HasSTQSelectorPanel(predicate, selectorPicker, removeButton);
        }
    }
    ,
    HAS_SHARED_STQ(FindPalette.STQ_SELECTORS[2]){

        @Override
        public NodePredicate createNewPredicate() {
            return new STQReferenceCountPredicate(2);
        }

        @Override
        public boolean represents(NodePredicate pred) {
            return pred instanceof STQReferenceCountPredicate && ((STQReferenceCountPredicate)pred).getLeastReferenceCount() == 2;
        }

        @Override
        public SelectorPanel createPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            return new SelectorPanel.HasSharedSTQSelectorPanel(predicate, selectorPicker, removeButton);
        }
    }
    ,
    PRODUCT_TAG(FindPalette.PRODUCT_TAG_SELECTORS[0]){

        @Override
        public NodePredicate createNewPredicate() {
            return new ProductTagPredicate("", ProductTagPredicate.OPERATOR.EQUALS);
        }

        @Override
        public boolean represents(NodePredicate pred) {
            return pred instanceof ProductTagPredicate;
        }

        @Override
        public SelectorPanel createPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            return new SelectorPanel.ProductTagSelectorPanel(predicate, selectorPicker, removeButton);
        }
    }
    ,
    HAS_PRODUCT_TAG(FindPalette.PRODUCT_TAG_SELECTORS[1]){

        @Override
        public NodePredicate createNewPredicate() {
            return new HasProductTagPredicate();
        }

        @Override
        public SelectorPanel createPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            return new SelectorPanel.HasProductTagSelectorPanel(predicate, selectorPicker, removeButton);
        }

        @Override
        public boolean represents(NodePredicate pred) {
            return pred instanceof HasProductTagPredicate;
        }
    }
    ,
    TDF(FindPalette.DEFAULT_SELECTORS[3]){

        @Override
        public NodePredicate createNewPredicate() {
            return new TDFPredicate("");
        }

        @Override
        public boolean represents(NodePredicate pred) {
            return pred instanceof TDFPredicate;
        }

        @Override
        public SelectorPanel createPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            return new SelectorPanel.TDFSelectorPanel(predicate, selectorPicker, removeButton);
        }
    };

    private String myText;

    private SelectorType(String text) {
        this.myText = text;
    }

    public String text() {
        return this.myText;
    }

    public static SelectorType lookup(String text) {
        SelectorType ret = null;
        for (SelectorType st : SelectorType.values()) {
            if (!st.text().equals(text)) continue;
            ret = st;
            break;
        }
        if (ret == null) {
            throw new AssertionError((Object)("Unhandled selector: " + text));
        }
        return ret;
    }

    public static SelectorType lookup(NodePredicate predicate) {
        SelectorType ret = null;
        for (SelectorType st : SelectorType.values()) {
            if (!st.represents(predicate)) continue;
            ret = st;
            break;
        }
        if (ret == null) {
            throw new AssertionError((Object)("Unhandled predicate: " + predicate.getClass()));
        }
        return ret;
    }

    public abstract boolean represents(NodePredicate var1);

    public abstract SelectorPanel createPanel(NodePredicate var1, JComponent var2, JComponent var3);

    public abstract NodePredicate createNewPredicate();
}

