/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import ericsson.ere.defs.RmaDefs;
import ericsson.ere.gui.ratingrules.nodes.HasProductTagPredicate;
import ericsson.ere.gui.ratingrules.nodes.NodeIdMatch;
import ericsson.ere.gui.ratingrules.nodes.NodePredicate;
import ericsson.ere.gui.ratingrules.nodes.ParameterPredicate;
import ericsson.ere.gui.ratingrules.nodes.ProductTagPredicate;
import ericsson.ere.gui.ratingrules.nodes.RefCountPredicate;
import ericsson.ere.gui.ratingrules.nodes.STQPredicate;
import ericsson.ere.gui.ratingrules.nodes.STQReferenceCountPredicate;
import ericsson.ere.gui.ratingrules.nodes.TDFPredicate;
import ericsson.vareditor.documents.NumbersOnlyDocument;
import java.awt.event.ActionListener;
import java.awt.event.KeyListener;
import java.util.EventListener;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.AncestorListener;

public abstract class SelectorPanel
extends Box {
    static final String[] NODEID_OP = new String[]{RmaDefs.getStringResource("ratingrules.find.NodeIdMatch.operators.0"), RmaDefs.getStringResource("ratingrules.find.NodeIdMatch.operators.1"), RmaDefs.getStringResource("ratingrules.find.NodeIdMatch.operators.2"), RmaDefs.getStringResource("ratingrules.find.NodeIdMatch.operators.3")};
    static final String NODEID_CASE = RmaDefs.getStringResource("ratingrules.find.NodeIdMatch.matchCase");
    static final String[] NUM_REF_OP = new String[]{RmaDefs.getStringResource("ratingrules.find.NumRef.operators.0"), RmaDefs.getStringResource("ratingrules.find.NumRef.operators.1"), RmaDefs.getStringResource("ratingrules.find.NumRef.operators.2"), RmaDefs.getStringResource("ratingrules.find.NumRef.operators.3")};
    static final String[] PARAM_OP = new String[]{RmaDefs.getStringResource("ratingrules.find.Parameter.operators.0"), RmaDefs.getStringResource("ratingrules.find.Parameter.operators.1"), RmaDefs.getStringResource("ratingrules.find.Parameter.operators.2"), RmaDefs.getStringResource("ratingrules.find.Parameter.operators.3"), RmaDefs.getStringResource("ratingrules.find.Parameter.operators.4"), RmaDefs.getStringResource("ratingrules.find.Parameter.operators.5"), RmaDefs.getStringResource("ratingrules.find.Parameter.operators.6")};
    static final String[] STQ_OP = new String[]{RmaDefs.getStringResource("ratingrules.find.STQ.operators.0"), RmaDefs.getStringResource("ratingrules.find.STQ.operators.1"), RmaDefs.getStringResource("ratingrules.find.STQ.operators.2"), RmaDefs.getStringResource("ratingrules.find.STQ.operators.3")};
    static final String[] PRODTAG_OP = new String[]{RmaDefs.getStringResource("ratingrules.find.ProductTag.operators.equals"), RmaDefs.getStringResource("ratingrules.find.ProductTag.operators.contains"), RmaDefs.getStringResource("ratingrules.find.ProductTag.operators.startsWith"), RmaDefs.getStringResource("ratingrules.find.ProductTag.operators.endsWith")};
    static final String[] TDF_OP = new String[]{RmaDefs.getStringResource("ratingrules.find.TDF.operators.0"), RmaDefs.getStringResource("ratingrules.find.TDF.operators.1"), RmaDefs.getStringResource("ratingrules.find.TDF.operators.2"), RmaDefs.getStringResource("ratingrules.find.TDF.operators.3")};
    private JComponent mySelectorPicker;
    private JComponent myRemoveButton;
    JTextField myText1;
    JComboBox myOperator;
    JTextField myText2;
    JCheckBox myCheck1;
    private NodePredicate myPredicate;

    SelectorPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
        super(0);
        this.myPredicate = predicate;
        this.mySelectorPicker = selectorPicker;
        this.myRemoveButton = removeButton;
        this.mySelectorPicker.setName("SelectorPanel.Picker.ChangePredicateType");
        this.myRemoveButton.setName("SelectorPanel.Button.Remove");
        this.populateFromPredicate();
    }

    private void populateFromPredicate() {
        this.add(this.mySelectorPicker);
        this.init(this.myPredicate);
        this.add(Box.createHorizontalStrut(5));
        this.add(this.myRemoveButton);
    }

    public boolean activated() {
        JComponent jc = this.myText1 == null ? this.mySelectorPicker : this.myText1;
        return jc.requestFocusInWindow();
    }

    protected void addPanelChangeListener(EventListener listener) {
        if (listener instanceof KeyListener) {
            if (this.myText1 != null) {
                this.myText1.addKeyListener((KeyListener)listener);
            }
            if (this.myText2 != null) {
                this.myText2.addKeyListener((KeyListener)listener);
            }
        }
        if (listener instanceof ActionListener) {
            if (this.myOperator != null) {
                this.myOperator.addActionListener((ActionListener)listener);
            }
            if (this.myCheck1 != null) {
                this.myCheck1.addActionListener((ActionListener)listener);
            }
            if (this.mySelectorPicker instanceof JComboBox) {
                ((JComboBox)this.mySelectorPicker).addActionListener((ActionListener)listener);
            }
        }
        if (listener instanceof AncestorListener) {
            this.addAncestorListener((AncestorListener)listener);
        }
    }

    protected abstract void init(NodePredicate var1);

    protected abstract NodePredicate createPredicate();

    static class TDFSelectorPanel
    extends SelectorPanel {
        static final long serialVersionUID = 1L;

        TDFSelectorPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            super(predicate, selectorPicker, removeButton);
        }

        @Override
        protected void init(NodePredicate predicate) {
            TDFPredicate pred = (TDFPredicate)predicate;
            this.myText1 = new JTextField(pred.getSearchString());
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myText1);
            this.myText1.setName("SelectorPanel.JTextField.TreeDefinedField");
        }

        @Override
        protected NodePredicate createPredicate() {
            return new TDFPredicate(this.myText1.getText());
        }
    }

    static class HasProductTagSelectorPanel
    extends SelectorPanel {
        HasProductTagSelectorPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            super(predicate, selectorPicker, removeButton);
        }

        @Override
        protected NodePredicate createPredicate() {
            return new HasProductTagPredicate();
        }

        @Override
        protected void init(NodePredicate predicate) {
        }
    }

    static class ProductTagSelectorPanel
    extends SelectorPanel {
        public ProductTagSelectorPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            super(predicate, selectorPicker, removeButton);
        }

        @Override
        protected NodePredicate createPredicate() {
            return new ProductTagPredicate(this.myText1.getText(), (ProductTagPredicate.OPERATOR)((Object)this.myOperator.getSelectedItem()));
        }

        @Override
        protected void init(NodePredicate predicate) {
            ProductTagPredicate pred = (ProductTagPredicate)predicate;
            this.myOperator = new JComboBox<ProductTagPredicate.OPERATOR>(ProductTagPredicate.OPERATOR.values());
            this.myOperator.setSelectedItem((Object)pred.getOperator());
            this.myText1 = new JTextField(pred.getProductTag());
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myOperator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myText1);
            this.myOperator.setName("SelectorPanel.JComboBox.Operator");
            this.myText1.setName("SelectorPanel.JTextField.ProductTag");
        }
    }

    static class HasSharedSTQSelectorPanel
    extends HasSTQSelectorPanel {
        HasSharedSTQSelectorPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            super(predicate, selectorPicker, removeButton);
        }

        @Override
        protected NodePredicate createPredicate() {
            return new STQReferenceCountPredicate(2);
        }
    }

    static class HasSTQSelectorPanel
    extends SelectorPanel {
        HasSTQSelectorPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            super(predicate, selectorPicker, removeButton);
        }

        @Override
        protected void init(NodePredicate predicate) {
        }

        @Override
        protected NodePredicate createPredicate() {
            return new STQReferenceCountPredicate(1);
        }
    }

    static class STQSelectorPanel
    extends SelectorPanel {
        STQSelectorPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            super(predicate, selectorPicker, removeButton);
        }

        @Override
        protected void init(NodePredicate predicate) {
            STQPredicate pred = (STQPredicate)predicate;
            this.myOperator = new JComboBox<String>(STQ_OP);
            this.myOperator.setSelectedIndex(pred.getOperator());
            this.myText1 = new JTextField(pred.getQualifier());
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myOperator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myText1);
            this.myText1.setName("SelectorPanel.JTextField.Qualifier");
            this.myOperator.setName("SelectorPanel.JComboBox.Operator");
        }

        @Override
        protected NodePredicate createPredicate() {
            return new STQPredicate(this.myText1.getText(), this.myOperator.getSelectedIndex());
        }
    }

    static class RefCountSelectorPanel
    extends SelectorPanel {
        RefCountSelectorPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            super(predicate, selectorPicker, removeButton);
        }

        @Override
        protected void init(NodePredicate predicate) {
            RefCountPredicate pred = (RefCountPredicate)predicate;
            this.myOperator = new JComboBox<String>(NUM_REF_OP);
            this.myOperator.setSelectedIndex(pred.getOperator());
            NumbersOnlyDocument doc = new NumbersOnlyDocument(0L, Integer.MAX_VALUE);
            int rc = pred.getReferenceCount();
            String strRC = rc >= 0 ? String.valueOf(rc) : "";
            this.myText1 = new JTextField(doc, strRC, 0);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myOperator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myText1);
            this.myText1.setName("SelectorPanel.JTextField.RefCount");
            this.myOperator.setName("SelectorPanel.JComboBox.Operator");
        }

        @Override
        protected NodePredicate createPredicate() {
            int i = 0;
            try {
                i = Integer.parseInt(this.myText1.getText());
            }
            catch (NumberFormatException x) {
                this.myText1.setText("0");
            }
            return new RefCountPredicate(i, this.myOperator.getSelectedIndex());
        }
    }

    static class ParameterSelectorPanel
    extends SelectorPanel {
        ParameterSelectorPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            super(predicate, selectorPicker, removeButton);
        }

        @Override
        protected void init(NodePredicate predicate) {
            ParameterPredicate pred = (ParameterPredicate)predicate;
            this.myText1 = new JTextField(pred.getParameterName());
            this.myOperator = new JComboBox<String>(PARAM_OP);
            this.myOperator.setSelectedIndex(pred.getOperator());
            this.myText2 = new JTextField(pred.getParameterValue());
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myText1);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myOperator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myText2);
            this.myText1.setName("SelectorPanel.JTextField.ParameterName");
            this.myOperator.setName("SelectorPanel.JComboBox.Operator");
            this.myText2.setName("SelectorPanel.JTextField.ParameterValue");
        }

        @Override
        protected NodePredicate createPredicate() {
            return new ParameterPredicate(this.myText1.getText(), this.myOperator.getSelectedIndex(), this.myText2.getText());
        }
    }

    static class NameIdSelectorPanel
    extends SelectorPanel {
        NameIdSelectorPanel(NodePredicate predicate, JComponent selectorPicker, JComponent removeButton) {
            super(predicate, selectorPicker, removeButton);
        }

        @Override
        protected void init(NodePredicate predicate) {
            NodeIdMatch pred = (NodeIdMatch)predicate;
            this.myOperator = new JComboBox<String>(NODEID_OP);
            this.myOperator.setSelectedIndex(pred.getOperator());
            this.myText1 = new JTextField(pred.getNameOrId());
            this.myCheck1 = new JCheckBox(NODEID_CASE);
            this.myCheck1.setSelected(pred.isCaseSensitive());
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myOperator);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myText1);
            this.add(Box.createHorizontalStrut(5));
            this.add(this.myCheck1);
            this.myText1.setName("SelectorPanel.JTextField.NameId");
            this.myOperator.setName("SelectorPanel.JComboBox.Operator");
            this.myCheck1.setName("SelectorPanel.JCheckBox.CaseSensitive");
        }

        @Override
        protected NodePredicate createPredicate() {
            return new NodeIdMatch(this.myText1.getText(), this.myOperator.getSelectedIndex(), this.myCheck1.isSelected());
        }
    }
}

