/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.ratingrules;

import ericsson.ere.gui.ratingrules.nodes.TSLink;
import ericsson.ere.gui.ratingrules.nodes.TariffDAGNode;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import javax.swing.tree.TreePath;

public class RatingRuleNodeTransferable
implements Transferable {
    public static String TAG_NODE_COPY_START = "<NodeCopy>";
    public static String TAG_NODE_COPY_END = "</NodeCopy>";
    public static String TEXT_RIGHT_CLICK = "rightClick";
    public static String TEXT_LEFT_CLICK = "leftClick";
    public static final DataFlavor NODE_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Node");
    public static final DataFlavor LINK_TO_NODE_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=java.lang.String", "Link to Node");
    public static final DataFlavor TREE_PATH_FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref; class=javax.swing.tree.TreePath", "Generation path");
    protected DataFlavor[] myDataFlavors = new DataFlavor[]{TREE_PATH_FLAVOR, NODE_FLAVOR, LINK_TO_NODE_FLAVOR, DataFlavor.stringFlavor};
    protected TreePath[] myNodePaths;
    private final boolean myIsRightClick;

    public RatingRuleNodeTransferable(TreePath[] paths, boolean isRightClick) {
        this.myNodePaths = paths;
        this.myIsRightClick = isRightClick;
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException {
        Object object;
        if (flavor == NODE_FLAVOR) {
            object = this.printNodes();
        } else if (flavor == LINK_TO_NODE_FLAVOR) {
            object = this.printLinks();
        } else if (flavor == TREE_PATH_FLAVOR) {
            object = this.myNodePaths;
        } else if (flavor == DataFlavor.stringFlavor) {
            object = this.printNodes();
        } else {
            throw new UnsupportedFlavorException(flavor);
        }
        return object;
    }

    protected String printNodes() {
        StringWriter buf = new StringWriter();
        PrintWriter out = new PrintWriter(buf);
        for (TreePath nodePath : this.myNodePaths) {
            ((TariffDAGNode)nodePath.getLastPathComponent()).print(out, 0, "\t");
        }
        out.flush();
        out.close();
        return TAG_NODE_COPY_START + this.clickToString() + buf.toString() + TAG_NODE_COPY_END;
    }

    protected String clickToString() {
        return this.myIsRightClick ? TEXT_RIGHT_CLICK : TEXT_LEFT_CLICK;
    }

    protected String printLinks() {
        StringBuilder xmlString = new StringBuilder();
        for (TreePath nodePath : this.myNodePaths) {
            xmlString.append(TSLink.convertPathToXMLLink(nodePath.getPath()));
        }
        return TAG_NODE_COPY_START + this.clickToString() + xmlString.toString() + TAG_NODE_COPY_END;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return this.myDataFlavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return Arrays.asList(this.myDataFlavors).contains(flavor);
    }
}

