/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.propertieseditor;

import ericsson.ere.gui.GuiServiceCenter;
import ericsson.ere.gui.propertieseditor.EditablePropertiesInterface;
import ericsson.ere.gui.propertieseditor.PropertiesException;
import ericsson.ere.gui.util.DialogFactory;
import ericsson.ere.integration.settingsmap.SettingsMap;
import ericsson.ere.integration.settingsmap.propertyio.VarTableInput;
import ericsson.ere.integration.settingsmap.propertyio.VarTableOutput;
import ericsson.vareditor.VarTable2;
import ericsson.vareditor.VarTableModel;
import ericsson.vareditor.variable.AbstractPanelVariableEditor;
import ericsson.vareditor.variable.StringVariable;
import ericsson.vareditor.variable.Variable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class PropertiesEditor
extends JDialog {
    private int hGap = 5;
    JPanel tablePanel;
    JPanel buttonPanel = new JPanel();
    JButton okButton = new JButton("OK");
    JButton cancelButton = new JButton("Cancel");
    VarTable2 myTable;
    VarTableModel myModel;
    EditablePropertiesInterface myPropertiesOwner;
    PropertiesEditor myInstance = null;
    SettingsMap myInitialSettings;
    private PropertyListener myListener;
    private final int MIN_DIALOG_SIZE = 300;
    private final int MAX_DIALOG_SIZE = 600;
    private final int NON_TABLE_DIALOG_WIDTH = 80;
    private final int NON_TABLE_DIALOG_HEIGTH = 130;

    private PropertiesEditor(VarTableModel model, String header, final EditablePropertiesInterface propOwner) {
        super(GuiServiceCenter.getInstance().getMainWindow(), header, true);
        this.myListener = new PropertyListener();
        this.myInstance = this;
        this.myPropertiesOwner = propOwner;
        this.myTable = new VarTable2();
        this.myTable.setTableModel(model);
        this.myModel = model;
        this.myInitialSettings = VarTableInput.readFromVarTableModel(model);
        this.buildTablePanel();
        this.getContentPane().add(this.tablePanel);
        this.setPreferredSize(this.calculatePreferredSize());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                propOwner.cancel();
            }
        });
        this.addKeyListenerToEditors(model);
        this.pack();
    }

    private PropertiesEditor(VarTableModel model, String header, boolean readOnly) {
        super(GuiServiceCenter.getInstance().getMainWindow(), header, true);
        if (readOnly) {
            this.initReadOnlyPropertiesEditor(model);
        } else {
            this.initPropertiesEditor(model);
        }
    }

    private PropertiesEditor(VarTableModel model, String header, boolean readOnly, EditablePropertiesInterface propOwner) {
        super(GuiServiceCenter.getInstance().getMainWindow(), header, true);
        this.myPropertiesOwner = propOwner;
        if (readOnly) {
            this.initReadOnlyPropertiesEditor(model);
        } else {
            this.initPropertiesEditor(model);
        }
    }

    private void initReadOnlyPropertiesEditor(VarTableModel model) {
        this.myInstance = this;
        this.myTable = new VarTable2();
        this.myListener = new PropertyListener();
        for (Variable var : model.dataVector) {
            var.setAllowEdit(false);
        }
        this.myTable.setTableModel(model);
        this.myModel = model;
        this.myInitialSettings = VarTableInput.readFromVarTableModel(model);
        this.buildOnlyOkTablePanel();
        this.getContentPane().add(this.tablePanel);
        this.setPreferredSize(this.calculatePreferredSize());
        this.pack();
    }

    private void initPropertiesEditor(VarTableModel model) {
        this.myInstance = this;
        this.myTable = new VarTable2();
        this.myListener = new PropertyListener();
        this.myTable.setTableModel(model);
        this.myModel = model;
        this.myInitialSettings = VarTableInput.readFromVarTableModel(model);
        this.createButtonPanel(false);
        this.getContentPane().add(this.tablePanel);
        this.setPreferredSize(this.calculatePreferredSize());
        this.pack();
    }

    private Dimension calculatePreferredSize() {
        Dimension preferredSize = new Dimension(300, 300);
        if (this.myTable != null) {
            Dimension tablePreferredSize = this.myTable.getActualPreferredSize();
            preferredSize.width = Math.min(Math.max(tablePreferredSize.width + 80, preferredSize.width), 600);
            preferredSize.height = Math.min(Math.max(tablePreferredSize.height + 130, preferredSize.height), 600);
        }
        return preferredSize;
    }

    public static void showDialogEdit(SettingsMap model, String header, EditablePropertiesInterface propOwner) {
        VarTableModel clonedModel = VarTableOutput.writeToVarTableModel(model);
        PropertiesEditor editor = new PropertiesEditor(clonedModel, header, propOwner);
        PropertiesEditor.setupEditor(editor);
    }

    public static void showDialogEdit(VarTableModel model, String header, EditablePropertiesInterface propOwner) {
        VarTableModel clonedModel = (VarTableModel)model.clone();
        PropertiesEditor editor = new PropertiesEditor(clonedModel, header, propOwner);
        PropertiesEditor.setupEditor(editor);
    }

    public static void showNonEditableDialog(VarTableModel model, String header) {
        VarTableModel clonedModel = (VarTableModel)model.clone();
        PropertiesEditor editor = new PropertiesEditor(clonedModel, header, true);
        PropertiesEditor.setupEditor(editor);
    }

    public static void showNonEditableDialog(VarTableModel model, String header, EditablePropertiesInterface propOwner) {
        VarTableModel clonedModel = (VarTableModel)model.clone();
        PropertiesEditor editor = new PropertiesEditor(clonedModel, header, true, propOwner);
        PropertiesEditor.setupEditor(editor);
    }

    private static void setupEditor(PropertiesEditor editor) {
        editor.setLocationRelativeTo(GuiServiceCenter.getInstance().getMainWindow());
        editor.setVisible(true);
    }

    private void buildTablePanel() {
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.setBorder(BorderFactory.createEmptyBorder(11, 11, 0, 11));
        this.tablePanel.add((Component)new JScrollPane(this.myTable), "Center");
        this.createButtonPanel(false);
        this.tablePanel.add((Component)this.buttonPanel, "South");
    }

    private void buildOnlyOkTablePanel() {
        this.tablePanel = new JPanel();
        this.tablePanel.setLayout(new BorderLayout());
        this.tablePanel.setBorder(BorderFactory.createEmptyBorder(11, 11, 0, 11));
        this.tablePanel.add((Component)new JScrollPane(this.myTable), "Center");
        this.createButtonPanel(true);
        this.tablePanel.add((Component)this.buttonPanel, "South");
    }

    private void createButtonPanel(boolean onlyOk) {
        this.okButton.addActionListener(this.myListener);
        this.okButton.setName("PropertiesEditor.JButton.okButton");
        this.cancelButton.addActionListener(this.myListener);
        this.buttonPanel.setLayout(new BoxLayout(this.buttonPanel, 0));
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(17, 11, 12, 0));
        this.buttonPanel.add(Box.createHorizontalStrut(this.hGap));
        this.buttonPanel.add(Box.createHorizontalGlue());
        this.buttonPanel.add(this.okButton);
        this.buttonPanel.add(Box.createHorizontalStrut(this.hGap));
        if (onlyOk) {
            this.okButton.setActionCommand("Cancel");
        } else {
            this.buttonPanel.add(this.cancelButton);
            this.buttonPanel.add(Box.createHorizontalStrut(this.hGap));
        }
    }

    private void addKeyListenerToEditors(VarTableModel model) {
        boolean readOnly = false;
        for (Variable var : model.getData()) {
            if (var.getEditor() instanceof AbstractPanelVariableEditor) {
                ((AbstractPanelVariableEditor)var.getEditor()).setKeyListenerOnComponents(this.myListener);
            }
            var.getEditor().addKeyListener(this.myListener);
            readOnly = !var.getEditor().isEnabled();
        }
        if (readOnly) {
            this.setFocusable(true);
            this.addKeyListener(this.myListener);
        }
    }

    private boolean settingsHaveChanged() {
        SettingsMap newSettingsMap = VarTableInput.readFromVarTableModel(this.myModel);
        String password = newSettingsMap.getParameterAsString("Password");
        if (password.equals("**************")) {
            newSettingsMap.setParameter("Password", this.myInitialSettings.getParameter("Password"));
        }
        return this.myInitialSettings.equals(newSettingsMap);
    }

    class PropertyListener
    implements ActionListener,
    KeyListener {
        PropertyListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String actionCommand = e.getActionCommand();
            if (actionCommand.equals("OK")) {
                this.okAction();
            } else if (actionCommand.equals("Cancel")) {
                this.cancelAction();
            }
        }

        @Override
        public void keyReleased(KeyEvent e) {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            if (e.getKeyCode() == 10) {
                this.okAction();
            } else if (e.getKeyCode() == 27) {
                this.cancelAction();
            }
        }

        @Override
        public void keyTyped(KeyEvent e) {
        }

        private void okAction() {
            if (PropertiesEditor.this.settingsHaveChanged()) {
                this.cancelAction();
            } else {
                this.okAndSubmitAction();
            }
        }

        private void okAndSubmitAction() {
            try {
                for (Variable currentVariable : PropertiesEditor.this.myModel.getData()) {
                    String stringValue;
                    if (!currentVariable.isValueValid()) {
                        currentVariable.getEditor().requestFocusInWindow();
                        throw new PropertiesException(currentVariable.getLabel() + " value is invalid.");
                    }
                    if (!(currentVariable instanceof StringVariable) || (stringValue = currentVariable.getValueString()).equals(stringValue.trim())) continue;
                    currentVariable.setValue(stringValue.trim());
                }
                if (PropertiesEditor.this.myPropertiesOwner.isSuccessful()) {
                    PropertiesEditor.this.myPropertiesOwner.update(PropertiesEditor.this.myModel);
                    PropertiesEditor.this.dispose();
                }
            }
            catch (PropertiesException pe) {
                DialogFactory.getErrorDialog(GuiServiceCenter.getInstance().getMainWindow(), "Edit failed", pe.getMessage());
            }
        }

        private void cancelAction() {
            if (PropertiesEditor.this.myPropertiesOwner != null) {
                PropertiesEditor.this.myPropertiesOwner.cancel();
            }
            PropertiesEditor.this.dispose();
        }
    }
}

