/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.log.logfile;

import ericsson.ere.gui.log.LogOutput;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

public class LogFile
implements LogOutput {
    private Formatter myFormatter = null;
    private PrintWriter myWriter = null;

    public LogFile(File file, Formatter formatter) {
        this(file, formatter, true);
    }

    public LogFile(File file, Formatter formatter, boolean append) {
        this.myFormatter = formatter;
        try {
            this.myWriter = new PrintWriter(new FileOutputStream(file, append));
            this.myWriter.print(formatter.getHead(null));
        }
        catch (FileNotFoundException e) {
            System.err.println("Could not open the log file for writing: " + file);
        }
    }

    @Override
    public synchronized void publish(LogRecord record) {
        if (this.myFormatter != null && this.myWriter != null) {
            this.myWriter.print(this.myFormatter.format(record));
            this.myWriter.flush();
        }
    }

    @Override
    public synchronized void close() {
        if (this.myWriter == null) {
            return;
        }
        try {
            this.myWriter.print(this.myFormatter.getTail(null));
            this.myWriter.flush();
            this.myWriter.close();
            this.myWriter = null;
        }
        catch (Exception e) {
            System.err.println("There was a problem closing the log file: " + e.getMessage());
        }
    }
}

