/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.log;

import ericsson.ere.gui.log.LogOutput;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;

public class LogHandler
extends Handler {
    private List<LogOutput> myRegisteredOutputs = new ArrayList<LogOutput>();

    public void addOutput(LogOutput out) {
        this.myRegisteredOutputs.add(out);
    }

    public void removeOutput(LogOutput out) {
        this.myRegisteredOutputs.remove(out);
    }

    public boolean hasOutput(LogOutput out) {
        return this.myRegisteredOutputs.contains(out);
    }

    @Override
    public void close() throws SecurityException {
        for (LogOutput lo : this.myRegisteredOutputs) {
            lo.close();
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void publish(LogRecord record) {
        for (LogOutput lo : this.myRegisteredOutputs) {
            lo.publish(record);
        }
    }

    public void reRegisterLevel(Level theLevel) {
        Enumeration<String> e = LogManager.getLogManager().getLoggerNames();
        while (e.hasMoreElements()) {
            Logger logger2 = Logger.getLogger(e.nextElement());
            if (!logger2.getName().startsWith("rma")) continue;
            logger2.setLevel(theLevel);
            logger2.setUseParentHandlers(false);
            logger2.removeHandler(this);
            logger2.addHandler(this);
        }
    }
}

