/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui.log;

import com.ericsson.ere.io.TailReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.LinkedList;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class LogEntryReader
implements Closeable {
    private TailReader myTailReader;
    private static Pattern myLogEntryPattern = Pattern.compile("^(\\d+)\u0000(\\d+)\u0000(SEVERE|WARNING|INFO|CONFIG|FINE|FINER|FINEST)\u0000([^\u0000]+)\u0000");
    private RandomAccessFile myFile;

    public LogEntryReader(File logFile, String charset) throws FileNotFoundException {
        this.myFile = new RandomAccessFile(logFile, "r");
        this.myTailReader = new TailReader(this.myFile, charset);
    }

    public LogEntryReader(File logFile) throws FileNotFoundException {
        this.myFile = new RandomAccessFile(logFile, "r");
        this.myTailReader = new TailReader(this.myFile);
    }

    public LogEntry readLogEntry() throws IOException {
        String line;
        if (this.myFile == null) {
            throw new IOException("Log file has been closed.");
        }
        LinkedList<String> lines = new LinkedList<String>();
        LogEntry entry = null;
        while ((line = this.myTailReader.readLine()) != null) {
            Matcher matcher = myLogEntryPattern.matcher(line);
            if (matcher.lookingAt()) {
                entry = new LogEntry();
                entry.seqno = Long.parseLong(matcher.group(1));
                entry.millis = Long.parseLong(matcher.group(2));
                entry.level = Level.parse(matcher.group(3));
                entry.source = matcher.group(4);
                StringBuilder builder = new StringBuilder();
                builder.append(line.substring(matcher.end()));
                for (String additionalLine : lines) {
                    builder.append(additionalLine);
                }
                entry.message = builder.toString();
                break;
            }
            lines.add(0, line);
        }
        return entry;
    }

    @Override
    public void close() throws IOException {
        if (this.myFile != null) {
            this.myFile.close();
            this.myFile = null;
        }
    }

    public class LogEntry {
        private long millis;
        private Level level;
        private String source;
        private String message;
        private long seqno;

        public long getMillis() {
            return this.millis;
        }

        public Level getLevel() {
            return this.level;
        }

        public String getSource() {
            return this.source;
        }

        public String getMessage() {
            return this.message;
        }

        public long getSequenceNumber() {
            return this.seqno;
        }
    }
}

