/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.gui;

import com.ericsson.ere.gui.frame.RmaFrameEvent;
import com.ericsson.ere.gui.frame.RmaFrameListener;
import ericsson.ere.gui.GuiServiceCenter;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JDesktopPane;
import javax.swing.JInternalFrame;
import javax.swing.event.InternalFrameAdapter;
import javax.swing.event.InternalFrameEvent;

public class RmaFrameSupport
extends JInternalFrame
implements ActionListener {
    private static List<RmaFrameListener> myFrameListeners = new ArrayList<RmaFrameListener>();
    private List<FrameCallback<Boolean>> myOkToDiscardCallbacks = new ArrayList<FrameCallback<Boolean>>();

    public RmaFrameSupport() {
        this.init();
    }

    public RmaFrameSupport(String name) {
        super(name, true, true, true, true);
        this.init();
    }

    private void init() {
        this.addInternalFrameListener(new MyInternalFrameAdapter());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isIcon()) {
            GuiServiceCenter.setIconNoVeto(this, false);
        }
        GuiServiceCenter.setSelectedNoVeto(this, true);
    }

    public boolean isOkToDiscardChanges() {
        return true;
    }

    public void addOkToDiscardCallback(FrameCallback<Boolean> callback) {
        this.myOkToDiscardCallbacks.add(callback);
    }

    public void removeOkToDiscardCallback(FrameCallback<Boolean> callback) {
        this.myOkToDiscardCallbacks.remove(callback);
    }

    boolean privIsOkToDiscardChanges() {
        for (int i = this.myOkToDiscardCallbacks.size() - 1; i >= 0; --i) {
            boolean isOk = this.isOkToDiscardChanges(this.myOkToDiscardCallbacks.get(i));
            if (isOk) continue;
            return false;
        }
        return this.isOkToDiscardChanges();
    }

    private boolean isOkToDiscardChanges(FrameCallback<Boolean> callback) {
        return callback.call(this);
    }

    public static void addRmaFrameListener(RmaFrameListener listener) {
        myFrameListeners.add(listener);
    }

    public static void removeRmaFrameListener(RmaFrameListener listener) {
        myFrameListeners.remove(listener);
    }

    public static void removeRmaFrameListenerByClass(Class<? extends RmaFrameListener> clazz) {
        for (int i = myFrameListeners.size() - 1; i >= 0; --i) {
            if (myFrameListeners.get(i).getClass() != clazz) continue;
            myFrameListeners.remove(i);
        }
    }

    public static void clearRmaFrameListeners() {
        myFrameListeners.clear();
    }

    public void fireActivatedEvent(InternalFrameEvent e) {
        RmaFrameEvent event = new RmaFrameEvent(this, e);
        for (RmaFrameListener l : myFrameListeners) {
            l.frameActivated(event);
        }
    }

    public void fireRemovedEvent(InternalFrameEvent e) {
        RmaFrameEvent event = new RmaFrameEvent(this, e);
        for (RmaFrameListener l : myFrameListeners) {
            l.frameRemoved(event);
        }
    }

    public void fireDeactivatedEvent(InternalFrameEvent e) {
        RmaFrameEvent event = new RmaFrameEvent(this, e);
        for (RmaFrameListener l : myFrameListeners) {
            l.frameDeactivated(event);
        }
    }

    public void fireCreatedEvent(InternalFrameEvent e) {
        RmaFrameEvent event = new RmaFrameEvent(this, e);
        for (RmaFrameListener l : myFrameListeners) {
            l.frameCreated(event);
        }
    }

    public static interface FrameCallback<T> {
        public T call(RmaFrameSupport var1);
    }

    private class MyInternalFrameAdapter
    extends InternalFrameAdapter {
        private MyInternalFrameAdapter() {
        }

        @Override
        public void internalFrameOpened(InternalFrameEvent e) {
            RmaFrameSupport.this.fireCreatedEvent(e);
        }

        @Override
        public void internalFrameActivated(InternalFrameEvent e) {
            RmaFrameSupport.this.fireActivatedEvent(e);
        }

        @Override
        public void internalFrameDeactivated(InternalFrameEvent e) {
            RmaFrameSupport.this.fireDeactivatedEvent(e);
        }

        @Override
        public void internalFrameClosing(InternalFrameEvent e) {
            int op = 0;
            if (RmaFrameSupport.this.privIsOkToDiscardChanges()) {
                op = 2;
            }
            RmaFrameSupport.this.setDefaultCloseOperation(op);
        }

        @Override
        public void internalFrameClosed(InternalFrameEvent e) {
            RmaFrameSupport.this.fireRemovedEvent(e);
            JDesktopPane desktopPane = GuiServiceCenter.getInstance().getDesktopPane();
            if (desktopPane.getSelectedFrame() != null) {
                desktopPane.selectFrame(true);
                desktopPane.selectFrame(false);
            }
        }
    }
}

