/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.datatype;

import ericsson.ere.datatype.interfaces.UnsignedInt;

public final class UnsignedInt8
extends Number
implements UnsignedInt,
Cloneable {
    public static final short MAX_VALUE = 255;
    public static final short MIN_VALUE = 0;
    public static final UnsignedInt8 ZERO = new UnsignedInt8(0);
    public static final UnsignedInt8 MAX = new UnsignedInt8(255);
    private short myShortValue;

    public UnsignedInt8(byte value) {
        this.setValue(value);
    }

    public UnsignedInt8(short value) {
        this.checkValue(value);
        this.setValue((byte)value);
    }

    public UnsignedInt8(String str) {
        short value = Short.parseShort(str);
        this.checkValue(value);
        this.setValue((byte)value);
    }

    @Deprecated
    public void set(byte value) {
        this.setValue(value);
    }

    private void setValue(byte value) {
        this.myShortValue = value < 0 ? (short)(value + 255 + 1) : (short)value;
    }

    public byte byteSignedValue() {
        return (byte)this.myShortValue;
    }

    @Override
    public byte byteValue() {
        return (byte)this.myShortValue;
    }

    @Override
    public short shortValue() {
        return this.myShortValue;
    }

    @Override
    public int intValue() {
        return this.myShortValue;
    }

    @Override
    public long longValue() {
        return this.myShortValue;
    }

    @Override
    public float floatValue() {
        return this.myShortValue;
    }

    @Override
    public double doubleValue() {
        return this.myShortValue;
    }

    public int hashCode() {
        return this.myShortValue;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof UnsignedInt)) {
            return false;
        }
        return this.longValue() == ((UnsignedInt)obj).longValue();
    }

    public static UnsignedInt8 valueOf(String aValue) {
        short number = Short.parseShort(aValue);
        if (number == 0) {
            return ZERO;
        }
        if (number == 255) {
            return MAX;
        }
        return new UnsignedInt8(number);
    }

    public String toString() {
        return Short.toString(this.myShortValue);
    }

    private void checkValue(short val) {
        if (val < 0 || val > 255) {
            throw new IllegalArgumentException("UnsignedInt8 value out of range: " + val);
        }
    }

    public UnsignedInt8 clone() {
        try {
            return (UnsignedInt8)super.clone();
        }
        catch (CloneNotSupportedException ex) {
            throw new AssertionError((Object)ex);
        }
    }
}

