/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.time;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.util.UTime;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import ericsson.ere.xml.XMLUtil;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.conditions.time.TimeOfCall.class)
public class TimeOfCall
extends AbstractCondition {
    private long myStartTime;
    private long myStopTime;

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        long toTime;
        super.init(iterator);
        String from = null;
        String to = null;
        NodeList children = iterator.getChildNodes();
        Element node = XMLUtil.getNamedElement("From", children);
        if (node == null) {
            throw new IllegalArgumentException("Missing element: From");
        }
        from = XMLUtil.getFirstTextContent(node);
        node = XMLUtil.getNamedElement("To", children);
        if (node == null) {
            throw new IllegalArgumentException("Missing element: To");
        }
        to = XMLUtil.getFirstTextContent(node);
        if (from == null || "".equals(from)) {
            throw new IllegalArgumentException("Empty element: From");
        }
        if (to == null || "".equals(to)) {
            throw new IllegalArgumentException("Empty element: To");
        }
        long fromTime = UTime.timeToSec(from);
        if (fromTime > (toTime = UTime.timeToSec(to))) {
            throw new IllegalArgumentException("From Time (" + from + ") is greater than To time (" + to + ").");
        }
        this.myStartTime = fromTime;
        this.myStopTime = toTime + 1L;
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (int)(this.myStartTime ^ this.myStartTime >>> 32);
        result = 31 * result + (int)(this.myStopTime ^ this.myStopTime >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeOfCall other = (TimeOfCall)obj;
        if (this.myStartTime != other.myStartTime) {
            return false;
        }
        return this.myStopTime == other.myStopTime;
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        if (theData.currentDuration >= this.myStartTime && theData.currentDuration < this.myStopTime) {
            long max = this.getConditionSatisfiedDuration(theData);
            theData.setCurrentMaxDuration(max);
            if (theData.useTrace()) {
                theData.getTrace().println("\tTimeOfCall.test " + theData.currentDuration / 3600L + ":" + theData.currentDuration % 3600L / 60L + ":" + theData.currentDuration % 60L + " => TRUE (maxDuration == " + theData.currentMaxDuration + ")");
            }
            return true;
        }
        long max = this.getConditionUnsatisfiedDuration(theData);
        theData.setCurrentMaxDuration(max);
        if (theData.useTrace()) {
            theData.getTrace().println("\tTimeOfCall.test " + theData.currentDuration / 3600L + ":" + theData.currentDuration % 3600L / 60L + ":" + theData.currentDuration % 60L + " => FALSE (maxDuration == " + theData.currentMaxDuration + ")");
        }
        return false;
    }

    @Override
    public long getConditionSatisfiedDuration(RatingData theData) {
        long max = Long.MAX_VALUE;
        if (theData.currentDuration < this.myStopTime) {
            max = this.myStopTime - theData.currentDuration;
        }
        return max;
    }

    @Override
    public long getConditionUnsatisfiedDuration(RatingData theData) {
        long max = Long.MAX_VALUE;
        if (theData.currentDuration < this.myStartTime) {
            max = this.myStartTime - theData.currentDuration;
        }
        return max;
    }
}

