/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.string;

import ericsson.ere.condition.AbstractConditionProfile;
import ericsson.ere.datatype.OctetString;
import ericsson.vareditor.documents.HexStringDocument;
import ericsson.vareditor.documents.StringListDocument;
import ericsson.vareditor.variable.DropDownVariable;
import ericsson.vareditor.variable.MultilineStringVariable;
import ericsson.vareditor.variable.VarListUtil;
import ericsson.vareditor.variable.Variable;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.text.PlainDocument;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OctetStringListProfile
extends AbstractConditionProfile {
    private static String LABEL_STRING = "Strings";
    private static String LABEL_MODE = "Mode";
    private static String[] myModes = new String[]{"Ascii", "Hex"};

    @Override
    public List<Variable> getVariables() {
        ArrayList<Variable> l = new ArrayList<Variable>();
        DropDownVariable modeVar = new DropDownVariable(LABEL_MODE, 0, (Object[])myModes);
        String defaultString = "";
        StringListDocument doc = new StringListDocument(defaultString.getClass());
        MultilineStringVariable stringsVar = new MultilineStringVariable(LABEL_STRING, defaultString, doc);
        l.add(modeVar);
        l.add(stringsVar);
        return l;
    }

    @Override
    public List<Variable> getVariables(Node iterator) {
        ArrayList<Variable> l = new ArrayList<Variable>();
        String strings = "";
        String mode = "Ascii";
        NodeList children = iterator.getChildNodes();
        for (int aa = 0; aa < children.getLength(); ++aa) {
            NodeList value;
            int bb;
            if (children.item(aa).getNodeType() != 1) continue;
            String k = children.item(aa).getNodeName();
            if (k.equalsIgnoreCase("String") && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                strings = value.item(bb).getNodeValue();
            }
            if (!k.equalsIgnoreCase("Mode") || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
            mode = value.item(bb).getNodeValue();
        }
        if (mode.equals(myModes[1])) {
            char[] allowedValues = new char[]{',', '\t', '\n', '\r', '\u0000'};
            HexStringDocument doc = new HexStringDocument(String.class, allowedValues);
            MultilineStringVariable stringsVar = new MultilineStringVariable(LABEL_STRING, strings, doc);
            DropDownVariable modeVar = new DropDownVariable(LABEL_MODE, 1, (Object[])myModes);
            l.add(modeVar);
            l.add(stringsVar);
        } else {
            StringListDocument doc = new StringListDocument(strings.getClass());
            MultilineStringVariable stringsVar = new MultilineStringVariable(LABEL_STRING, strings, doc);
            DropDownVariable modeVar = new DropDownVariable(LABEL_MODE, 0, (Object[])myModes);
            l.add(modeVar);
            l.add(stringsVar);
        }
        return l;
    }

    @Override
    public void printParametersImpl(PrintWriter out, int indentLevel, String indentMarker, List<Variable> variables) {
        String strings = VarListUtil.getValueStringForName(variables, LABEL_STRING);
        out.println("<String>" + strings + "</" + "String" + ">");
        String mode = VarListUtil.getValueStringForName(variables, LABEL_MODE);
        if (mode.equals("0")) {
            out.println("<Mode>Ascii</Mode>");
        } else if (mode.equals("1")) {
            out.println("<Mode>Hex</Mode>");
        }
    }

    public boolean parameterChanged(String ref, Object value, List<Variable> vars) {
        if (LABEL_MODE.equals(ref)) {
            PlainDocument doc;
            String newSelection = ((Variable)value).getValueString();
            String oldStrings = (String)vars.get(vars.size() - 1).getValueObject();
            StringTokenizer next = new StringTokenizer(oldStrings, ",\t\n\r\u0000", true);
            String newStrings = "";
            while (next.hasMoreTokens()) {
                OctetString oStr;
                String token = next.nextToken();
                if (token.equals(",") || token.equals("\t") || token.equals("\n") || token.equals("\r") || token.equals("\u0000")) {
                    newStrings = newStrings + token;
                    continue;
                }
                if (newSelection.equals("0")) {
                    oStr = OctetString.valueOf(token);
                    newStrings = newStrings + oStr.toAscii();
                    continue;
                }
                oStr = OctetString.fromAscii(token);
                newStrings = newStrings + oStr.toString();
            }
            if (newSelection.equals("0")) {
                char[] allowedValues = new char[]{',', '\t', '\n', '\r', '\u0000'};
                doc = new HexStringDocument(String.class, allowedValues);
            } else {
                doc = new StringListDocument(newStrings.getClass());
            }
            MultilineStringVariable stringsVar = new MultilineStringVariable(LABEL_STRING, newStrings, doc);
            vars.remove(vars.size() - 1);
            vars.add(stringsVar);
            return true;
        }
        return false;
    }
}

