/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.string;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.datatype.OctetString;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.conditions.string.OctetStringCondition.class)
public class OctetStringCondition
extends AbstractCondition {
    private OctetString myString;
    private boolean myModeIsHex;
    private int myComparation;
    static String TAG_COMPARATION = "Comparation";
    static String TAG_TEXT = "Text";
    static String TAG_MODE = "Mode";
    static int TAG_COMPARE_BEGINS_WITH = 0;
    static int TAG_COMPARE_ENDS_WITH = 1;
    static int TAG_COMPARE_CONTAINS = 2;
    static int TAG_COMPARE_EXACT_MATCH = 3;

    @Override
    public boolean needsFieldToBeSet() {
        return true;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.setKey(fieldName);
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String theType = "Hex";
        String theText = "";
        int theComparation = 0;
        this.setConditionName(iterator.getChildNodes().item(0).getNodeValue().trim());
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (children.item(aa).getNodeName().toLowerCase().equals(TAG_COMPARATION.toLowerCase()) && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    theComparation = Integer.parseInt(value.item(bb).getNodeValue());
                }
                if (children.item(aa).getNodeName().toLowerCase().equals(TAG_TEXT.toLowerCase()) && children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    theText = value.item(bb).getNodeValue();
                }
                if (!children.item(aa).getNodeName().toLowerCase().equals(TAG_MODE.toLowerCase()) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                theType = value.item(bb).getNodeValue();
            }
        }
        this.myString = new OctetString("");
        this.myComparation = theComparation;
        if (theType.equalsIgnoreCase("Hex")) {
            if (theText.length() > 0) {
                this.myString = OctetString.valueOf(theText);
            }
            this.myModeIsHex = true;
        } else {
            if (theText.length() > 0) {
                this.myString = OctetString.fromAscii(theText);
            }
            this.myModeIsHex = false;
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + this.myComparation;
        result = 31 * result + (this.myModeIsHex ? 1231 : 1237);
        result = 31 * result + (this.myString == null ? 0 : this.myString.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OctetStringCondition other = (OctetStringCondition)obj;
        if (this.myComparation != other.myComparation) {
            return false;
        }
        if (this.myModeIsHex != other.myModeIsHex) {
            return false;
        }
        return !(this.myString == null ? other.myString != null : !this.myString.equals(other.myString));
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        String modeStr;
        String valueStr;
        OctetString value = (OctetString)theData.getValueObject(this.key);
        String compareStr = "";
        if (this.myModeIsHex) {
            valueStr = value.toString();
            compareStr = this.myString.toString();
            modeStr = "Hex";
        } else {
            valueStr = value.toAscii();
            compareStr = this.myString.toAscii();
            modeStr = "Ascii";
        }
        if (theData.useTrace()) {
            theData.getTrace().println("\tdata." + this.key + "== '" + valueStr + "', text == '" + compareStr + "', in mode " + modeStr);
        }
        if (compareStr.length() <= 0) {
            if (valueStr.length() == 0) {
                if (theData.useTrace()) {
                    theData.getTrace().println("\t" + this.conditionName + ".test() = TRUE ( All strings are empty ) ");
                }
                return true;
            }
            if (theData.useTrace()) {
                theData.getTrace().println("\t" + this.conditionName + ".test = FALSE ( data." + this.key + " is empty )");
            }
            return false;
        }
        if (this.myComparation == TAG_COMPARE_BEGINS_WITH) {
            if (valueStr.startsWith(compareStr)) {
                if (theData.useTrace()) {
                    theData.getTrace().println("\t" + this.conditionName + ".test() = TRUE ( data." + this.key + " " + valueStr + " startsWith " + compareStr + " )");
                }
                return true;
            }
            if (theData.useTrace()) {
                theData.getTrace().println("\t" + this.conditionName + ".test = FALSE ( data." + this.key + " " + valueStr + " startsWith " + compareStr + " )");
            }
            return false;
        }
        if (this.myComparation == TAG_COMPARE_ENDS_WITH) {
            if (valueStr.endsWith(compareStr)) {
                if (theData.useTrace()) {
                    theData.getTrace().println("\t" + this.conditionName + ".test() = TRUE ( data." + this.key + " " + valueStr + " endsWith " + compareStr + " )");
                }
                return true;
            }
            if (theData.useTrace()) {
                theData.getTrace().println("\t" + this.conditionName + ".test = FALSE ( data." + this.key + " " + valueStr + " endsWith " + compareStr + " )");
            }
            return false;
        }
        if (this.myComparation == TAG_COMPARE_CONTAINS) {
            if (valueStr.indexOf(compareStr) > -1) {
                if (theData.useTrace()) {
                    theData.getTrace().println("\t" + this.conditionName + ".test() = TRUE ( data." + this.key + " " + valueStr + " contains " + compareStr + " )");
                }
                return true;
            }
            if (theData.useTrace()) {
                theData.getTrace().println("\t" + this.conditionName + ".test = FALSE ( data." + this.key + " " + valueStr + " contains " + compareStr + " )");
            }
            return false;
        }
        if (this.myComparation == TAG_COMPARE_EXACT_MATCH) {
            if (valueStr.equals(compareStr)) {
                if (theData.useTrace()) {
                    theData.getTrace().println("\t" + this.conditionName + ".test() = TRUE ( data." + this.key + " " + valueStr + " equals " + compareStr + " )");
                }
                return true;
            }
            if (theData.useTrace()) {
                theData.getTrace().println("\t" + this.conditionName + ".test = FALSE ( data." + this.key + " " + valueStr + " equals " + compareStr + " )");
            }
            return false;
        }
        return false;
    }
}

