/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.ipaddress;

import com.ericsson.ere.annotations.SupersededBy;
import ericsson.ere.RatingData;
import ericsson.ere.RatingDataField;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.condition.ConditionUtil;
import ericsson.ere.exception.RatingException;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.management.Debug;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import java.util.Arrays;
import java.util.StringTokenizer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Deprecated
@SupersededBy(value=com.ericsson.ere.selectiontree.conditions.string.IpAddress.class)
public class IpAddress
extends AbstractCondition {
    public static String TAG_MASK = "Mask";
    String myMaskString = "";
    short[] myIpBytes = new short[4];
    short myNumberOfSignificantBits = 0;
    long myIp = 0L;
    long myMask = 0L;

    private long ipAddressToLong(short[] ipAddressBytes) {
        long ipLongValue = 0L;
        ipLongValue += (long)ipAddressBytes[0] * 256L * 256L * 256L;
        ipLongValue += (long)ipAddressBytes[1] * 256L * 256L;
        ipLongValue += (long)ipAddressBytes[2] * 256L;
        return ipLongValue += (long)ipAddressBytes[3];
    }

    private long createMask(int numberOfSignificantBits) {
        int aa;
        long val = 1L;
        if (numberOfSignificantBits == 0) {
            return 0L;
        }
        for (aa = 1; aa < numberOfSignificantBits; ++aa) {
            val <<= 1;
            ++val;
        }
        while (aa < 32) {
            val <<= 1;
            ++aa;
        }
        return val;
    }

    public long ipStringToLong(String ipAddress) {
        short[] addressArray = new short[4];
        StringTokenizer token = new StringTokenizer(ipAddress, ".");
        for (int index = 0; token.hasMoreTokens() && index < addressArray.length; ++index) {
            try {
                addressArray[index] = Short.parseShort(token.nextToken());
                continue;
            }
            catch (NumberFormatException e) {
                break;
            }
        }
        return this.ipAddressToLong(addressArray);
    }

    public void setMask(String ipMask) throws RatingException {
        if (ipMask.indexOf("/") >= 0) {
            this.readCIDRString(ipMask);
        } else if (ipMask.indexOf("*") >= 0) {
            this.readWildCardString(ipMask);
        } else {
            this.readIp(ipMask);
        }
        this.myMaskString = ipMask;
        this.myMask = this.createMask(this.myNumberOfSignificantBits);
        this.myIp = this.ipAddressToLong(this.myIpBytes);
        this.myIp &= this.myMask;
    }

    private void readWildCardString(String ipMask) throws RatingException {
        int counter = 0;
        for (int ii = 0; ii < this.myIpBytes.length; ++ii) {
            this.myIpBytes[ii] = 0;
        }
        this.myNumberOfSignificantBits = (short)32;
        StringTokenizer token = new StringTokenizer(ipMask, ".");
        while (token.hasMoreTokens()) {
            short aShort;
            String tmpStr = token.nextToken();
            if (tmpStr.equals("*")) {
                this.myNumberOfSignificantBits = (short)(counter * 8);
                break;
            }
            if (counter < 3) {
                try {
                    aShort = Short.parseShort(tmpStr);
                }
                catch (NumberFormatException e) {
                    String errMsg = "'" + ipMask + "' is NOT a valid ipAddress Wild card mask, only '0-9', '.' and '*' allowed";
                    throw new RatingException(6, errMsg);
                }
                if (aShort < 0 || aShort > 255) {
                    String errMsg = "'" + ipMask + "' contains an invalid value '" + aShort + "' (range: 0-255)";
                    throw new RatingException(6, errMsg);
                }
            } else {
                String errMsg = "'" + ipMask + "' to many  '.''s ";
                throw new RatingException(6, errMsg);
            }
            this.myIpBytes[counter] = aShort;
            ++counter;
        }
    }

    private void readIp(String ipMask) throws RatingException {
        int counter = 0;
        for (int ii = 0; ii < this.myIpBytes.length; ++ii) {
            this.myIpBytes[ii] = 0;
        }
        this.myNumberOfSignificantBits = (short)32;
        StringTokenizer token = new StringTokenizer(ipMask, ".");
        if (token.countTokens() < 4) {
            String errMsg = "'" + ipMask + "' is malformed, NOT a valid ip address";
            throw new RatingException(6, errMsg);
        }
        while (token.hasMoreTokens()) {
            short aShort;
            String tmpStr = token.nextToken();
            if (counter < 4) {
                try {
                    aShort = Short.parseShort(tmpStr);
                }
                catch (NumberFormatException e) {
                    String errMsg = "'" + ipMask + "' is NOT a valid ipAddress, only '0-9' and '.' allowed";
                    throw new RatingException(6, errMsg);
                }
                if (aShort < 0 || aShort > 255) {
                    String errMsg = "'" + ipMask + "' contains an invalid value '" + aShort + "' (range: 0-255)";
                    throw new RatingException(6, errMsg);
                }
            } else {
                String errMsg = "'" + this.myMaskString + "' have to many address parts '";
                throw new RatingException(6, errMsg);
            }
            this.myIpBytes[counter] = aShort;
            ++counter;
        }
    }

    private void readCIDRString(String ipMask) throws RatingException {
        int counter = 0;
        this.myNumberOfSignificantBits = (short)32;
        for (int ii = 0; ii < this.myIpBytes.length; ++ii) {
            this.myIpBytes[ii] = 0;
        }
        int pos = ipMask.indexOf(47);
        if (pos < ipMask.length() - 1) {
            String numberOfSignString = ipMask.substring(pos + 1, ipMask.length());
            try {
                this.myNumberOfSignificantBits = Short.parseShort(numberOfSignString);
            }
            catch (NumberFormatException e) {
                String errMsg = "'" + ipMask + "' Significant bits part NOT a number (1-32)";
                throw new RatingException(6, errMsg);
            }
            if (this.myNumberOfSignificantBits < 1 || this.myNumberOfSignificantBits > 32) {
                String errMsg = "'" + ipMask + "' Significant bits part NOT a in valid range (1-32)";
                throw new RatingException(6, errMsg);
            }
        } else {
            String errMsg = "'" + ipMask + "' Significant bits part is NOT valid (range 1-32)";
            throw new RatingException(6, errMsg);
        }
        StringTokenizer token = new StringTokenizer(ipMask.substring(0, pos), ".");
        if (token.countTokens() < 4) {
            String errMsg = "'" + ipMask + "' is malformed, NOT a valid ip address";
            throw new RatingException(6, errMsg);
        }
        while (token.hasMoreTokens()) {
            short aShort;
            String numberStr = token.nextToken();
            try {
                aShort = Short.parseShort(numberStr);
                if (counter >= 4) {
                    String errMsg = ipMask + "' have to many address parts '";
                    throw new RatingException(6, errMsg);
                }
                this.myIpBytes[counter] = aShort;
            }
            catch (NumberFormatException e) {
                String errMsg = "'" + ipMask + "' is NOT in a valid CIDR Notation , only '0-9', '.' and '/' allowed";
                throw new RatingException(6, errMsg);
            }
            if (aShort < 0 || aShort > 255) {
                String errMsg = "'" + ipMask + "' contains an invalid value '" + aShort + "' (range: 0-255)";
                throw new RatingException(6, errMsg);
            }
            ++counter;
        }
    }

    public boolean validate(String ipAddressString) {
        if (Debug.isDebug()) {
            Debug.debug("Validating: " + ipAddressString + " internal ip for mask: " + this.getIpAsString() + " with significantbits : " + this.myNumberOfSignificantBits + " maskString : '" + this.myMaskString + "'");
        }
        boolean retBoolean = false;
        if (this.myMaskString.trim().length() == 0) {
            retBoolean = false;
        } else if (ipAddressString.trim().length() == 0) {
            retBoolean = false;
        } else {
            long theIp = this.ipStringToLong(ipAddressString);
            if ((theIp & this.myMask) == this.myIp) {
                retBoolean = true;
            }
        }
        return retBoolean;
    }

    private String getIpAsString() {
        return this.myIpBytes[0] + "." + this.myIpBytes[1] + "." + this.myIpBytes[2] + "." + this.myIpBytes[3];
    }

    @Override
    public boolean needsFieldToBeSet() {
        return true;
    }

    @Override
    public void setFieldName(String fieldName) {
        this.setKey(fieldName);
    }

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String theMask = "";
        this.setConditionName(iterator.getChildNodes().item(0).getNodeValue().trim());
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                if (!children.item(aa).getNodeName().toLowerCase().equals(TAG_MASK.toLowerCase()) || !children.item(aa).hasChildNodes() || (bb = 0) >= (value = children.item(aa).getChildNodes()).getLength()) continue;
                theMask = value.item(bb).getNodeValue();
            }
        }
        this.myMaskString = theMask;
        if (theMask.length() > 0) {
            this.setMask(theMask);
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (int)(this.myIp ^ this.myIp >>> 32);
        result = 31 * result + Arrays.hashCode(this.myIpBytes);
        result = 31 * result + (int)(this.myMask ^ this.myMask >>> 32);
        result = 31 * result + (this.myMaskString == null ? 0 : this.myMaskString.hashCode());
        result = 31 * result + this.myNumberOfSignificantBits;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IpAddress other = (IpAddress)obj;
        if (this.myIp != other.myIp) {
            return false;
        }
        if (!Arrays.equals(this.myIpBytes, other.myIpBytes)) {
            return false;
        }
        if (this.myMask != other.myMask) {
            return false;
        }
        if (this.myMaskString == null ? other.myMaskString != null : !this.myMaskString.equals(other.myMaskString)) {
            return false;
        }
        return this.myNumberOfSignificantBits == other.myNumberOfSignificantBits;
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        boolean retBoolean = false;
        RatingDataField fieldWithIp = ConditionUtil.getField(this.conditionName, this.key, theData);
        fieldWithIp.isUsed(true);
        ConditionUtil.getString(this.conditionName, theData.useTrace(), theData.getTrace(), 0, fieldWithIp);
        Object ipAddress = fieldWithIp.getFirstValue();
        if (this.validate(ipAddress.toString())) {
            if (theData.useTrace()) {
                theData.getTrace().println("\tIp address " + ipAddress + " is valid for '" + this.myMaskString + "' => TRUE");
            }
            retBoolean = true;
        } else {
            if (theData.useTrace()) {
                theData.getTrace().println("\tIp address " + ipAddress + " is NOT valid for '" + this.myMaskString + "' => FALSE");
            }
            retBoolean = false;
        }
        return retBoolean;
    }
}

