/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition.distance;

import ericsson.ere.RatingData;
import ericsson.ere.condition.AbstractCondition;
import ericsson.ere.interfaces.XMLInitializable;
import ericsson.ere.values.DoubleValue;
import ericsson.ere.values.LongValue;
import java.util.StringTokenizer;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DistanceCondition
extends AbstractCondition {
    static final double earthRadiusInKm = 6377.5;
    public static final String TAG_FROM_LONG_FIELD = "FromLongitudeField";
    public static final String TAG_FROM_LAT_FIELD = "FromLatitudeField";
    public static final String TAG_END_LONG_FIELD = "EndLongitudeField";
    public static final String TAG_END_LAT_FIELD = "EndLatitudeField";
    public static final String TAG_FIELDNAME = "FieldNameToUse";
    String fromLongField = null;
    String fromLatField = null;
    String endLongField = null;
    String endLatField = null;
    String fieldNameForDistance = null;

    @Override
    public XMLInitializable init(Node iterator) throws Exception {
        super.init(iterator);
        String nodeValue = "";
        this.setConditionName(iterator.getChildNodes().item(0).getNodeValue().trim());
        if (iterator.hasChildNodes()) {
            NodeList children = iterator.getChildNodes();
            for (int aa = 0; aa < children.getLength(); ++aa) {
                NodeList value;
                int bb;
                String nodeName = children.item(aa).getNodeName().toLowerCase();
                if (children.item(aa).hasChildNodes() && (bb = 0) < (value = children.item(aa).getChildNodes()).getLength()) {
                    nodeValue = value.item(bb).getNodeValue();
                }
                if (nodeName.equalsIgnoreCase(TAG_FROM_LONG_FIELD)) {
                    this.fromLongField = nodeValue;
                    continue;
                }
                if (nodeName.equalsIgnoreCase(TAG_FROM_LAT_FIELD)) {
                    this.fromLatField = nodeValue;
                    continue;
                }
                if (nodeName.equalsIgnoreCase(TAG_END_LONG_FIELD)) {
                    this.endLongField = nodeValue;
                    continue;
                }
                if (nodeName.equalsIgnoreCase(TAG_END_LAT_FIELD)) {
                    this.endLatField = nodeValue;
                    continue;
                }
                if (!nodeName.equalsIgnoreCase(TAG_FIELDNAME)) continue;
                this.fieldNameForDistance = nodeValue;
            }
        }
        return this;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCodeImpl();
        result = 31 * result + (this.endLatField == null ? 0 : this.endLatField.hashCode());
        result = 31 * result + (this.endLongField == null ? 0 : this.endLongField.hashCode());
        result = 31 * result + (this.fieldNameForDistance == null ? 0 : this.fieldNameForDistance.hashCode());
        result = 31 * result + (this.fromLatField == null ? 0 : this.fromLatField.hashCode());
        result = 31 * result + (this.fromLongField == null ? 0 : this.fromLongField.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !super.equalsImpl(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DistanceCondition other = (DistanceCondition)obj;
        if (this.endLatField == null ? other.endLatField != null : !this.endLatField.equals(other.endLatField)) {
            return false;
        }
        if (this.endLongField == null ? other.endLongField != null : !this.endLongField.equals(other.endLongField)) {
            return false;
        }
        if (this.fieldNameForDistance == null ? other.fieldNameForDistance != null : !this.fieldNameForDistance.equals(other.fieldNameForDistance)) {
            return false;
        }
        if (this.fromLatField == null ? other.fromLatField != null : !this.fromLatField.equals(other.fromLatField)) {
            return false;
        }
        return !(this.fromLongField == null ? other.fromLongField != null : !this.fromLongField.equals(other.fromLongField));
    }

    @Override
    public boolean needsFieldToBeSet() {
        return false;
    }

    @Override
    public void setFieldName(String fieldName) {
    }

    @Override
    public boolean test(RatingData theData, DoubleValue theCost, LongValue theTime) throws Exception {
        try {
            double distance = this.calcDistance((String)theData.getValueObject(this.fromLongField), (String)theData.getValueObject(this.fromLatField), (String)theData.getValueObject(this.endLongField), (String)theData.getValueObject(this.endLatField));
            theData.setFirstField(this.fieldNameForDistance, new Double(distance));
            if (theData.useTrace()) {
                theData.getTrace().println("\t Distance calculated ");
                theData.getTrace().println("\t From : longitude " + (String)theData.getValueObject(this.fromLongField) + " latitude :" + (String)theData.getValueObject(this.fromLatField));
                theData.getTrace().println("\t End  : longitude " + (String)theData.getValueObject(this.endLongField) + " latitude :" + (String)theData.getValueObject(this.endLatField));
                theData.getTrace().println("\t Distance is : " + distance + " km");
                theData.getTrace().println("\t Distance is put in the data with key = '" + this.fieldNameForDistance + "'");
                theData.getTrace().println("\t Returning => True");
            }
            return true;
        }
        catch (Exception e) {
            if (theData.useTrace()) {
                theData.getTrace().println("\tCould not calc distance  " + e);
                theData.getTrace().println("\t Returning => False");
            }
            return false;
        }
    }

    private double calcDistance(String startLongStr, String startLatStr, String endLongStr, String endLatStr) {
        double startLong = this.posToDegrees(startLongStr);
        double startLat = this.posToDegrees(startLatStr);
        double endLong = this.posToDegrees(endLongStr);
        double endLat = this.posToDegrees(endLatStr);
        double Y = StrictMath.sin(StrictMath.toRadians(endLat)) * StrictMath.sin(StrictMath.toRadians(startLat));
        double Z = StrictMath.cos(StrictMath.toRadians(endLat)) * StrictMath.cos(StrictMath.toRadians(startLat)) * StrictMath.cos(StrictMath.toRadians(endLong - startLong));
        double distance = 6377.5 * StrictMath.acos(Y + Z);
        return distance;
    }

    public double posToDegrees(String pos) {
        String compass;
        StringTokenizer token = new StringTokenizer(pos, ":");
        double degrees = 0.0;
        double minute = 0.0;
        double second = 0.0;
        double corr = 1.0;
        if (token.hasMoreTokens()) {
            degrees = Double.parseDouble(token.nextToken());
        }
        if (token.hasMoreTokens()) {
            minute = Double.parseDouble(token.nextToken());
        }
        if (token.hasMoreTokens()) {
            second = Double.parseDouble(token.nextToken());
        }
        if (token.hasMoreTokens() && (compass = token.nextToken()).equals("W")) {
            corr = -1.0;
        }
        return (degrees + minute / 60.0 + second / 3600.0) * corr;
    }
}

