/*
 * Decompiled with CFR 0.152.
 */
package ericsson.ere.condition;

import ericsson.ere.RatingData;
import ericsson.ere.RatingDataField;
import ericsson.ere.datatype.Time;
import ericsson.ere.datatype.interfaces.UnsignedInt;
import ericsson.ere.exception.RatingException;
import ericsson.ere.trace.RatingTraceInterface;
import java.util.Calendar;

public final class ConditionUtil {
    public static RatingDataField getField(String condName, String key, RatingData theData) throws RatingException {
        RatingDataField retField = theData.getRatingDataFieldByName(key);
        if (retField == null) {
            String errorString = condName + ",  Field '" + key + "' not found in RatingData";
            if (theData.useTrace()) {
                theData.getTrace().println(errorString);
            }
            throw new RatingException(1, errorString);
        }
        return retField;
    }

    public static RatingDataField getField(String condName, int tagVal, RatingData theData) throws RatingException {
        RatingDataField retField = theData.getRatingDataFieldByTag(tagVal);
        if (retField == null) {
            String errorString = condName + ",  Field with Tag value '" + tagVal + "' not found in RatingData";
            if (theData.useTrace()) {
                theData.getTrace().println(errorString);
            }
            throw new RatingException(2, errorString, tagVal);
        }
        return retField;
    }

    public static UnsignedInt getUnsignedInt(String condName, boolean useTrace, RatingTraceInterface trace, int index, RatingDataField field) throws RatingException {
        String errorString = "";
        Object tmpObj = field.getValue(index);
        if (tmpObj == null) {
            errorString = condName + ", Value at index " + index + " not found in [" + field.getTagNumber() + "] " + field.getName();
            if (useTrace) {
                trace.println(errorString);
            }
            throw new RatingException(3, errorString, field.getTagNumber());
        }
        if (!(tmpObj instanceof UnsignedInt)) {
            errorString = condName + ", Datatype at  " + index + " for  [" + field.getTagNumber() + "] '" + field.getName() + "' is not an UnsignedInt";
            if (useTrace) {
                trace.println(errorString);
            }
            throw new RatingException(4, errorString, field.getTagNumber());
        }
        return (UnsignedInt)tmpObj;
    }

    public static String getString(String condName, boolean useTrace, RatingTraceInterface trace, int index, RatingDataField field) throws RatingException {
        String errorString = "";
        Object tmpObj = field.getValue(index);
        if (tmpObj == null) {
            errorString = condName + ", Value at index " + index + " not found in [" + field.getTagNumber() + "] '" + field.getName() + "'";
            if (useTrace) {
                trace.println(errorString);
            }
            throw new RatingException(3, errorString, field.getTagNumber());
        }
        if (!(tmpObj instanceof String)) {
            errorString = condName + ", Datatype at  " + index + " for  [" + field.getTagNumber() + "] '" + field.getName() + "' is not an String";
            if (useTrace) {
                trace.println(errorString);
            }
            throw new RatingException(4, errorString, field.getTagNumber());
        }
        return (String)tmpObj;
    }

    public static Calendar getCalendarValue(String condName, boolean useTrace, RatingTraceInterface trace, int index, RatingDataField field) throws RatingException {
        String errorString = "";
        Object tmpObj = field.getValue(index);
        if (tmpObj == null) {
            errorString = condName + ", Value at index " + index + " not found in [" + field.getTagNumber() + "] '" + field.getName() + "'";
            if (useTrace) {
                trace.println(errorString);
            }
            throw new RatingException(3, errorString, field.getTagNumber());
        }
        if (tmpObj instanceof Calendar) {
            return (Calendar)tmpObj;
        }
        if (tmpObj instanceof Time) {
            return ((Time)tmpObj).getCalendar();
        }
        errorString = condName + ", Datatype at  " + index + " for  [" + field.getTagNumber() + "] '" + field.getName() + "' is not a Calender or Time type";
        if (useTrace) {
            trace.println(errorString);
        }
        throw new RatingException(4, errorString, field.getTagNumber());
    }
}

