/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.vareditor.document;

import com.ericsson.vareditor.document.LimitingDocument;
import java.math.BigDecimal;
import java.util.regex.Pattern;

public abstract class AbstractNumberDocument
extends LimitingDocument {
    private static final Pattern NUMBER_CHARS_INTEGER_PATTERN = Pattern.compile("[0-9-]");
    private static final Pattern NUMBER_CHARS_FLOAT_PATTERN = Pattern.compile("[0-9\\.eE-]");

    protected AbstractNumberDocument(boolean allowFloatingPoint, boolean allowEmpty) {
        super(AbstractNumberDocument.createCharPattern(allowFloatingPoint), Pattern.compile(allowEmpty ? ".*" : ".+"));
    }

    @Override
    protected void testWholeText(String text) throws LimitingDocument.Rejection {
        super.testWholeText(text);
        if (text.isEmpty()) {
            return;
        }
        try {
            this.testNumber(new BigDecimal(text));
        }
        catch (NumberFormatException nfe) {
            throw new LimitingDocument.Rejection("Not a valid number: " + text);
        }
    }

    protected abstract void testNumber(BigDecimal var1) throws LimitingDocument.Rejection;

    private static Pattern createCharPattern(boolean allowFloatingPoint) {
        return allowFloatingPoint ? NUMBER_CHARS_FLOAT_PATTERN : NUMBER_CHARS_INTEGER_PATTERN;
    }
}

