/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.utils;

public enum FileSizeUnit {
    BYTES("b"){

        @Override
        public long toBytes(long s) {
            return s;
        }

        @Override
        public long toKiloBytes(long s) {
            return s / 1024L;
        }

        @Override
        public long toMegaBytes(long s) {
            return s / 1024L / 1024L;
        }

        @Override
        public long toGigaBytes(long s) {
            return s / 1024L / 1024L / 1024L;
        }

        @Override
        public long convert(long sourceSize, FileSizeUnit sourceUnit) {
            return sourceUnit.toBytes(sourceSize);
        }
    }
    ,
    KILOBYTES("Kb"){

        @Override
        public long toBytes(long s) {
            return s * 1024L;
        }

        @Override
        public long toKiloBytes(long s) {
            return s;
        }

        @Override
        public long toMegaBytes(long s) {
            return s / 1024L;
        }

        @Override
        public long toGigaBytes(long s) {
            return s / 1024L / 1024L;
        }

        @Override
        public long convert(long sourceSize, FileSizeUnit sourceUnit) {
            return sourceUnit.toKiloBytes(sourceSize);
        }
    }
    ,
    MEGABYTES("Mb"){

        @Override
        public long toBytes(long s) {
            return s * 1024L * 1024L;
        }

        @Override
        public long toKiloBytes(long s) {
            return s * 1024L;
        }

        @Override
        public long toMegaBytes(long s) {
            return s;
        }

        @Override
        public long toGigaBytes(long s) {
            return s / 1024L;
        }

        @Override
        public long convert(long sourceSize, FileSizeUnit sourceUnit) {
            return sourceUnit.toMegaBytes(sourceSize);
        }
    }
    ,
    GIGABYTES("Gb"){

        @Override
        public long toBytes(long s) {
            return s * 1024L * 1024L * 1024L;
        }

        @Override
        public long toKiloBytes(long s) {
            return s * 1024L * 1024L;
        }

        @Override
        public long toMegaBytes(long s) {
            return s * 1024L;
        }

        @Override
        public long toGigaBytes(long s) {
            return s;
        }

        @Override
        public long convert(long sourceSize, FileSizeUnit sourceUnit) {
            return sourceUnit.toGigaBytes(sourceSize);
        }
    };

    private static final int COEFFICENT = 1024;
    private final String abbrivation;

    private FileSizeUnit(String abbrivation) {
        this.abbrivation = abbrivation;
    }

    public String getAbbreviation() {
        return this.abbrivation;
    }

    public abstract long toBytes(long var1);

    public abstract long toKiloBytes(long var1);

    public abstract long toMegaBytes(long var1);

    public abstract long toGigaBytes(long var1);

    public abstract long convert(long var1, FileSizeUnit var3);

    public String toString(long s) {
        return String.format("%d %s", s, this.getAbbreviation());
    }

    public static FileSizeUnit valueOfAbbreviation(String abbreviation) {
        if (abbreviation == null || abbreviation.equals("")) {
            return BYTES;
        }
        for (FileSizeUnit unit : FileSizeUnit.values()) {
            if (!unit.getAbbreviation().equalsIgnoreCase(abbreviation)) continue;
            return unit;
        }
        throw new IllegalArgumentException(String.format("Could not find matching file size unit for %s", abbreviation));
    }
}

