/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.functional.typed;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.function.Consumer;

@FunctionalInterface
public interface CheckedConsumer<T, E extends Exception> {
    public void accept(T var1) throws E;

    public static <T> Consumer<T> toUnchecked(CheckedConsumer<T, Exception> consumer) {
        Preconditions.checkNotNull(consumer);
        return t -> {
            try {
                consumer.accept(t);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

