/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities.console;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public final class ConsoleFormatter {
    private static final String RESET = "\u001b[0m";
    private static final String PREFIX = "\u001b[";
    private static final String SUFFIX = "m";
    private static final String DELIMITER = ";";

    private ConsoleFormatter() {
    }

    public static String format(Supplier<String> stringSupplier, Format format, Format ... formats) {
        Preconditions.checkNotNull(stringSupplier, "'stringSupplier' is invalid, can not be null");
        Preconditions.checkNotNull(format, "'format' is invalid, can not be null");
        return ConsoleFormatter.format(stringSupplier.get(), format, formats);
    }

    public static String format(String string, Format format, Format ... formats) {
        if (string == null) {
            return null;
        }
        Preconditions.checkNotNull(format, "'format' is invalid, can not be null");
        ArrayList<Formatting> formatting = new ArrayList<Formatting>();
        formatting.add(format);
        formatting.addAll(Arrays.asList(formats));
        String encodedFormat = ConsoleFormatter.getFormat(formatting);
        return encodedFormat + string + RESET;
    }

    public static String colorize(Supplier<String> stringSupplier, Color color) {
        Preconditions.checkNotNull(stringSupplier, "'stringSupplier' is invalid, can not be null");
        Preconditions.checkNotNull(color, "'color' is invalid, can not be null");
        return ConsoleFormatter.colorize(stringSupplier.get(), color);
    }

    public static String colorize(String string, Color color) {
        if (string == null) {
            return null;
        }
        Preconditions.checkNotNull(color, "'color' is invalid, can not be null");
        String format = ConsoleFormatter.getFormat(Collections.singletonList(color));
        return format + string + RESET;
    }

    public static String formatAndColorize(Supplier<String> stringSupplier, Color color, Format format, Format ... formats) {
        Preconditions.checkNotNull(stringSupplier, "'stringSupplier' is invalid, can not be null");
        Preconditions.checkNotNull(color, "'color' is invalid, can not be null");
        Preconditions.checkNotNull(format, "'format' is invalid, can not be null");
        return ConsoleFormatter.formatAndColorize(stringSupplier.get(), color, format, formats);
    }

    public static String formatAndColorize(String string, Color color, Format format, Format ... formats) {
        if (string == null) {
            return null;
        }
        Preconditions.checkNotNull(color, "'color' is invalid, can not be null");
        Preconditions.checkNotNull(format, "'format' is invalid, can not be null");
        ArrayList<Formatting> formatting = new ArrayList<Formatting>();
        formatting.add(color);
        formatting.add(format);
        formatting.addAll(Arrays.asList(formats));
        String encodedFormat = ConsoleFormatter.getFormat(formatting);
        return String.format("%s%s%s", encodedFormat, string, RESET);
    }

    private static String getFormat(List<Formatting> formats) {
        return formats.stream().filter(Objects::nonNull).map(Formatting::getCodeAsString).collect(Collectors.joining(DELIMITER, PREFIX, SUFFIX));
    }

    public static enum Format implements Formatting
    {
        BOLD(1),
        DIM(2),
        UNDERLINED(4),
        BLINK(5),
        REVERSE(7),
        HIDDEN(8);

        final int code;

        private Format(int code) {
            this.code = code;
        }

        @Override
        public String getCodeAsString() {
            return Objects.toString(this.code);
        }
    }

    public static enum Color implements Formatting
    {
        DEFAULT(39),
        BLACK(30),
        RED(31),
        GREEN(32),
        YELLOW(33),
        BLUE(34),
        MAGENTA(35),
        CYAN(36),
        LIGHT_GRAY(37),
        DARK_GRAY(90),
        LIGHT_RED(91),
        LIGHT_GREEN(92),
        LIGHT_YELLOW(93),
        LIGHT_BLUE(94),
        LIGHT_MAGENTA(95),
        LIGHT_CYAN(96),
        WHITE(97);

        final int code;

        private Color(int code) {
            this.code = code;
        }

        @Override
        public String getCodeAsString() {
            return Objects.toString(this.code);
        }
    }

    private static interface Formatting {
        public String getCodeAsString();
    }
}

