/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import java.security.SecureRandom;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;

public class TokenGenerator {
    private static final int MINIMUM_TOKEN_LENGHT = 4;
    private final Random random = new SecureRandom();
    private static final char[] ALL_LETTERS = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z'};
    private static final char[] ALL_DIGITS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9'};
    private boolean useLetters = true;
    private boolean useDigits = true;
    private boolean useUpperAndLowerCase = false;
    private final List<Character> tokenCharacterList = new LinkedList<Character>();
    private int tokenLength = 12;
    private char[] excludedLetters = new char[]{'l', 'o', 'i'};
    private char[] excludedDigits = new char[0];

    public String createToken() {
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < this.tokenLength; ++i) {
            result.append(this.tokenCharacterList.get(this.random.nextInt(this.tokenCharacterList.size())));
        }
        return result.toString();
    }

    public String createStrongToken() {
        StringBuilder result = null;
        boolean isValid = false;
        String password = null;
        while (!isValid) {
            result = new StringBuilder();
            boolean containDigits = !this.useDigits;
            boolean containLowerCaseLetters = !this.useLetters;
            boolean containUpperCaseLetters = !this.useUpperAndLowerCase;
            for (int i = 0; i < this.tokenLength; ++i) {
                Character c = this.tokenCharacterList.get(this.random.nextInt(this.tokenCharacterList.size()));
                if (!containLowerCaseLetters && Character.isLowerCase(c.charValue())) {
                    containLowerCaseLetters = true;
                } else if (!containUpperCaseLetters && Character.isUpperCase(c.charValue())) {
                    containUpperCaseLetters = true;
                } else if (!containDigits && Character.isDigit(c.charValue())) {
                    containDigits = true;
                }
                result.append(c);
            }
            password = result.toString();
            if (!containDigits || !containLowerCaseLetters || !containUpperCaseLetters) continue;
            int maxNumOfIdenticalConsecutiveChars = 2;
            int len = password.length();
            for (int i = 0; i < len; ++i) {
                char c = password.charAt(i);
                int n = 1;
                for (int j = i + 1; j < len && password.charAt(j) == c; ++j) {
                    if (++n <= maxNumOfIdenticalConsecutiveChars) continue;
                    return password;
                }
            }
            isValid = true;
        }
        return password;
    }

    public void setTokenLength(int value) {
        this.tokenLength = value;
        if (this.tokenLength < 4) {
            throw new IllegalArgumentException(String.format("Token length must be at least %d characters", 4));
        }
    }

    public void setUseLetters(boolean value) {
        this.useLetters = value;
    }

    public void setUseUpperAndLowerCaseLetters(boolean value) {
        this.useUpperAndLowerCase = value;
    }

    public void setUseDigits(boolean value) {
        this.useDigits = value;
    }

    public void setExcludedLetters(String value) {
        this.excludedLetters = new char[value.trim().length()];
        for (int ii = 0; ii < this.excludedLetters.length; ++ii) {
            this.excludedLetters[ii] = value.charAt(ii);
        }
    }

    public void setExcludedDigits(String value) {
        this.excludedDigits = new char[value.trim().length()];
        for (int ii = 0; ii < this.excludedDigits.length; ++ii) {
            this.excludedDigits[ii] = value.charAt(ii);
        }
    }

    public void start() {
        if (!this.useDigits && !this.useLetters) {
            throw new IllegalArgumentException("At least one of UseDigits, UseLetters must be set to true");
        }
        this.tokenCharacterList.clear();
        if (this.useDigits) {
            for (char ch : ALL_DIGITS) {
                if (this.isAnExcludedDigit(ch)) continue;
                this.tokenCharacterList.add(Character.valueOf(ch));
            }
        }
        if (this.useLetters) {
            for (char cha : ALL_LETTERS) {
                if (this.isAnExcludedLetter(cha)) continue;
                this.tokenCharacterList.add(Character.valueOf(cha));
            }
        }
        if (this.useUpperAndLowerCase) {
            for (char cha : ALL_LETTERS) {
                if (this.isAnExcludedLetter(cha)) continue;
                this.tokenCharacterList.add(Character.valueOf(Character.toUpperCase(cha)));
            }
        }
        if (this.tokenCharacterList.isEmpty()) {
            throw new IllegalArgumentException("No characters availible for token generation, excluded to many letters ?");
        }
    }

    private boolean isAnExcludedLetter(char letter) {
        for (char ch : this.excludedLetters) {
            if (ch != letter) continue;
            return true;
        }
        return false;
    }

    private boolean isAnExcludedDigit(char digit) {
        for (char ch : this.excludedDigits) {
            if (ch != digit) continue;
            return true;
        }
        return false;
    }
}

