/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import com.ericsson.lwac.utilities.ObjectValidator;
import com.google.common.base.CharMatcher;
import jakarta.validation.ValidationException;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class PasswordBuilder {
    private static final String CHAR_LOWERCASE = "abcdefghijklmnopqrstuvwxyz";
    private static final String CHAR_UPPERCASE = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private static final String DIGITS = "0123456789";
    private static final String SPECIAL_CHARS = "!@#&()-[{}]:;',?/*";
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz" + CHAR_UPPERCASE + "0123456789!@#&()-[{}]:;',?/*";
    @Min(value=0L)
    private @Min(value=0L) int minimumLowerCase = 2;
    @Min(value=0L)
    private @Min(value=0L) int minimumUpperCase = 2;
    @Min(value=0L)
    private @Min(value=0L) int minimumDigits = 2;
    @Min(value=0L)
    private @Min(value=0L) int minimumSpecial = 2;
    @Min(value=0L)
    private @Min(value=0L) int passwordLength = 24;
    private char[] excludedCharacters = new char[0];
    @NotNull
    private SecureRandom secureRandom = new SecureRandom();

    private PasswordBuilder() {
    }

    public static PasswordBuilder newBuilder() {
        return new PasswordBuilder();
    }

    public static PasswordBuilder newPKCS12CompliantBuilder() {
        return new PasswordBuilder().excludedCharacters('$', '?', ';', '\'', '<', '>', '(', ')');
    }

    public PasswordBuilder minimumLowerCase(int val) {
        this.minimumLowerCase = val;
        return this;
    }

    public PasswordBuilder minimumUpperCase(int val) {
        this.minimumUpperCase = val;
        return this;
    }

    public PasswordBuilder minimumDigits(int val) {
        this.minimumDigits = val;
        return this;
    }

    public PasswordBuilder minimumSpecial(int val) {
        this.minimumSpecial = val;
        return this;
    }

    public PasswordBuilder passwordLength(int val) {
        this.passwordLength = val;
        return this;
    }

    public PasswordBuilder secureRandom(SecureRandom val) {
        this.secureRandom = new SecureRandom(val.generateSeed(16));
        return this;
    }

    public PasswordBuilder excludedCharacters(char ... val) {
        this.excludedCharacters = Arrays.copyOf(val, val.length);
        return this;
    }

    public String build() {
        ObjectValidator.validate(this);
        int minimumLength = this.minimumLowerCase + this.minimumUpperCase + this.minimumDigits + this.minimumSpecial;
        if (minimumLength > this.passwordLength) {
            throw new ValidationException("Required chars larger than password length");
        }
        ArrayList<Character> parts = new ArrayList<Character>(this.passwordLength);
        parts.addAll(this.generate(CHAR_LOWERCASE, this.minimumLowerCase));
        parts.addAll(this.generate(CHAR_UPPERCASE, this.minimumUpperCase));
        parts.addAll(this.generate(DIGITS, this.minimumDigits));
        parts.addAll(this.generate(SPECIAL_CHARS, this.minimumSpecial));
        parts.addAll(this.generate(ALPHABET, this.passwordLength - minimumLength));
        Collections.shuffle(parts, this.secureRandom);
        return parts.stream().map(String::valueOf).collect(Collectors.joining(""));
    }

    private List<Character> generate(String input, int length) {
        String calculatedInput = CharMatcher.anyOf(String.valueOf(this.excludedCharacters)).removeFrom(input);
        return IntStream.range(0, length).mapToObj(unused -> Character.valueOf(calculatedInput.charAt(this.secureRandom.nextInt(calculatedInput.length())))).collect(Collectors.toList());
    }
}

