/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.lwac.utilities;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;

public class LocalDateTimeAdapter
extends TypeAdapter<LocalDateTime> {
    private static final DateTimeFormatter formatter = DateTimeFormatter.ISO_LOCAL_DATE_TIME;

    @Override
    public void write(JsonWriter out, LocalDateTime value) throws IOException {
        if (value == null) {
            out.nullValue();
            return;
        }
        out.value(value.format(formatter));
    }

    @Override
    public LocalDateTime read(JsonReader in) throws IOException {
        JsonToken token = in.peek();
        if (token == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        if (token == JsonToken.STRING) {
            String dateString = in.nextString();
            return LocalDateTime.parse(dateString, formatter);
        }
        if (token == JsonToken.NUMBER) {
            long epochSeconds = in.nextLong();
            return LocalDateTime.ofEpochSecond(epochSeconds, 0, ZoneOffset.UTC);
        }
        if (token == JsonToken.BEGIN_OBJECT) {
            return this.parseObject(in);
        }
        throw new IOException("Invalid JSON format for LocalDateTime: Expected STRING, NUMBER, or OBJECT, but got " + String.valueOf((Object)token));
    }

    private LocalDateTime parseObject(JsonReader in) throws IOException {
        in.beginObject();
        Date date = new Date();
        Time time = new Time();
        block8: while (in.hasNext()) {
            String name;
            switch (name = in.nextName()) {
                case "date": {
                    date = this.parseDate(in);
                    continue block8;
                }
                case "time": {
                    time = this.parseTime(in);
                    continue block8;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return LocalDateTime.of(date.year, date.month, date.day, time.hour, time.minute, time.second, time.nano);
    }

    private Date parseDate(JsonReader in) throws IOException {
        in.beginObject();
        Date date = new Date();
        block10: while (in.hasNext()) {
            String datePart;
            switch (datePart = in.nextName()) {
                case "year": {
                    date.year = in.nextInt();
                    continue block10;
                }
                case "month": {
                    date.month = in.nextInt();
                    continue block10;
                }
                case "day": {
                    date.day = in.nextInt();
                    continue block10;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return date;
    }

    private Time parseTime(JsonReader in) throws IOException {
        in.beginObject();
        Time time = new Time();
        block12: while (in.hasNext()) {
            String timePart;
            switch (timePart = in.nextName()) {
                case "hour": {
                    time.hour = in.nextInt();
                    continue block12;
                }
                case "minute": {
                    time.minute = in.nextInt();
                    continue block12;
                }
                case "second": {
                    time.second = in.nextInt();
                    continue block12;
                }
                case "nano": {
                    time.nano = in.nextInt();
                    continue block12;
                }
            }
            in.skipValue();
        }
        in.endObject();
        return time;
    }

    private static final class Date {
        int year;
        int month;
        int day;

        private Date() {
        }
    }

    private static final class Time {
        int hour;
        int minute;
        int second;
        int nano;

        private Time() {
        }
    }
}

